/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.kdoc;

import com.facebook.ktfmt.kdoc.KDocFormattingOptions;
import com.facebook.ktfmt.kdoc.ParagraphListBuilderKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u000f\n\u0002\u0010\u001c\n\u0002\b\u0003\u001a6\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0007\u001a\u001e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0005\u001a\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0007\u001a$\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tH\u0002\u001a\u0016\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015\u001a*\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00072\b\b\u0002\u0010\u0019\u001a\u00020\u00072\b\b\u0002\u0010\u001a\u001a\u00020\u0007\u001a\n\u0010\u001b\u001a\u00020\u0005*\u00020\u0005\u001a\f\u0010\u001c\u001a\u0004\u0018\u00010\u0005*\u00020\u0005\u001a\n\u0010\u001d\u001a\u00020\u001e*\u00020\u0005\u001a\n\u0010\u001f\u001a\u00020\u001e*\u00020\u0005\u001a\n\u0010 \u001a\u00020\u001e*\u00020\u0005\u001a\n\u0010!\u001a\u00020\u001e*\u00020\u0005\u001a\u0014\u0010\"\u001a\u00020\u001e*\u00020\u00052\b\b\u0002\u0010#\u001a\u00020\u0007\u001a\n\u0010$\u001a\u00020\u001e*\u00020\u0005\u001a\n\u0010%\u001a\u00020\u001e*\u00020\u0005\u001a\n\u0010&\u001a\u00020\u001e*\u00020\u0005\u001a?\u0010'\u001a\u0002H(\"\u0004\b\u0000\u0010)\"\u000e\b\u0001\u0010(*\b\u0012\u0004\u0012\u0002H(0**\b\u0012\u0004\u0012\u0002H)0+2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u0002H)\u0012\u0004\u0012\u0002H(0\t\u00a2\u0006\u0002\u0010-\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"numberPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "computeIndents", "Lkotlin/Pair;", "", "start", "", "lookup", "Lkotlin/Function1;", "", "max", "findSamePosition", "comment", "delta", "reformattedComment", "getIndent", "width", "getIndentSize", "indent", "options", "Lcom/facebook/ktfmt/kdoc/KDocFormattingOptions;", "getLineNumber", "source", "offset", "startLine", "startOffset", "collapseSpaces", "getParamName", "isDirectiveMarker", "", "isExpectingMore", "isHeader", "isKDocTag", "isLine", "minCount", "isListItem", "isQuoted", "isTodo", "maxOf", "R", "T", "", "", "selector", "(Ljava/lang/Iterable;Lkotlin/jvm/functions/Function1;)Ljava/lang/Comparable;", "ktfmt"})
public final class UtilitiesKt {
    private static final Pattern numberPattern = Pattern.compile("^\\d+([.)]) ");

    @NotNull
    public static final String getIndent(int width) {
        StringBuilder sb = new StringBuilder();
        int n = 0;
        while (n < width) {
            int i = n++;
            sb.append(' ');
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    public static final int getIndentSize(@NotNull String indent, @NotNull KDocFormattingOptions options) {
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        int size = 0;
        int n = indent.length();
        for (int i = 0; i < n; ++i) {
            char c = indent.charAt(i);
            if (c == '\t') {
                size += options.getTabWidth();
                continue;
            }
            int n2 = size;
            size = n2 + 1;
        }
        return size;
    }

    public static final int getLineNumber(@NotNull String source, int offset, int startLine, int startOffset) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        int line2 = startLine;
        int n = startOffset;
        while (n < offset) {
            int i;
            char c;
            if ((c = source.charAt(i = n++)) != '\n') continue;
            int n2 = line2;
            line2 = n2 + 1;
        }
        return line2;
    }

    public static /* synthetic */ int getLineNumber$default(String string, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = 1;
        }
        if ((n4 & 8) != 0) {
            n3 = 0;
        }
        return UtilitiesKt.getLineNumber(string, n, n2, n3);
    }

    public static final boolean isListItem(@NotNull String $this$isListItem) {
        Character c;
        Intrinsics.checkNotNullParameter((Object)$this$isListItem, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$isListItem, (String)"- ", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isListItem, (String)"* ", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isListItem, (String)"+ ", (boolean)false, (int)2, null) || ((c = StringsKt.firstOrNull((CharSequence)$this$isListItem)) == null ? false : Character.isDigit(c.charValue())) && numberPattern.matcher($this$isListItem).find() || StringsKt.startsWith((String)$this$isListItem, (String)"<li>", (boolean)true);
    }

    @NotNull
    public static final String collapseSpaces(@NotNull String $this$collapseSpaces) {
        Intrinsics.checkNotNullParameter((Object)$this$collapseSpaces, (String)"<this>");
        if (StringsKt.indexOf$default((CharSequence)$this$collapseSpaces, (String)"  ", (int)0, (boolean)false, (int)6, null) == -1) {
            return ((Object)StringsKt.trimEnd((CharSequence)$this$collapseSpaces)).toString();
        }
        StringBuilder sb = new StringBuilder();
        char prev = $this$collapseSpaces.charAt(0);
        int n = 0;
        int n2 = $this$collapseSpaces.length();
        while (n < n2) {
            int i = n++;
            if (prev == ' ' && $this$collapseSpaces.charAt(i) == ' ') continue;
            sb.append($this$collapseSpaces.charAt(i));
            prev = $this$collapseSpaces.charAt(i);
        }
        return ((Object)StringsKt.trimEnd((CharSequence)sb)).toString();
    }

    public static final boolean isTodo(@NotNull String $this$isTodo) {
        Intrinsics.checkNotNullParameter((Object)$this$isTodo, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$isTodo, (String)"TODO:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isTodo, (String)"TODO(", (boolean)false, (int)2, null);
    }

    public static final boolean isHeader(@NotNull String $this$isHeader) {
        Intrinsics.checkNotNullParameter((Object)$this$isHeader, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$isHeader, (String)"#", (boolean)false, (int)2, null) || StringsKt.startsWith((String)$this$isHeader, (String)"<h", (boolean)true);
    }

    public static final boolean isQuoted(@NotNull String $this$isQuoted) {
        Intrinsics.checkNotNullParameter((Object)$this$isQuoted, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$isQuoted, (String)"> ", (boolean)false, (int)2, null);
    }

    public static final boolean isDirectiveMarker(@NotNull String $this$isDirectiveMarker) {
        Intrinsics.checkNotNullParameter((Object)$this$isDirectiveMarker, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$isDirectiveMarker, (String)"<!--", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isDirectiveMarker, (String)"-->", (boolean)false, (int)2, null);
    }

    public static final boolean isExpectingMore(@NotNull String $this$isExpectingMore) {
        Character c;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$isExpectingMore, (String)"<this>");
            CharSequence $this$lastOrNull$iv = $this$isExpectingMore;
            boolean $i$f$lastOrNull = false;
            int n = $this$lastOrNull$iv.length() + -1;
            if (0 <= n) {
                do {
                    char element$iv;
                    int index$iv = n--;
                    char it = element$iv = $this$lastOrNull$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(!CharsKt.isWhitespace((char)it))) continue;
                    c = Character.valueOf(element$iv);
                    break block3;
                } while (0 <= n);
            }
            c = null;
        }
        if (c == null) {
            return false;
        }
        char last = c.charValue();
        return last == ':' || last == ',';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isLine(@NotNull String $this$isLine, int minCount) {
        char it;
        char element$iv;
        int n;
        CharSequence charSequence;
        int count$iv;
        boolean $i$f$count;
        char[] cArray;
        Intrinsics.checkNotNullParameter((Object)$this$isLine, (String)"<this>");
        if (StringsKt.startsWith$default((CharSequence)$this$isLine, (char)'-', (boolean)false, (int)2, null) && ParagraphListBuilderKt.containsOnly($this$isLine, cArray = new char[]{'-', ' '})) {
            CharSequence charSequence2 = $this$isLine;
            $i$f$count = false;
            count$iv = 0;
            charSequence = charSequence2;
            for (n = 0; n < charSequence.length(); ++n) {
                element$iv = charSequence.charAt(n);
                it = element$iv;
                boolean bl = false;
                if (!(it == '-')) continue;
                ++count$iv;
            }
            if (count$iv >= minCount) return true;
        }
        if (!StringsKt.startsWith$default((CharSequence)$this$isLine, (char)'_', (boolean)false, (int)2, null)) return false;
        char[] cArray2 = new char[]{'_', ' '};
        if (!ParagraphListBuilderKt.containsOnly($this$isLine, cArray2)) return false;
        CharSequence charSequence3 = $this$isLine;
        $i$f$count = false;
        count$iv = 0;
        charSequence = charSequence3;
        for (n = 0; n < charSequence.length(); ++n) {
            element$iv = charSequence.charAt(n);
            it = element$iv;
            boolean bl = false;
            if (!(it == '_')) continue;
            ++count$iv;
        }
        if (count$iv < minCount) return false;
        return true;
    }

    public static /* synthetic */ boolean isLine$default(String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 3;
        }
        return UtilitiesKt.isLine(string, n);
    }

    public static final boolean isKDocTag(@NotNull String $this$isKDocTag) {
        Intrinsics.checkNotNullParameter((Object)$this$isKDocTag, (String)"<this>");
        if (StringsKt.startsWith$default((String)$this$isKDocTag, (String)"@", (boolean)false, (int)2, null) && $this$isKDocTag.length() > 1) {
            int n = 1;
            int n2 = $this$isKDocTag.length();
            while (n < n2) {
                int i;
                char c;
                if (CharsKt.isWhitespace((char)(c = $this$isKDocTag.charAt(i = n++)))) {
                    return i > 2;
                }
                if (Character.isLetter(c) && Character.isLowerCase(c)) continue;
                if (c == '[' && (StringsKt.startsWith$default((String)$this$isKDocTag, (String)"@param", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isKDocTag, (String)"@property", (boolean)false, (int)2, null))) {
                    return true;
                }
                return i == 1 && Character.isLetter(c) && Character.isUpperCase(c);
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static final String getParamName(@NotNull String $this$getParamName) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$getParamName, (String)"<this>");
        int length = $this$getParamName.length();
        int start = 0;
        while (start < length && CharsKt.isWhitespace((char)$this$getParamName.charAt(start))) {
            n = start;
            start = n + 1;
        }
        if (!StringsKt.startsWith$default((String)$this$getParamName, (String)"@param", (int)start, (boolean)false, (int)4, null)) {
            return null;
        }
        start += "@param".length();
        while (start < length && CharsKt.isWhitespace((char)$this$getParamName.charAt(start))) {
            n = start;
            start = n + 1;
        }
        if (start < length && $this$getParamName.charAt(start) == '[') {
            n = start;
            start = n + 1;
            while (start < length && CharsKt.isWhitespace((char)$this$getParamName.charAt(start))) {
                n = start;
                start = n + 1;
            }
        }
        int end = start;
        while (end < length && Character.isJavaIdentifierPart($this$getParamName.charAt(end))) {
            int n2 = end;
            end = n2 + 1;
        }
        if (end > start) {
            String string = $this$getParamName.substring(start, end);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string;
        }
        return null;
    }

    private static final String getIndent(int start, Function1<? super Integer, Character> lookup) {
        int i = start - 1;
        while (i >= 0 && ((Character)lookup.invoke((Object)i)).charValue() != '\n') {
            int n = i;
            i = n + -1;
        }
        StringBuilder sb = new StringBuilder();
        int n = i + 1;
        while (n < start) {
            int j = n++;
            sb.append(((Character)lookup.invoke((Object)j)).charValue());
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<String, String> computeIndents(int start, @NotNull Function1<? super Integer, Character> lookup, int max) {
        String string;
        String indent;
        String string2;
        boolean suffix;
        boolean bl;
        String originalIndent;
        block12: {
            Intrinsics.checkNotNullParameter(lookup, (String)"lookup");
            originalIndent = UtilitiesKt.getIndent(start, lookup);
            CharSequence $this$all$iv = originalIndent;
            boolean $i$f$all = false;
            CharSequence charSequence = $this$all$iv;
            for (int i = 0; i < charSequence.length(); ++i) {
                char element$iv = charSequence.charAt(i);
                char it = element$iv;
                boolean bl2 = false;
                if (CharsKt.isWhitespace((char)it)) continue;
                bl = false;
                break block12;
            }
            bl = true;
        }
        boolean bl3 = suffix = !bl;
        if (suffix) {
            void $this$mapTo$iv$iv;
            CharSequence $this$map$iv = originalIndent;
            boolean $i$f$map = false;
            CharSequence charSequence = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length());
            boolean $i$f$mapTo = false;
            void var11_21 = $this$mapTo$iv$iv;
            for (int i = 0; i < var11_21.length(); ++i) {
                char it;
                char item$iv$iv = var11_21.charAt(i);
                char c = item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(Character.valueOf(CharsKt.isWhitespace((char)it) ? it : (char)' '));
            }
            string2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
        } else {
            string2 = indent = originalIndent;
        }
        if (suffix) {
            int offset = start;
            while (offset < max && ((Character)lookup.invoke((Object)offset)).charValue() != '\n') {
                int destination$iv$iv = offset;
                offset = destination$iv$iv + 1;
            }
            int destination$iv$iv = offset;
            offset = destination$iv$iv + 1;
            StringBuilder sb = new StringBuilder();
            while (offset < max) {
                if (((Character)lookup.invoke((Object)offset)).charValue() == '\n') {
                    StringsKt.clear((StringBuilder)sb);
                } else {
                    char c = ((Character)lookup.invoke((Object)offset)).charValue();
                    if (CharsKt.isWhitespace((char)c)) {
                        sb.append(c);
                    } else {
                        if (c != '*') break;
                        sb.setLength(sb.length() - 1);
                        break;
                    }
                }
                int n = offset;
                offset = n + 1;
            }
            string = sb.toString();
        } else {
            string = originalIndent;
        }
        String string3 = string;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"if (suffix) {\n        //\u2026   originalIndent\n      }");
        String secondaryIndent = string3;
        return new Pair((Object)indent, (Object)secondaryIndent);
    }

    public static final int findSamePosition(@NotNull String comment, int delta, @NotNull String reformattedComment) {
        int i;
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Intrinsics.checkNotNullParameter((Object)reformattedComment, (String)"reformattedComment");
        int n = 0;
        int n2 = Math.min(comment.length(), reformattedComment.length());
        while (n < n2) {
            if ((i = n++) == delta) {
                return delta;
            }
            if (comment.charAt(i) == reformattedComment.charAt(i)) continue;
        }
        int i2 = comment.length() - 1;
        int j = reformattedComment.length() - 1;
        if (delta == i2 + 1) {
            return j + 1;
        }
        while (i2 >= 0 && j >= 0) {
            if (i2 == delta) {
                return j;
            }
            if (comment.charAt(i2) != reformattedComment.charAt(j)) break;
            i = i2;
            i2 = i + -1;
            i = j;
            j = i + -1;
        }
        int offset = 0;
        int reformattedOffset = 0;
        while (offset < delta && reformattedOffset < reformattedComment.length()) {
            offset = UtilitiesKt.findSamePosition$nextSignificantChar(comment, offset);
            reformattedOffset = UtilitiesKt.findSamePosition$nextSignificantChar(reformattedComment, reformattedOffset);
            if (offset == delta) {
                return reformattedOffset;
            }
            int n3 = offset;
            offset = n3 + 1;
            n3 = reformattedOffset;
            reformattedOffset = n3 + 1;
        }
        return reformattedOffset;
    }

    @NotNull
    public static final <T, R extends Comparable<? super R>> R maxOf(@NotNull Iterable<? extends T> $this$maxOf, @NotNull Function1<? super T, ? extends R> selector) {
        Intrinsics.checkNotNullParameter($this$maxOf, (String)"<this>");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        Iterator<T> iterator = $this$maxOf.iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        Comparable maxValue = (Comparable)selector.invoke(iterator.next());
        while (iterator.hasNext()) {
            Comparable v = (Comparable)selector.invoke(iterator.next());
            if (maxValue.compareTo(v) >= 0) continue;
            maxValue = v;
        }
        return (R)maxValue;
    }

    private static final boolean findSamePosition$isSignificantChar(char c) {
        return CharsKt.isWhitespace((char)c) || c == '*';
    }

    private static final int findSamePosition$nextSignificantChar(String s, int from) {
        char c;
        int curr = from;
        while (curr < s.length() && UtilitiesKt.findSamePosition$isSignificantChar(c = s.charAt(curr))) {
            int n = curr;
            curr = n + 1;
        }
        return curr;
    }
}

