/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.ktfmt.kdoc;

import com.facebook.ktfmt.kdoc.KDocToken;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0000\u0018\u00002\u00020\u0001:\u00011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u0006\u0010\u0018\u001a\u00020\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0002J\u0006\u0010\u001a\u001a\u00020\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0002J\u0006\u0010\u001c\u001a\u00020\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u001d\u001a\u00020\rH\u0016J\u0006\u0010\u001e\u001a\u00020\u0016J\b\u0010\u001f\u001a\u00020\u0016H\u0002J\u000e\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"J\u000e\u0010$\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"J\u0006\u0010%\u001a\u00020\u0016J\u000e\u0010&\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"J\u000e\u0010'\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"J\u000e\u0010(\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"J\u000e\u0010)\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"J\b\u0010*\u001a\u00020\u0016H\u0002J\u000e\u0010+\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"J\u000e\u0010,\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"J\u000e\u0010-\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"J\u000e\u0010.\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"J\u000e\u0010/\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"J\u0010\u00100\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"H\u0002R2\u0010\u0006\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \t*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/facebook/ktfmt/kdoc/KDocWriter;", "", "blockIndentCount", "", "maxLineLength", "(II)V", "START_OF_LINE_TOKENS", "Lcom/google/common/collect/ImmutableSet;", "Lcom/facebook/ktfmt/kdoc/KDocToken$Type;", "kotlin.jvm.PlatformType", "atStartOfLine", "", "blockIndent", "", "inCodeBlock", "output", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "remainingOnLine", "requestedWhitespace", "Lcom/facebook/ktfmt/kdoc/KDocWriter$RequestedWhitespace;", "appendTrackingLength", "", "str", "requestBlankLine", "requestCloseCodeBlockMarker", "requestNewline", "requestOpenCodeBlockMarker", "requestWhitespace", "toString", "writeBeginJavadoc", "writeBlankLine", "writeCodeClose", "token", "Lcom/facebook/ktfmt/kdoc/KDocToken;", "writeCodeLine", "writeCodeOpen", "writeEndJavadoc", "writeExplicitCodeBlockMarker", "writeListItemOpen", "writeLiteral", "writeMarkdownLink", "writeNewline", "writePreClose", "writePreOpen", "writeTableClose", "writeTableOpen", "writeTag", "writeToken", "RequestedWhitespace", "ktfmt"})
public final class KDocWriter {
    private final int maxLineLength;
    private final ImmutableSet<KDocToken.Type> START_OF_LINE_TOKENS;
    @NotNull
    private final StringBuilder output;
    private final String blockIndent;
    private int remainingOnLine;
    private boolean atStartOfLine;
    private boolean inCodeBlock;
    @NotNull
    private RequestedWhitespace requestedWhitespace;

    public KDocWriter(int blockIndentCount, int maxLineLength) {
        this.maxLineLength = maxLineLength;
        KDocToken.Type[] typeArray = new KDocToken.Type[]{KDocToken.Type.PARAGRAPH_OPEN_TAG, KDocToken.Type.HEADER_OPEN_TAG};
        this.START_OF_LINE_TOKENS = Sets.immutableEnumSet((Enum)KDocToken.Type.LIST_ITEM_OPEN_TAG, (Enum[])typeArray);
        this.output = new StringBuilder();
        this.blockIndent = Strings.repeat((String)" ", (int)(blockIndentCount + 1));
        this.requestedWhitespace = RequestedWhitespace.NONE;
    }

    public final void requestWhitespace() {
        this.requestWhitespace(RequestedWhitespace.WHITESPACE);
    }

    public final void writeBeginJavadoc() {
        this.appendTrackingLength("/**");
    }

    public final void writeEndJavadoc() {
        this.requestCloseCodeBlockMarker();
        this.output.append("\n");
        String string = this.blockIndent;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"blockIndent");
        this.appendTrackingLength(string);
        this.appendTrackingLength("*/");
    }

    public final void writeListItemOpen(@NotNull KDocToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.requestCloseCodeBlockMarker();
        this.requestNewline();
        this.writeToken(token);
    }

    public final void writePreOpen(@NotNull KDocToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.requestBlankLine();
        this.writeToken(token);
    }

    public final void writePreClose(@NotNull KDocToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.writeToken(token);
        this.requestBlankLine();
    }

    public final void writeCodeOpen(@NotNull KDocToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.writeToken(token);
    }

    public final void writeCodeClose(@NotNull KDocToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.writeToken(token);
    }

    public final void writeTableOpen(@NotNull KDocToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.requestBlankLine();
        this.writeToken(token);
    }

    public final void writeTableClose(@NotNull KDocToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.writeToken(token);
        this.requestBlankLine();
    }

    public final void writeTag(@NotNull KDocToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.requestNewline();
        this.writeToken(token);
    }

    public final void writeCodeLine(@NotNull KDocToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.requestOpenCodeBlockMarker();
        this.requestNewline();
        if (((CharSequence)token.getValue()).length() > 0) {
            this.writeToken(token);
        }
    }

    private final void requestCloseCodeBlockMarker() {
        if (this.inCodeBlock) {
            this.requestedWhitespace = RequestedWhitespace.NEWLINE;
            this.writeExplicitCodeBlockMarker(new KDocToken(KDocToken.Type.CODE_BLOCK_MARKER, "```"));
        }
    }

    private final void requestOpenCodeBlockMarker() {
        if (!this.inCodeBlock) {
            this.requestedWhitespace = RequestedWhitespace.NEWLINE;
            this.writeExplicitCodeBlockMarker(new KDocToken(KDocToken.Type.CODE_BLOCK_MARKER, "```"));
        }
    }

    public final void writeExplicitCodeBlockMarker(@NotNull KDocToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.requestNewline();
        this.writeToken(token);
        this.requestNewline();
        this.inCodeBlock = !this.inCodeBlock;
    }

    public final void writeLiteral(@NotNull KDocToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.requestCloseCodeBlockMarker();
        this.writeToken(token);
    }

    public final void writeMarkdownLink(@NotNull KDocToken token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.writeToken(token);
    }

    @NotNull
    public String toString() {
        String string = this.output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"output.toString()");
        return string;
    }

    public final void requestBlankLine() {
        this.requestWhitespace(RequestedWhitespace.BLANK_LINE);
    }

    public final void requestNewline() {
        this.requestWhitespace(RequestedWhitespace.NEWLINE);
    }

    private final void requestWhitespace(RequestedWhitespace requestedWhitespace) {
        Object object = Ordering.natural().max((Object)requestedWhitespace, (Object)this.requestedWhitespace);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"natural<Comparable<*>>()\u2026this.requestedWhitespace)");
        this.requestedWhitespace = (RequestedWhitespace)((Object)object);
    }

    private final void writeToken(KDocToken token) {
        boolean needWhitespace;
        if (this.requestedWhitespace == RequestedWhitespace.BLANK_LINE) {
            this.writeBlankLine();
            this.requestedWhitespace = RequestedWhitespace.NONE;
        } else if (this.requestedWhitespace == RequestedWhitespace.NEWLINE) {
            this.writeNewline();
            this.requestedWhitespace = RequestedWhitespace.NONE;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.requestedWhitespace.ordinal()]) {
            case 1: {
                boolean bl = true;
                break;
            }
            case 2: {
                boolean bl = Character.isLetterOrDigit(StringsKt.first((CharSequence)token.getValue()));
                break;
            }
            default: {
                boolean bl = needWhitespace = false;
            }
        }
        if (!this.atStartOfLine && token.length() + (needWhitespace ? 1 : 0) > this.remainingOnLine) {
            this.writeNewline();
        }
        if (!this.atStartOfLine && needWhitespace) {
            this.appendTrackingLength(" ");
        }
        this.appendTrackingLength(token.getValue());
        this.requestedWhitespace = RequestedWhitespace.NONE;
        if (!this.START_OF_LINE_TOKENS.contains((Object)token.getType())) {
            this.atStartOfLine = false;
        }
    }

    private final void writeBlankLine() {
        this.output.append("\n");
        String string = this.blockIndent;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"blockIndent");
        this.appendTrackingLength(string);
        this.appendTrackingLength("*");
        this.writeNewline();
    }

    private final void writeNewline() {
        this.output.append("\n");
        this.remainingOnLine = this.maxLineLength;
        String string = this.blockIndent;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"blockIndent");
        this.appendTrackingLength(string);
        this.appendTrackingLength("* ");
        this.atStartOfLine = true;
    }

    private final void appendTrackingLength(String str) {
        this.output.append(str);
        this.remainingOnLine -= str.length();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/facebook/ktfmt/kdoc/KDocWriter$RequestedWhitespace;", "", "(Ljava/lang/String;I)V", "NONE", "CONDITIONAL_WHITESPACE", "WHITESPACE", "NEWLINE", "BLANK_LINE", "ktfmt"})
    public static final class RequestedWhitespace
    extends Enum<RequestedWhitespace> {
        public static final /* enum */ RequestedWhitespace NONE = new RequestedWhitespace();
        public static final /* enum */ RequestedWhitespace CONDITIONAL_WHITESPACE = new RequestedWhitespace();
        public static final /* enum */ RequestedWhitespace WHITESPACE = new RequestedWhitespace();
        public static final /* enum */ RequestedWhitespace NEWLINE = new RequestedWhitespace();
        public static final /* enum */ RequestedWhitespace BLANK_LINE = new RequestedWhitespace();
        private static final /* synthetic */ RequestedWhitespace[] $VALUES;

        public static RequestedWhitespace[] values() {
            return (RequestedWhitespace[])$VALUES.clone();
        }

        public static RequestedWhitespace valueOf(String value) {
            return Enum.valueOf(RequestedWhitespace.class, value);
        }

        static {
            $VALUES = requestedWhitespaceArray = new RequestedWhitespace[]{RequestedWhitespace.NONE, RequestedWhitespace.CONDITIONAL_WHITESPACE, RequestedWhitespace.WHITESPACE, RequestedWhitespace.NEWLINE, RequestedWhitespace.BLANK_LINE};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RequestedWhitespace.values().length];
            nArray[RequestedWhitespace.WHITESPACE.ordinal()] = 1;
            nArray[RequestedWhitespace.CONDITIONAL_WHITESPACE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

