/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.webpsupport;

import android.graphics.Bitmap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imagepipeline.bitmaps.SimpleBitmapReleaser;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.decoder.ImageDecoder;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.image.QualityInfo;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.webpsupport.WebpBitmapFactoryImpl;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class WebPImageDecoder
implements ImageDecoder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CloseableImage decode(EncodedImage encodedImage, int length, QualityInfo qualityInfo, ImageDecodeOptions options) {
        CloseableReference bytesRef = encodedImage.getByteBufferRef();
        Preconditions.checkNotNull((Object)bytesRef);
        try {
            PooledByteBuffer input = (PooledByteBuffer)bytesRef.get();
            ByteBuffer buffer = input.getByteBuffer();
            if (buffer != null) {
                CloseableImage closeableImage = WebPImageDecoder.decodeByteBuffer(buffer, encodedImage, length, qualityInfo, options);
                return closeableImage;
            }
        }
        finally {
            CloseableReference.closeSafely((CloseableReference)bytesRef);
        }
        return WebPImageDecoder.decodeInputStream(encodedImage, length, qualityInfo, options);
    }

    @Nullable
    private static CloseableImage decodeByteBuffer(ByteBuffer byteBuffer, EncodedImage encodedImage, int length, QualityInfo qualityInfo, ImageDecodeOptions options) {
        Bitmap bitmap = WebpBitmapFactoryImpl.hookDecodeByteArray(byteBuffer.array(), 0, length);
        return WebPImageDecoder.bitmapToCloseableImage(bitmap, encodedImage, qualityInfo);
    }

    @Nullable
    private static CloseableImage decodeInputStream(EncodedImage encodedImage, int length, QualityInfo qualityInfo, ImageDecodeOptions options) {
        CloseableImage closeableImage;
        block8: {
            InputStream is = encodedImage.getInputStreamOrThrow();
            try {
                Bitmap bitmap = WebpBitmapFactoryImpl.hookDecodeStream(is, null, null);
                closeableImage = WebPImageDecoder.bitmapToCloseableImage(bitmap, encodedImage, qualityInfo);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Error while decoding WebP", e);
                }
            }
            is.close();
        }
        return closeableImage;
    }

    @Nullable
    private static CloseableImage bitmapToCloseableImage(@Nullable Bitmap bitmap, EncodedImage encodedImage, QualityInfo qualityInfo) {
        if (bitmap == null) {
            return null;
        }
        CloseableReference bitmapRef = CloseableReference.of((Object)bitmap, (ResourceReleaser)SimpleBitmapReleaser.getInstance());
        return CloseableStaticBitmap.of((CloseableReference)bitmapRef, (QualityInfo)qualityInfo, (int)encodedImage.getRotationAngle());
    }
}

