/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.content.ContentResolver;
import com.facebook.common.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.LocalFetchProducer;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u000fH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/facebook/imagepipeline/producers/QualifiedResourceFetchProducer;", "Lcom/facebook/imagepipeline/producers/LocalFetchProducer;", "executor", "Ljava/util/concurrent/Executor;", "pooledByteBufferFactory", "Lcom/facebook/common/memory/PooledByteBufferFactory;", "contentResolver", "Landroid/content/ContentResolver;", "<init>", "(Ljava/util/concurrent/Executor;Lcom/facebook/common/memory/PooledByteBufferFactory;Landroid/content/ContentResolver;)V", "getEncodedImage", "Lcom/facebook/imagepipeline/image/EncodedImage;", "imageRequest", "Lcom/facebook/imagepipeline/request/ImageRequest;", "getProducerName", "", "Companion", "imagepipeline_release"})
public final class QualifiedResourceFetchProducer
extends LocalFetchProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ContentResolver contentResolver;
    @NotNull
    public static final String PRODUCER_NAME = "QualifiedResourceFetchProducer";

    public QualifiedResourceFetchProducer(@NotNull Executor executor, @NotNull PooledByteBufferFactory pooledByteBufferFactory, @NotNull ContentResolver contentResolver) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)pooledByteBufferFactory, (String)"pooledByteBufferFactory");
        Intrinsics.checkNotNullParameter((Object)contentResolver, (String)"contentResolver");
        super(executor, pooledByteBufferFactory);
        this.contentResolver = contentResolver;
    }

    @Override
    @NotNull
    protected EncodedImage getEncodedImage(@NotNull ImageRequest imageRequest) throws IOException {
        Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"imageRequest");
        QualifiedResourceFetchProducer qualifiedResourceFetchProducer = this;
        InputStream inputStream = this.contentResolver.openInputStream(imageRequest.getSourceUri());
        if (inputStream == null) {
            QualifiedResourceFetchProducer qualifiedResourceFetchProducer2 = qualifiedResourceFetchProducer;
            boolean bl = false;
            QualifiedResourceFetchProducer qualifiedResourceFetchProducer3 = qualifiedResourceFetchProducer2;
            String string = "ContentResolver returned null InputStream";
            throw new IllegalStateException(string.toString());
        }
        EncodedImage encodedImage = qualifiedResourceFetchProducer.getEncodedImage(inputStream, -1);
        Intrinsics.checkNotNullExpressionValue((Object)encodedImage, (String)"getEncodedImage(...)");
        return encodedImage;
    }

    @Override
    @NotNull
    protected String getProducerName() {
        return PRODUCER_NAME;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/imagepipeline/producers/QualifiedResourceFetchProducer$Companion;", "", "<init>", "()V", "PRODUCER_NAME", "", "imagepipeline_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

