/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import android.provider.ContactsContract;
import com.facebook.common.memory.PooledByteBufferFactory;
import com.facebook.common.util.UriUtil;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.LocalFetchProducer;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/facebook/imagepipeline/producers/LocalContentUriFetchProducer;", "Lcom/facebook/imagepipeline/producers/LocalFetchProducer;", "executor", "Ljava/util/concurrent/Executor;", "pooledByteBufferFactory", "Lcom/facebook/common/memory/PooledByteBufferFactory;", "contentResolver", "Landroid/content/ContentResolver;", "<init>", "(Ljava/util/concurrent/Executor;Lcom/facebook/common/memory/PooledByteBufferFactory;Landroid/content/ContentResolver;)V", "getEncodedImage", "Lcom/facebook/imagepipeline/image/EncodedImage;", "imageRequest", "Lcom/facebook/imagepipeline/request/ImageRequest;", "getCameraImage", "uri", "Landroid/net/Uri;", "getProducerName", "", "Companion", "imagepipeline_release"})
public final class LocalContentUriFetchProducer
extends LocalFetchProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ContentResolver contentResolver;
    @NotNull
    public static final String PRODUCER_NAME = "LocalContentUriFetchProducer";
    @NotNull
    private static final String[] PROJECTION;

    public LocalContentUriFetchProducer(@NotNull Executor executor, @NotNull PooledByteBufferFactory pooledByteBufferFactory, @NotNull ContentResolver contentResolver) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)pooledByteBufferFactory, (String)"pooledByteBufferFactory");
        Intrinsics.checkNotNullParameter((Object)contentResolver, (String)"contentResolver");
        super(executor, pooledByteBufferFactory);
        this.contentResolver = contentResolver;
    }

    @Override
    @Nullable
    protected EncodedImage getEncodedImage(@NotNull ImageRequest imageRequest) throws IOException {
        EncodedImage cameraImage;
        Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"imageRequest");
        Uri uri = imageRequest.getSourceUri();
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"getSourceUri(...)");
        Uri uri2 = uri;
        if (UriUtil.isLocalContactUri((Uri)uri2)) {
            Object object;
            InputStream inputStream = null;
            String string = uri2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            if (StringsKt.endsWith$default((String)string, (String)"/photo", (boolean)false, (int)2, null)) {
                inputStream = this.contentResolver.openInputStream(uri2);
            } else {
                String string2 = uri2.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                if (StringsKt.endsWith$default((String)string2, (String)"/display_photo", (boolean)false, (int)2, null)) {
                    try {
                        AssetFileDescriptor fd = this.contentResolver.openAssetFileDescriptor(uri2, "r");
                        if (fd == null) {
                            String string3 = "Required value was null.";
                            throw new IllegalStateException(string3.toString());
                        }
                        object = fd.createInputStream();
                    }
                    catch (IOException e) {
                        throw new IOException("Contact photo does not exist: " + uri2);
                    }
                    inputStream = (InputStream)object;
                } else {
                    inputStream = ContactsContract.Contacts.openContactPhotoInputStream((ContentResolver)this.contentResolver, (Uri)uri2);
                    if (inputStream == null) {
                        throw new IOException("Contact photo does not exist: " + uri2);
                    }
                }
            }
            if (inputStream == null) {
                object = "Required value was null.";
                throw new IllegalStateException(object.toString());
            }
            return this.getEncodedImage(inputStream, -1);
        }
        if (UriUtil.isLocalCameraUri((Uri)uri2) && (cameraImage = this.getCameraImage(uri2)) != null) {
            return cameraImage;
        }
        InputStream inputStream = this.contentResolver.openInputStream(uri2);
        if (inputStream == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return this.getEncodedImage(inputStream, -1);
    }

    private final EncodedImage getCameraImage(Uri uri) throws IOException {
        Object object;
        try {
            object = this.contentResolver.openFileDescriptor(uri, "r");
        }
        catch (FileNotFoundException e) {
            return null;
        }
        Object parcelFileDescriptor = object;
        if (parcelFileDescriptor == null) {
            object = "Required value was null.";
            throw new IllegalStateException(object.toString());
        }
        FileDescriptor fd = parcelFileDescriptor.getFileDescriptor();
        EncodedImage encodedImage = this.getEncodedImage(new FileInputStream(fd), (int)parcelFileDescriptor.getStatSize());
        Intrinsics.checkNotNullExpressionValue((Object)encodedImage, (String)"getEncodedImage(...)");
        EncodedImage encodedImage2 = encodedImage;
        parcelFileDescriptor.close();
        return encodedImage2;
    }

    @Override
    @NotNull
    protected String getProducerName() {
        return PRODUCER_NAME;
    }

    static {
        String[] stringArray = new String[]{"_id", "_data"};
        PROJECTION = stringArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/facebook/imagepipeline/producers/LocalContentUriFetchProducer$Companion;", "", "<init>", "()V", "PRODUCER_NAME", "", "PROJECTION", "", "[Ljava/lang/String;", "imagepipeline_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

