/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.core;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.media.MediaUtils;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.core.DownsampleMode;
import com.facebook.imagepipeline.core.ProducerFactory;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.AddImageTransformMetaDataProducer;
import com.facebook.imagepipeline.producers.BitmapMemoryCacheGetProducer;
import com.facebook.imagepipeline.producers.BitmapMemoryCacheKeyMultiplexProducer;
import com.facebook.imagepipeline.producers.BitmapMemoryCacheProducer;
import com.facebook.imagepipeline.producers.BitmapProbeProducer;
import com.facebook.imagepipeline.producers.BranchOnSeparateImagesProducer;
import com.facebook.imagepipeline.producers.CustomProducerSequenceFactory;
import com.facebook.imagepipeline.producers.DataFetchProducer;
import com.facebook.imagepipeline.producers.DecodeProducer;
import com.facebook.imagepipeline.producers.DelayProducer;
import com.facebook.imagepipeline.producers.DiskCacheReadProducer;
import com.facebook.imagepipeline.producers.DiskCacheWriteProducer;
import com.facebook.imagepipeline.producers.EncodedCacheKeyMultiplexProducer;
import com.facebook.imagepipeline.producers.EncodedProbeProducer;
import com.facebook.imagepipeline.producers.LocalAssetFetchProducer;
import com.facebook.imagepipeline.producers.LocalContentUriFetchProducer;
import com.facebook.imagepipeline.producers.LocalFileFetchProducer;
import com.facebook.imagepipeline.producers.LocalResourceFetchProducer;
import com.facebook.imagepipeline.producers.LocalThumbnailBitmapSdk29Producer;
import com.facebook.imagepipeline.producers.LocalVideoThumbnailProducer;
import com.facebook.imagepipeline.producers.NetworkFetcher;
import com.facebook.imagepipeline.producers.PartialDiskCacheProducer;
import com.facebook.imagepipeline.producers.PostprocessorProducer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.QualifiedResourceFetchProducer;
import com.facebook.imagepipeline.producers.RemoveImageTransformMetaDataProducer;
import com.facebook.imagepipeline.producers.ResizeAndRotateProducer;
import com.facebook.imagepipeline.producers.SwallowResultProducer;
import com.facebook.imagepipeline.producers.ThreadHandoffProducerQueue;
import com.facebook.imagepipeline.producers.ThrottlingProducer;
import com.facebook.imagepipeline.producers.ThumbnailBranchProducer;
import com.facebook.imagepipeline.producers.ThumbnailProducer;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.systrace.FrescoSystrace;
import com.facebook.imagepipeline.transcoder.ImageTranscoderFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b-\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 \u0084\u00012\u00020\u0001:\u0002\u0084\u0001B\u008b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\t\u0012\u0006\u0010\u0010\u001a\u00020\t\u0012\u0006\u0010\u0011\u001a\u00020\t\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\t\u0012\u0006\u0010\u0015\u001a\u00020\t\u0012\u0006\u0010\u0016\u001a\u00020\t\u0012\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001a\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002010\u001f0\u001e2\u0006\u00102\u001a\u000203J\u0016\u0010@\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0\u001e2\u0006\u00102\u001a\u000203J\u001a\u0010A\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e2\u0006\u00102\u001a\u000203J\u0016\u0010B\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0\u001e2\u0006\u00102\u001a\u000203J\u001c\u0010C\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e2\u0006\u00102\u001a\u000203H\u0002J\u0018\u0010Q\u001a\b\u0012\u0004\u0012\u00020H0\u001e2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007J\"\u0010s\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e2\f\u0010t\u001a\b\u0012\u0004\u0012\u00020H0\u001eH\u0002J;\u0010s\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e2\f\u0010t\u001a\b\u0012\u0004\u0012\u00020H0\u001e2\u0012\u0010u\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020H0w0vH\u0002\u00a2\u0006\u0002\u0010xJ \u0010y\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e2\f\u0010t\u001a\b\u0012\u0004\u0012\u00020H0\u001eJ\u001c\u0010z\u001a\b\u0012\u0004\u0012\u00020H0\u001e2\f\u0010t\u001a\b\u0012\u0004\u0012\u00020H0\u001eH\u0002J\u001c\u0010{\u001a\b\u0012\u0004\u0012\u00020H0\u001e2\f\u0010t\u001a\b\u0012\u0004\u0012\u00020H0\u001eH\u0002J(\u0010|\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e2\u0012\u0010t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001eH\u0002J5\u0010}\u001a\b\u0012\u0004\u0012\u00020H0\u001e2\f\u0010t\u001a\b\u0012\u0004\u0012\u00020H0\u001e2\u0012\u0010u\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020H0w0vH\u0002\u00a2\u0006\u0002\u0010xJ'\u0010~\u001a\b\u0012\u0004\u0012\u00020H0\u001e2\u0012\u0010u\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020H0w0vH\u0002\u00a2\u0006\u0002\u0010\u007fJ)\u0010\u0080\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e2\u0012\u0010t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001eH\u0002J%\u0010\u0081\u0001\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0\u001e2\u0012\u0010t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001eH\u0002J)\u0010\u0082\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e2\u0012\u0010t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001eH\u0002J)\u0010\u0083\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e2\u0012\u0010t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000RH\u0010\u001c\u001a&\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e0\u001d8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&RD\u0010'\u001a\"\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010(0\u001e0\u001d8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b)\u0010\"\u001a\u0004\b*\u0010$\"\u0004\b+\u0010&RH\u0010,\u001a&\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e0\u001d8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b-\u0010\"\u001a\u0004\b.\u0010$\"\u0004\b/\u0010&R'\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002010\u001f0\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u00108\u001a\u0004\b5\u00106R-\u00109\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002010\u001f0\u001e8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b<\u00108\u0012\u0004\b:\u0010\"\u001a\u0004\b;\u00106R'\u0010=\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002010\u001f0\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b?\u00108\u001a\u0004\b>\u00106R'\u0010D\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bF\u00108\u001a\u0004\bE\u00106R#\u0010G\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010H0\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bJ\u00108\u001a\u0004\bI\u00106R#\u0010K\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bM\u00108\u001a\u0004\bL\u00106R!\u0010N\u001a\b\u0012\u0004\u0012\u00020H0\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bP\u00108\u001a\u0004\bO\u00106R#\u0010R\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010(0\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bT\u00108\u001a\u0004\bS\u00106R#\u0010U\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010H0\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bW\u00108\u001a\u0004\bV\u00106R#\u0010X\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010H0\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bZ\u00108\u001a\u0004\bY\u00106R'\u0010[\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b]\u00108\u001a\u0004\b\\\u00106R'\u0010^\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b`\u00108\u001a\u0004\b_\u00106R'\u0010a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bc\u00108\u001a\u0004\bb\u00106R'\u0010d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e8GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bf\u00108\u001a\u0004\be\u00106R'\u0010g\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bi\u00108\u001a\u0004\bh\u00106R'\u0010j\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bl\u00108\u001a\u0004\bk\u00106R'\u0010m\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bo\u00108\u001a\u0004\bn\u00106R'\u0010p\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\br\u00108\u001a\u0004\bq\u00106\u00a8\u0006\u0085\u0001"}, d2={"Lcom/facebook/imagepipeline/core/ProducerSequenceFactory;", "", "contentResolver", "Landroid/content/ContentResolver;", "producerFactory", "Lcom/facebook/imagepipeline/core/ProducerFactory;", "networkFetcher", "Lcom/facebook/imagepipeline/producers/NetworkFetcher;", "resizeAndRotateEnabledForNetwork", "", "webpSupportEnabled", "threadHandoffProducerQueue", "Lcom/facebook/imagepipeline/producers/ThreadHandoffProducerQueue;", "downsampleMode", "Lcom/facebook/imagepipeline/core/DownsampleMode;", "useBitmapPrepareToDraw", "partialImageCachingEnabled", "diskCacheEnabled", "imageTranscoderFactory", "Lcom/facebook/imagepipeline/transcoder/ImageTranscoderFactory;", "isEncodedMemoryCacheProbingEnabled", "isDiskCacheProbingEnabled", "allowDelay", "customProducerSequenceFactories", "", "Lcom/facebook/imagepipeline/producers/CustomProducerSequenceFactory;", "<init>", "(Landroid/content/ContentResolver;Lcom/facebook/imagepipeline/core/ProducerFactory;Lcom/facebook/imagepipeline/producers/NetworkFetcher;ZZLcom/facebook/imagepipeline/producers/ThreadHandoffProducerQueue;Lcom/facebook/imagepipeline/core/DownsampleMode;ZZZLcom/facebook/imagepipeline/transcoder/ImageTranscoderFactory;ZZZLjava/util/Set;)V", "postprocessorSequences", "", "Lcom/facebook/imagepipeline/producers/Producer;", "Lcom/facebook/common/references/CloseableReference;", "Lcom/facebook/imagepipeline/image/CloseableImage;", "getPostprocessorSequences$annotations", "()V", "getPostprocessorSequences", "()Ljava/util/Map;", "setPostprocessorSequences", "(Ljava/util/Map;)V", "closeableImagePrefetchSequences", "Ljava/lang/Void;", "getCloseableImagePrefetchSequences$annotations", "getCloseableImagePrefetchSequences", "setCloseableImagePrefetchSequences", "bitmapPrepareSequences", "getBitmapPrepareSequences$annotations", "getBitmapPrepareSequences", "setBitmapPrepareSequences", "getEncodedImageProducerSequence", "Lcom/facebook/common/memory/PooledByteBuffer;", "imageRequest", "Lcom/facebook/imagepipeline/request/ImageRequest;", "networkFetchEncodedImageProducerSequence", "getNetworkFetchEncodedImageProducerSequence", "()Lcom/facebook/imagepipeline/producers/Producer;", "networkFetchEncodedImageProducerSequence$delegate", "Lkotlin/Lazy;", "localFileFetchEncodedImageProducerSequence", "getLocalFileFetchEncodedImageProducerSequence$annotations", "getLocalFileFetchEncodedImageProducerSequence", "localFileFetchEncodedImageProducerSequence$delegate", "localContentUriFetchEncodedImageProducerSequence", "getLocalContentUriFetchEncodedImageProducerSequence", "localContentUriFetchEncodedImageProducerSequence$delegate", "getEncodedImagePrefetchProducerSequence", "getDecodedImageProducerSequence", "getDecodedImagePrefetchProducerSequence", "getBasicDecodedImageSequence", "networkFetchSequence", "getNetworkFetchSequence", "networkFetchSequence$delegate", "backgroundNetworkFetchToEncodedMemorySequence", "Lcom/facebook/imagepipeline/image/EncodedImage;", "getBackgroundNetworkFetchToEncodedMemorySequence", "backgroundNetworkFetchToEncodedMemorySequence$delegate", "networkFetchToEncodedMemoryPrefetchSequence", "getNetworkFetchToEncodedMemoryPrefetchSequence", "networkFetchToEncodedMemoryPrefetchSequence$delegate", "commonNetworkFetchToEncodedMemorySequence", "getCommonNetworkFetchToEncodedMemorySequence", "commonNetworkFetchToEncodedMemorySequence$delegate", "newCommonNetworkFetchToEncodedMemorySequence", "localFileFetchToEncodedMemoryPrefetchSequence", "getLocalFileFetchToEncodedMemoryPrefetchSequence", "localFileFetchToEncodedMemoryPrefetchSequence$delegate", "backgroundLocalFileFetchToEncodeMemorySequence", "getBackgroundLocalFileFetchToEncodeMemorySequence", "backgroundLocalFileFetchToEncodeMemorySequence$delegate", "backgroundLocalContentUriFetchToEncodeMemorySequence", "getBackgroundLocalContentUriFetchToEncodeMemorySequence", "backgroundLocalContentUriFetchToEncodeMemorySequence$delegate", "localImageFileFetchSequence", "getLocalImageFileFetchSequence", "localImageFileFetchSequence$delegate", "localVideoFileFetchSequence", "getLocalVideoFileFetchSequence", "localVideoFileFetchSequence$delegate", "localContentUriFetchSequence", "getLocalContentUriFetchSequence", "localContentUriFetchSequence$delegate", "localThumbnailBitmapSdk29FetchSequence", "getLocalThumbnailBitmapSdk29FetchSequence", "localThumbnailBitmapSdk29FetchSequence$delegate", "qualifiedResourceFetchSequence", "getQualifiedResourceFetchSequence", "qualifiedResourceFetchSequence$delegate", "localResourceFetchSequence", "getLocalResourceFetchSequence", "localResourceFetchSequence$delegate", "localAssetFetchSequence", "getLocalAssetFetchSequence", "localAssetFetchSequence$delegate", "dataFetchSequence", "getDataFetchSequence", "dataFetchSequence$delegate", "newBitmapCacheGetToLocalTransformSequence", "inputProducer", "thumbnailProducers", "", "Lcom/facebook/imagepipeline/producers/ThumbnailProducer;", "(Lcom/facebook/imagepipeline/producers/Producer;[Lcom/facebook/imagepipeline/producers/ThumbnailProducer;)Lcom/facebook/imagepipeline/producers/Producer;", "newBitmapCacheGetToDecodeSequence", "newEncodedCacheMultiplexToTranscodeSequence", "newDiskCacheSequence", "newBitmapCacheGetToBitmapCacheSequence", "newLocalTransformationsSequence", "newLocalThumbnailProducer", "([Lcom/facebook/imagepipeline/producers/ThumbnailProducer;)Lcom/facebook/imagepipeline/producers/Producer;", "getPostprocessorSequence", "getDecodedImagePrefetchSequence", "getBitmapPrepareSequence", "getDelaySequence", "Companion", "imagepipeline_release"})
@SourceDebugExtension(value={"SMAP\nProducerSequenceFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProducerSequenceFactory.kt\ncom/facebook/imagepipeline/core/ProducerSequenceFactory\n+ 2 FrescoSystrace.kt\ncom/facebook/imagepipeline/systrace/FrescoSystrace\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,636:1\n40#2,9:637\n40#2,9:646\n40#2,2:655\n44#2,5:658\n40#2,9:663\n40#2,9:672\n40#2,9:681\n40#2,9:690\n40#2,9:699\n40#2,9:708\n40#2,9:717\n40#2,9:726\n40#2,9:735\n40#2,9:744\n40#2,9:753\n40#2,9:762\n40#2,9:771\n1#3:657\n*S KotlinDebug\n*F\n+ 1 ProducerSequenceFactory.kt\ncom/facebook/imagepipeline/core/ProducerSequenceFactory\n*L\n79#1:637,9\n167#1:646,9\n198#1:655,2\n198#1:658,5\n298#1:663,9\n483#1:672,9\n511#1:681,9\n109#1:690,9\n118#1:699,9\n129#1:708,9\n257#1:717,9\n267#1:726,9\n279#1:735,9\n289#1:744,9\n317#1:753,9\n327#1:762,9\n341#1:771,9\n*E\n"})
public final class ProducerSequenceFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ContentResolver contentResolver;
    @NotNull
    private final ProducerFactory producerFactory;
    @NotNull
    private final NetworkFetcher<?> networkFetcher;
    private final boolean resizeAndRotateEnabledForNetwork;
    private final boolean webpSupportEnabled;
    @NotNull
    private final ThreadHandoffProducerQueue threadHandoffProducerQueue;
    @NotNull
    private final DownsampleMode downsampleMode;
    private final boolean useBitmapPrepareToDraw;
    private final boolean partialImageCachingEnabled;
    private final boolean diskCacheEnabled;
    @NotNull
    private final ImageTranscoderFactory imageTranscoderFactory;
    private final boolean isEncodedMemoryCacheProbingEnabled;
    private final boolean isDiskCacheProbingEnabled;
    private final boolean allowDelay;
    @Nullable
    private final Set<CustomProducerSequenceFactory> customProducerSequenceFactories;
    @NotNull
    private Map<Producer<CloseableReference<CloseableImage>>, Producer<CloseableReference<CloseableImage>>> postprocessorSequences;
    @NotNull
    private Map<Producer<CloseableReference<CloseableImage>>, Producer<Void>> closeableImagePrefetchSequences;
    @NotNull
    private Map<Producer<CloseableReference<CloseableImage>>, Producer<CloseableReference<CloseableImage>>> bitmapPrepareSequences;
    @NotNull
    private final Lazy networkFetchEncodedImageProducerSequence$delegate;
    @NotNull
    private final Lazy localFileFetchEncodedImageProducerSequence$delegate;
    @NotNull
    private final Lazy localContentUriFetchEncodedImageProducerSequence$delegate;
    @NotNull
    private final Lazy networkFetchSequence$delegate;
    @NotNull
    private final Lazy backgroundNetworkFetchToEncodedMemorySequence$delegate;
    @NotNull
    private final Lazy networkFetchToEncodedMemoryPrefetchSequence$delegate;
    @NotNull
    private final Lazy commonNetworkFetchToEncodedMemorySequence$delegate;
    @NotNull
    private final Lazy localFileFetchToEncodedMemoryPrefetchSequence$delegate;
    @NotNull
    private final Lazy backgroundLocalFileFetchToEncodeMemorySequence$delegate;
    @NotNull
    private final Lazy backgroundLocalContentUriFetchToEncodeMemorySequence$delegate;
    @NotNull
    private final Lazy localImageFileFetchSequence$delegate;
    @NotNull
    private final Lazy localVideoFileFetchSequence$delegate;
    @NotNull
    private final Lazy localContentUriFetchSequence$delegate;
    @NotNull
    private final Lazy localThumbnailBitmapSdk29FetchSequence$delegate;
    @NotNull
    private final Lazy qualifiedResourceFetchSequence$delegate;
    @NotNull
    private final Lazy localResourceFetchSequence$delegate;
    @NotNull
    private final Lazy localAssetFetchSequence$delegate;
    @NotNull
    private final Lazy dataFetchSequence$delegate;

    public ProducerSequenceFactory(@NotNull ContentResolver contentResolver, @NotNull ProducerFactory producerFactory, @NotNull NetworkFetcher<?> networkFetcher, boolean resizeAndRotateEnabledForNetwork, boolean webpSupportEnabled, @NotNull ThreadHandoffProducerQueue threadHandoffProducerQueue, @NotNull DownsampleMode downsampleMode, boolean useBitmapPrepareToDraw, boolean partialImageCachingEnabled, boolean diskCacheEnabled, @NotNull ImageTranscoderFactory imageTranscoderFactory, boolean isEncodedMemoryCacheProbingEnabled, boolean isDiskCacheProbingEnabled, boolean allowDelay, @Nullable Set<? extends CustomProducerSequenceFactory> customProducerSequenceFactories) {
        Intrinsics.checkNotNullParameter((Object)contentResolver, (String)"contentResolver");
        Intrinsics.checkNotNullParameter((Object)producerFactory, (String)"producerFactory");
        Intrinsics.checkNotNullParameter(networkFetcher, (String)"networkFetcher");
        Intrinsics.checkNotNullParameter((Object)threadHandoffProducerQueue, (String)"threadHandoffProducerQueue");
        Intrinsics.checkNotNullParameter((Object)((Object)downsampleMode), (String)"downsampleMode");
        Intrinsics.checkNotNullParameter((Object)imageTranscoderFactory, (String)"imageTranscoderFactory");
        this.contentResolver = contentResolver;
        this.producerFactory = producerFactory;
        this.networkFetcher = networkFetcher;
        this.resizeAndRotateEnabledForNetwork = resizeAndRotateEnabledForNetwork;
        this.webpSupportEnabled = webpSupportEnabled;
        this.threadHandoffProducerQueue = threadHandoffProducerQueue;
        this.downsampleMode = downsampleMode;
        this.useBitmapPrepareToDraw = useBitmapPrepareToDraw;
        this.partialImageCachingEnabled = partialImageCachingEnabled;
        this.diskCacheEnabled = diskCacheEnabled;
        this.imageTranscoderFactory = imageTranscoderFactory;
        this.isEncodedMemoryCacheProbingEnabled = isEncodedMemoryCacheProbingEnabled;
        this.isDiskCacheProbingEnabled = isDiskCacheProbingEnabled;
        this.allowDelay = allowDelay;
        this.customProducerSequenceFactories = customProducerSequenceFactories;
        this.postprocessorSequences = new LinkedHashMap();
        this.closeableImagePrefetchSequences = new LinkedHashMap();
        this.bitmapPrepareSequences = new LinkedHashMap();
        this.networkFetchEncodedImageProducerSequence$delegate = LazyKt.lazy(() -> ProducerSequenceFactory.networkFetchEncodedImageProducerSequence_delegate$lambda$2(this));
        this.localFileFetchEncodedImageProducerSequence$delegate = LazyKt.lazy(() -> ProducerSequenceFactory.localFileFetchEncodedImageProducerSequence_delegate$lambda$4(this));
        this.localContentUriFetchEncodedImageProducerSequence$delegate = LazyKt.lazy(() -> ProducerSequenceFactory.localContentUriFetchEncodedImageProducerSequence_delegate$lambda$6(this));
        this.networkFetchSequence$delegate = LazyKt.lazy(() -> ProducerSequenceFactory.networkFetchSequence_delegate$lambda$11(this));
        this.backgroundNetworkFetchToEncodedMemorySequence$delegate = LazyKt.lazy(() -> ProducerSequenceFactory.backgroundNetworkFetchToEncodedMemorySequence_delegate$lambda$13(this));
        this.networkFetchToEncodedMemoryPrefetchSequence$delegate = LazyKt.lazy(() -> ProducerSequenceFactory.networkFetchToEncodedMemoryPrefetchSequence_delegate$lambda$15(this));
        this.commonNetworkFetchToEncodedMemorySequence$delegate = LazyKt.lazy(() -> ProducerSequenceFactory.commonNetworkFetchToEncodedMemorySequence_delegate$lambda$17(this));
        this.localFileFetchToEncodedMemoryPrefetchSequence$delegate = LazyKt.lazy(() -> ProducerSequenceFactory.localFileFetchToEncodedMemoryPrefetchSequence_delegate$lambda$20(this));
        this.backgroundLocalFileFetchToEncodeMemorySequence$delegate = LazyKt.lazy(() -> ProducerSequenceFactory.backgroundLocalFileFetchToEncodeMemorySequence_delegate$lambda$22(this));
        this.backgroundLocalContentUriFetchToEncodeMemorySequence$delegate = LazyKt.lazy(() -> ProducerSequenceFactory.backgroundLocalContentUriFetchToEncodeMemorySequence_delegate$lambda$24(this));
        this.localImageFileFetchSequence$delegate = LazyKt.lazy(() -> ProducerSequenceFactory.localImageFileFetchSequence_delegate$lambda$25(this));
        this.localVideoFileFetchSequence$delegate = LazyKt.lazy(() -> ProducerSequenceFactory.localVideoFileFetchSequence_delegate$lambda$26(this));
        this.localContentUriFetchSequence$delegate = LazyKt.lazy(() -> ProducerSequenceFactory.localContentUriFetchSequence_delegate$lambda$27(this));
        this.localThumbnailBitmapSdk29FetchSequence$delegate = LazyKt.lazy(() -> ProducerSequenceFactory.localThumbnailBitmapSdk29FetchSequence_delegate$lambda$28(this));
        this.qualifiedResourceFetchSequence$delegate = LazyKt.lazy(() -> ProducerSequenceFactory.qualifiedResourceFetchSequence_delegate$lambda$29(this));
        this.localResourceFetchSequence$delegate = LazyKt.lazy(() -> ProducerSequenceFactory.localResourceFetchSequence_delegate$lambda$30(this));
        this.localAssetFetchSequence$delegate = LazyKt.lazy(() -> ProducerSequenceFactory.localAssetFetchSequence_delegate$lambda$31(this));
        this.dataFetchSequence$delegate = LazyKt.lazy(() -> ProducerSequenceFactory.dataFetchSequence_delegate$lambda$32(this));
    }

    @NotNull
    public final Map<Producer<CloseableReference<CloseableImage>>, Producer<CloseableReference<CloseableImage>>> getPostprocessorSequences() {
        return this.postprocessorSequences;
    }

    public final void setPostprocessorSequences(@NotNull Map<Producer<CloseableReference<CloseableImage>>, Producer<CloseableReference<CloseableImage>>> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.postprocessorSequences = map;
    }

    @VisibleForTesting
    public static /* synthetic */ void getPostprocessorSequences$annotations() {
    }

    @NotNull
    public final Map<Producer<CloseableReference<CloseableImage>>, Producer<Void>> getCloseableImagePrefetchSequences() {
        return this.closeableImagePrefetchSequences;
    }

    public final void setCloseableImagePrefetchSequences(@NotNull Map<Producer<CloseableReference<CloseableImage>>, Producer<Void>> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.closeableImagePrefetchSequences = map;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCloseableImagePrefetchSequences$annotations() {
    }

    @NotNull
    public final Map<Producer<CloseableReference<CloseableImage>>, Producer<CloseableReference<CloseableImage>>> getBitmapPrepareSequences() {
        return this.bitmapPrepareSequences;
    }

    public final void setBitmapPrepareSequences(@NotNull Map<Producer<CloseableReference<CloseableImage>>, Producer<CloseableReference<CloseableImage>>> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.bitmapPrepareSequences = map;
    }

    @VisibleForTesting
    public static /* synthetic */ void getBitmapPrepareSequences$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Producer<CloseableReference<PooledByteBuffer>> getEncodedImageProducerSequence(@NotNull ImageRequest imageRequest) {
        Producer<CloseableReference<PooledByteBuffer>> producer;
        Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"imageRequest");
        FrescoSystrace frescoSystrace = FrescoSystrace.INSTANCE;
        String name$iv = "ProducerSequenceFactory#getEncodedImageProducerSequence";
        boolean $i$f$traceSection = false;
        if (!FrescoSystrace.isTracing()) {
            boolean bl = false;
            ProducerSequenceFactory.Companion.validateEncodedImageRequest(imageRequest);
            Uri uri = imageRequest.getSourceUri();
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"getSourceUri(...)");
            Uri uri2 = uri;
            switch (imageRequest.getSourceUriType()) {
                case 0: {
                    producer = this.getNetworkFetchEncodedImageProducerSequence();
                    break;
                }
                case 2: 
                case 3: {
                    producer = this.getLocalFileFetchEncodedImageProducerSequence();
                    break;
                }
                case 4: {
                    producer = this.getLocalContentUriFetchEncodedImageProducerSequence();
                    break;
                }
                default: {
                    if (this.customProducerSequenceFactories != null) {
                        for (CustomProducerSequenceFactory customProducerSequenceFactory : this.customProducerSequenceFactories) {
                            Producer<CloseableReference<PooledByteBuffer>> sequence = customProducerSequenceFactory.getCustomEncodedImageSequence(imageRequest, this, this.producerFactory, this.threadHandoffProducerQueue);
                            if (sequence == null) continue;
                            return sequence;
                        }
                    }
                    throw new IllegalArgumentException("Unsupported uri scheme for encoded image fetch! Uri is: " + ProducerSequenceFactory.Companion.getShortenedUriString(uri2));
                }
            }
        } else {
            FrescoSystrace.beginSection((String)name$iv);
            try {
                Producer<CloseableReference<PooledByteBuffer>> producer2;
                boolean bl = false;
                ProducerSequenceFactory.Companion.validateEncodedImageRequest(imageRequest);
                Uri uri = imageRequest.getSourceUri();
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"getSourceUri(...)");
                Uri uri3 = uri;
                switch (imageRequest.getSourceUriType()) {
                    case 0: {
                        producer2 = this.getNetworkFetchEncodedImageProducerSequence();
                        break;
                    }
                    case 2: 
                    case 3: {
                        producer2 = this.getLocalFileFetchEncodedImageProducerSequence();
                        break;
                    }
                    case 4: {
                        producer2 = this.getLocalContentUriFetchEncodedImageProducerSequence();
                        break;
                    }
                    default: {
                        if (this.customProducerSequenceFactories != null) {
                            for (CustomProducerSequenceFactory customProducerSequenceFactory : this.customProducerSequenceFactories) {
                                Producer<CloseableReference<PooledByteBuffer>> sequence = customProducerSequenceFactory.getCustomEncodedImageSequence(imageRequest, this, this.producerFactory, this.threadHandoffProducerQueue);
                                if (sequence == null) continue;
                                Producer<CloseableReference<PooledByteBuffer>> producer3 = sequence;
                                return producer3;
                            }
                        }
                        throw new IllegalArgumentException("Unsupported uri scheme for encoded image fetch! Uri is: " + ProducerSequenceFactory.Companion.getShortenedUriString(uri3));
                    }
                }
                Producer<CloseableReference<PooledByteBuffer>> producer4 = producer2;
                producer = producer4;
            }
            finally {
                FrescoSystrace.endSection();
            }
        }
        return producer;
    }

    @NotNull
    public final Producer<CloseableReference<PooledByteBuffer>> getNetworkFetchEncodedImageProducerSequence() {
        Lazy lazy = this.networkFetchEncodedImageProducerSequence$delegate;
        return (Producer)lazy.getValue();
    }

    @NotNull
    public final Producer<CloseableReference<PooledByteBuffer>> getLocalFileFetchEncodedImageProducerSequence() {
        Lazy lazy = this.localFileFetchEncodedImageProducerSequence$delegate;
        return (Producer)lazy.getValue();
    }

    @VisibleForTesting
    public static /* synthetic */ void getLocalFileFetchEncodedImageProducerSequence$annotations() {
    }

    @NotNull
    public final Producer<CloseableReference<PooledByteBuffer>> getLocalContentUriFetchEncodedImageProducerSequence() {
        Lazy lazy = this.localContentUriFetchEncodedImageProducerSequence$delegate;
        return (Producer)lazy.getValue();
    }

    @NotNull
    public final Producer<Void> getEncodedImagePrefetchProducerSequence(@NotNull ImageRequest imageRequest) {
        Producer<Void> producer;
        Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"imageRequest");
        ProducerSequenceFactory.Companion.validateEncodedImageRequest(imageRequest);
        switch (imageRequest.getSourceUriType()) {
            case 0: {
                producer = this.getNetworkFetchToEncodedMemoryPrefetchSequence();
                break;
            }
            case 2: 
            case 3: {
                producer = this.getLocalFileFetchToEncodedMemoryPrefetchSequence();
                break;
            }
            default: {
                Uri uri = imageRequest.getSourceUri();
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"getSourceUri(...)");
                Uri uri2 = uri;
                throw new IllegalArgumentException("Unsupported uri scheme for encoded image fetch! Uri is: " + ProducerSequenceFactory.Companion.getShortenedUriString(uri2));
            }
        }
        return producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Producer<CloseableReference<CloseableImage>> getDecodedImageProducerSequence(@NotNull ImageRequest imageRequest) {
        Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"imageRequest");
        FrescoSystrace frescoSystrace = FrescoSystrace.INSTANCE;
        String name$iv = "ProducerSequenceFactory#getDecodedImageProducerSequence";
        boolean $i$f$traceSection = false;
        if (!FrescoSystrace.isTracing()) {
            boolean bl = false;
            Producer<CloseableReference<CloseableImage>> pipelineSequence = this.getBasicDecodedImageSequence(imageRequest);
            if (imageRequest.getPostprocessor() != null) {
                pipelineSequence = this.getPostprocessorSequence(pipelineSequence);
            }
            if (this.useBitmapPrepareToDraw) {
                pipelineSequence = this.getBitmapPrepareSequence(pipelineSequence);
            }
            if (this.allowDelay && imageRequest.getDelayMs() > 0) {
                pipelineSequence = this.getDelaySequence(pipelineSequence);
            }
            return pipelineSequence;
        }
        FrescoSystrace.beginSection((String)name$iv);
        try {
            boolean bl = false;
            Producer<CloseableReference<CloseableImage>> pipelineSequence = this.getBasicDecodedImageSequence(imageRequest);
            if (imageRequest.getPostprocessor() != null) {
                pipelineSequence = this.getPostprocessorSequence(pipelineSequence);
            }
            if (this.useBitmapPrepareToDraw) {
                pipelineSequence = this.getBitmapPrepareSequence(pipelineSequence);
            }
            if (this.allowDelay && imageRequest.getDelayMs() > 0) {
                pipelineSequence = this.getDelaySequence(pipelineSequence);
            }
            Producer<CloseableReference<CloseableImage>> producer = pipelineSequence;
            return producer;
        }
        finally {
            FrescoSystrace.endSection();
        }
    }

    @NotNull
    public final Producer<Void> getDecodedImagePrefetchProducerSequence(@NotNull ImageRequest imageRequest) {
        Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"imageRequest");
        Producer<CloseableReference<CloseableImage>> inputProducer = this.getBasicDecodedImageSequence(imageRequest);
        if (this.useBitmapPrepareToDraw) {
            inputProducer = this.getBitmapPrepareSequence(inputProducer);
        }
        return this.getDecodedImagePrefetchSequence(inputProducer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Producer<CloseableReference<CloseableImage>> getBasicDecodedImageSequence(ImageRequest imageRequest) {
        Producer<CloseableReference<CloseableImage>> producer;
        FrescoSystrace frescoSystrace = FrescoSystrace.INSTANCE;
        String name$iv = "ProducerSequenceFactory#getBasicDecodedImageSequence";
        boolean $i$f$traceSection = false;
        if (!FrescoSystrace.isTracing()) {
            boolean bl = false;
            Uri uri = imageRequest.getSourceUri();
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"getSourceUri(...)");
            Uri uri2 = uri;
            if (uri2 == null) {
                boolean $i$a$-checkNotNull-ProducerSequenceFactory$getBasicDecodedImageSequence$1$22 = false;
                String $i$a$-checkNotNull-ProducerSequenceFactory$getBasicDecodedImageSequence$1$22 = "Uri is null.";
                throw new IllegalStateException($i$a$-checkNotNull-ProducerSequenceFactory$getBasicDecodedImageSequence$1$22.toString());
            }
            switch (imageRequest.getSourceUriType()) {
                case 0: {
                    producer = this.getNetworkFetchSequence();
                    break;
                }
                case 2: {
                    if (imageRequest.getLoadThumbnailOnlyForAndroidSdkAboveQ()) {
                        return this.getLocalThumbnailBitmapSdk29FetchSequence();
                    }
                    producer = this.getLocalVideoFileFetchSequence();
                    break;
                }
                case 3: {
                    if (imageRequest.getLoadThumbnailOnlyForAndroidSdkAboveQ()) {
                        return this.getLocalThumbnailBitmapSdk29FetchSequence();
                    }
                    producer = this.getLocalImageFileFetchSequence();
                    break;
                }
                case 4: {
                    if (imageRequest.getLoadThumbnailOnlyForAndroidSdkAboveQ()) {
                        return this.getLocalThumbnailBitmapSdk29FetchSequence();
                    }
                    if (MediaUtils.isVideo((String)this.contentResolver.getType(uri2))) {
                        return this.getLocalVideoFileFetchSequence();
                    }
                    producer = this.getLocalContentUriFetchSequence();
                    break;
                }
                case 5: {
                    producer = this.getLocalAssetFetchSequence();
                    break;
                }
                case 6: {
                    producer = this.getLocalResourceFetchSequence();
                    break;
                }
                case 8: {
                    producer = this.getQualifiedResourceFetchSequence();
                    break;
                }
                case 7: {
                    producer = this.getDataFetchSequence();
                    break;
                }
                default: {
                    if (this.customProducerSequenceFactories != null) {
                        for (CustomProducerSequenceFactory customProducerSequenceFactory : this.customProducerSequenceFactories) {
                            Producer<CloseableReference<CloseableImage>> sequence = customProducerSequenceFactory.getCustomDecodedImageSequence(imageRequest, this, this.producerFactory, this.threadHandoffProducerQueue, this.isEncodedMemoryCacheProbingEnabled, this.isDiskCacheProbingEnabled);
                            if (sequence == null) continue;
                            return sequence;
                        }
                    }
                    throw new IllegalArgumentException("Unsupported uri scheme! Uri is: " + ProducerSequenceFactory.Companion.getShortenedUriString(uri2));
                }
            }
        } else {
            FrescoSystrace.beginSection((String)name$iv);
            try {
                Producer<CloseableReference<CloseableImage>> producer2;
                boolean bl = false;
                Uri uri = imageRequest.getSourceUri();
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"getSourceUri(...)");
                Uri uri3 = uri;
                if (uri3 == null) {
                    boolean bl2 = false;
                    String string = "Uri is null.";
                    throw new IllegalStateException(string.toString());
                }
                switch (imageRequest.getSourceUriType()) {
                    case 0: {
                        producer2 = this.getNetworkFetchSequence();
                        break;
                    }
                    case 2: {
                        if (imageRequest.getLoadThumbnailOnlyForAndroidSdkAboveQ()) {
                            Producer<CloseableReference<CloseableImage>> producer3 = this.getLocalThumbnailBitmapSdk29FetchSequence();
                            return producer3;
                        }
                        producer2 = this.getLocalVideoFileFetchSequence();
                        break;
                    }
                    case 3: {
                        if (imageRequest.getLoadThumbnailOnlyForAndroidSdkAboveQ()) {
                            Producer<CloseableReference<CloseableImage>> producer4 = this.getLocalThumbnailBitmapSdk29FetchSequence();
                            return producer4;
                        }
                        producer2 = this.getLocalImageFileFetchSequence();
                        break;
                    }
                    case 4: {
                        if (imageRequest.getLoadThumbnailOnlyForAndroidSdkAboveQ()) {
                            Producer<CloseableReference<CloseableImage>> producer5 = this.getLocalThumbnailBitmapSdk29FetchSequence();
                            return producer5;
                        }
                        if (MediaUtils.isVideo((String)this.contentResolver.getType(uri3))) {
                            Producer<CloseableReference<CloseableImage>> producer6 = this.getLocalVideoFileFetchSequence();
                            return producer6;
                        }
                        producer2 = this.getLocalContentUriFetchSequence();
                        break;
                    }
                    case 5: {
                        producer2 = this.getLocalAssetFetchSequence();
                        break;
                    }
                    case 6: {
                        producer2 = this.getLocalResourceFetchSequence();
                        break;
                    }
                    case 8: {
                        producer2 = this.getQualifiedResourceFetchSequence();
                        break;
                    }
                    case 7: {
                        producer2 = this.getDataFetchSequence();
                        break;
                    }
                    default: {
                        if (this.customProducerSequenceFactories != null) {
                            for (CustomProducerSequenceFactory customProducerSequenceFactory : this.customProducerSequenceFactories) {
                                Producer<CloseableReference<CloseableImage>> sequence = customProducerSequenceFactory.getCustomDecodedImageSequence(imageRequest, this, this.producerFactory, this.threadHandoffProducerQueue, this.isEncodedMemoryCacheProbingEnabled, this.isDiskCacheProbingEnabled);
                                if (sequence == null) continue;
                                Producer<CloseableReference<CloseableImage>> producer7 = sequence;
                                return producer7;
                            }
                        }
                        throw new IllegalArgumentException("Unsupported uri scheme! Uri is: " + ProducerSequenceFactory.Companion.getShortenedUriString(uri3));
                    }
                }
                Producer<CloseableReference<CloseableImage>> producer8 = producer2;
                producer = producer8;
            }
            finally {
                FrescoSystrace.endSection();
            }
        }
        return producer;
    }

    @NotNull
    public final Producer<CloseableReference<CloseableImage>> getNetworkFetchSequence() {
        Lazy lazy = this.networkFetchSequence$delegate;
        return (Producer)lazy.getValue();
    }

    @NotNull
    public final Producer<EncodedImage> getBackgroundNetworkFetchToEncodedMemorySequence() {
        Lazy lazy = this.backgroundNetworkFetchToEncodedMemorySequence$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Producer)object;
    }

    @NotNull
    public final Producer<Void> getNetworkFetchToEncodedMemoryPrefetchSequence() {
        Lazy lazy = this.networkFetchToEncodedMemoryPrefetchSequence$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Producer)object;
    }

    @NotNull
    public final Producer<EncodedImage> getCommonNetworkFetchToEncodedMemorySequence() {
        Lazy lazy = this.commonNetworkFetchToEncodedMemorySequence$delegate;
        return (Producer)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final synchronized Producer<EncodedImage> newCommonNetworkFetchToEncodedMemorySequence(@NotNull NetworkFetcher<?> networkFetcher) {
        Intrinsics.checkNotNullParameter(networkFetcher, (String)"networkFetcher");
        FrescoSystrace frescoSystrace = FrescoSystrace.INSTANCE;
        String name$iv = "ProducerSequenceFactory#createCommonNetworkFetchToEncodedMemorySequence";
        boolean $i$f$traceSection = false;
        if (!FrescoSystrace.isTracing()) {
            boolean bl = false;
            Producer<EncodedImage> producer = this.producerFactory.newNetworkFetchProducer(networkFetcher);
            Intrinsics.checkNotNullExpressionValue(producer, (String)"newNetworkFetchProducer(...)");
            Producer<EncodedImage> inputProducer = this.newEncodedCacheMultiplexToTranscodeSequence(producer);
            AddImageTransformMetaDataProducer addImageTransformMetaDataProducer = ProducerFactory.newAddImageTransformMetaDataProducer(inputProducer);
            Intrinsics.checkNotNullExpressionValue((Object)addImageTransformMetaDataProducer, (String)"newAddImageTransformMetaDataProducer(...)");
            Producer networkFetchToEncodedMemorySequence = addImageTransformMetaDataProducer;
            networkFetchToEncodedMemorySequence = this.producerFactory.newResizeAndRotateProducer(networkFetchToEncodedMemorySequence, this.resizeAndRotateEnabledForNetwork && this.downsampleMode != DownsampleMode.NEVER, this.imageTranscoderFactory);
            return networkFetchToEncodedMemorySequence;
        }
        FrescoSystrace.beginSection((String)name$iv);
        try {
            boolean bl = false;
            Producer<EncodedImage> producer = this.producerFactory.newNetworkFetchProducer(networkFetcher);
            Intrinsics.checkNotNullExpressionValue(producer, (String)"newNetworkFetchProducer(...)");
            Producer<EncodedImage> inputProducer = this.newEncodedCacheMultiplexToTranscodeSequence(producer);
            AddImageTransformMetaDataProducer addImageTransformMetaDataProducer = ProducerFactory.newAddImageTransformMetaDataProducer(inputProducer);
            Intrinsics.checkNotNullExpressionValue((Object)addImageTransformMetaDataProducer, (String)"newAddImageTransformMetaDataProducer(...)");
            Producer networkFetchToEncodedMemorySequence = addImageTransformMetaDataProducer;
            Producer producer2 = networkFetchToEncodedMemorySequence = (Producer)this.producerFactory.newResizeAndRotateProducer(networkFetchToEncodedMemorySequence, this.resizeAndRotateEnabledForNetwork && this.downsampleMode != DownsampleMode.NEVER, this.imageTranscoderFactory);
            return producer2;
        }
        finally {
            FrescoSystrace.endSection();
        }
    }

    @NotNull
    public final Producer<Void> getLocalFileFetchToEncodedMemoryPrefetchSequence() {
        Lazy lazy = this.localFileFetchToEncodedMemoryPrefetchSequence$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Producer)object;
    }

    @NotNull
    public final Producer<EncodedImage> getBackgroundLocalFileFetchToEncodeMemorySequence() {
        Lazy lazy = this.backgroundLocalFileFetchToEncodeMemorySequence$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Producer)object;
    }

    @NotNull
    public final Producer<EncodedImage> getBackgroundLocalContentUriFetchToEncodeMemorySequence() {
        Lazy lazy = this.backgroundLocalContentUriFetchToEncodeMemorySequence$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Producer)object;
    }

    @NotNull
    public final Producer<CloseableReference<CloseableImage>> getLocalImageFileFetchSequence() {
        Lazy lazy = this.localImageFileFetchSequence$delegate;
        return (Producer)lazy.getValue();
    }

    @NotNull
    public final Producer<CloseableReference<CloseableImage>> getLocalVideoFileFetchSequence() {
        Lazy lazy = this.localVideoFileFetchSequence$delegate;
        return (Producer)lazy.getValue();
    }

    @NotNull
    public final Producer<CloseableReference<CloseableImage>> getLocalContentUriFetchSequence() {
        Lazy lazy = this.localContentUriFetchSequence$delegate;
        return (Producer)lazy.getValue();
    }

    @RequiresApi(value=29)
    @NotNull
    public final Producer<CloseableReference<CloseableImage>> getLocalThumbnailBitmapSdk29FetchSequence() {
        Lazy lazy = this.localThumbnailBitmapSdk29FetchSequence$delegate;
        return (Producer)lazy.getValue();
    }

    @NotNull
    public final Producer<CloseableReference<CloseableImage>> getQualifiedResourceFetchSequence() {
        Lazy lazy = this.qualifiedResourceFetchSequence$delegate;
        return (Producer)lazy.getValue();
    }

    @NotNull
    public final Producer<CloseableReference<CloseableImage>> getLocalResourceFetchSequence() {
        Lazy lazy = this.localResourceFetchSequence$delegate;
        return (Producer)lazy.getValue();
    }

    @NotNull
    public final Producer<CloseableReference<CloseableImage>> getLocalAssetFetchSequence() {
        Lazy lazy = this.localAssetFetchSequence$delegate;
        return (Producer)lazy.getValue();
    }

    @NotNull
    public final Producer<CloseableReference<CloseableImage>> getDataFetchSequence() {
        Lazy lazy = this.dataFetchSequence$delegate;
        return (Producer)lazy.getValue();
    }

    private final Producer<CloseableReference<CloseableImage>> newBitmapCacheGetToLocalTransformSequence(Producer<EncodedImage> inputProducer) {
        ThumbnailProducer[] thumbnailProducerArray = new ThumbnailProducer[]{this.producerFactory.newLocalExifThumbnailProducer()};
        ThumbnailProducer[] defaultThumbnailProducers = thumbnailProducerArray;
        return this.newBitmapCacheGetToLocalTransformSequence(inputProducer, defaultThumbnailProducers);
    }

    private final Producer<CloseableReference<CloseableImage>> newBitmapCacheGetToLocalTransformSequence(Producer<EncodedImage> inputProducer, ThumbnailProducer<EncodedImage>[] thumbnailProducers) {
        Producer<EncodedImage> ip = inputProducer;
        ip = this.newEncodedCacheMultiplexToTranscodeSequence(ip);
        ip = this.newLocalTransformationsSequence(ip, thumbnailProducers);
        return this.newBitmapCacheGetToDecodeSequence(ip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Producer<CloseableReference<CloseableImage>> newBitmapCacheGetToDecodeSequence(@NotNull Producer<EncodedImage> inputProducer) {
        Intrinsics.checkNotNullParameter(inputProducer, (String)"inputProducer");
        FrescoSystrace frescoSystrace = FrescoSystrace.INSTANCE;
        String name$iv = "ProducerSequenceFactory#newBitmapCacheGetToDecodeSequence";
        boolean $i$f$traceSection = false;
        if (!FrescoSystrace.isTracing()) {
            boolean bl = false;
            DecodeProducer decodeProducer = this.producerFactory.newDecodeProducer(inputProducer);
            Intrinsics.checkNotNullExpressionValue((Object)decodeProducer, (String)"newDecodeProducer(...)");
            DecodeProducer decodeProducer2 = decodeProducer;
            return this.newBitmapCacheGetToBitmapCacheSequence(decodeProducer2);
        }
        FrescoSystrace.beginSection((String)name$iv);
        try {
            boolean bl = false;
            DecodeProducer decodeProducer = this.producerFactory.newDecodeProducer(inputProducer);
            Intrinsics.checkNotNullExpressionValue((Object)decodeProducer, (String)"newDecodeProducer(...)");
            DecodeProducer decodeProducer3 = decodeProducer;
            Producer<CloseableReference<CloseableImage>> producer = this.newBitmapCacheGetToBitmapCacheSequence(decodeProducer3);
            return producer;
        }
        finally {
            FrescoSystrace.endSection();
        }
    }

    private final Producer<EncodedImage> newEncodedCacheMultiplexToTranscodeSequence(Producer<EncodedImage> inputProducer) {
        Producer<EncodedImage> ip = inputProducer;
        if (this.diskCacheEnabled) {
            ip = this.newDiskCacheSequence(ip);
        }
        Producer<EncodedImage> producer = this.producerFactory.newEncodedMemoryCacheProducer(ip);
        Intrinsics.checkNotNullExpressionValue(producer, (String)"newEncodedMemoryCacheProducer(...)");
        Producer<EncodedImage> encodedMemoryCacheProducer = producer;
        if (this.isDiskCacheProbingEnabled) {
            EncodedProbeProducer encodedProbeProducer = this.producerFactory.newEncodedProbeProducer(encodedMemoryCacheProducer);
            Intrinsics.checkNotNullExpressionValue((Object)encodedProbeProducer, (String)"newEncodedProbeProducer(...)");
            EncodedProbeProducer probeProducer = encodedProbeProducer;
            EncodedCacheKeyMultiplexProducer encodedCacheKeyMultiplexProducer = this.producerFactory.newEncodedCacheKeyMultiplexProducer(probeProducer);
            Intrinsics.checkNotNullExpressionValue((Object)encodedCacheKeyMultiplexProducer, (String)"newEncodedCacheKeyMultiplexProducer(...)");
            return encodedCacheKeyMultiplexProducer;
        }
        EncodedCacheKeyMultiplexProducer encodedCacheKeyMultiplexProducer = this.producerFactory.newEncodedCacheKeyMultiplexProducer(encodedMemoryCacheProducer);
        Intrinsics.checkNotNullExpressionValue((Object)encodedCacheKeyMultiplexProducer, (String)"newEncodedCacheKeyMultiplexProducer(...)");
        return encodedCacheKeyMultiplexProducer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Producer<EncodedImage> newDiskCacheSequence(Producer<EncodedImage> inputProducer) {
        FrescoSystrace frescoSystrace = FrescoSystrace.INSTANCE;
        String name$iv = "ProducerSequenceFactory#newDiskCacheSequence";
        boolean $i$f$traceSection = false;
        if (!FrescoSystrace.isTracing()) {
            DiskCacheWriteProducer diskCacheWriteProducer;
            boolean bl = false;
            if (this.partialImageCachingEnabled) {
                PartialDiskCacheProducer partialDiskCacheProducer = this.producerFactory.newPartialDiskCacheProducer(inputProducer);
                Intrinsics.checkNotNullExpressionValue((Object)partialDiskCacheProducer, (String)"newPartialDiskCacheProducer(...)");
                Producer partialDiskCacheProducer2 = partialDiskCacheProducer;
                diskCacheWriteProducer = this.producerFactory.newDiskCacheWriteProducer(partialDiskCacheProducer2);
            } else {
                diskCacheWriteProducer = this.producerFactory.newDiskCacheWriteProducer(inputProducer);
            }
            DiskCacheWriteProducer diskCacheWriteProducer2 = diskCacheWriteProducer;
            Intrinsics.checkNotNull((Object)diskCacheWriteProducer2);
            DiskCacheWriteProducer cacheWriteProducer = diskCacheWriteProducer2;
            DiskCacheReadProducer diskCacheReadProducer = this.producerFactory.newDiskCacheReadProducer(cacheWriteProducer);
            Intrinsics.checkNotNullExpressionValue((Object)diskCacheReadProducer, (String)"newDiskCacheReadProducer(...)");
            return diskCacheReadProducer;
        }
        FrescoSystrace.beginSection((String)name$iv);
        try {
            DiskCacheWriteProducer diskCacheWriteProducer;
            boolean bl = false;
            if (this.partialImageCachingEnabled) {
                PartialDiskCacheProducer partialDiskCacheProducer = this.producerFactory.newPartialDiskCacheProducer(inputProducer);
                Intrinsics.checkNotNullExpressionValue((Object)partialDiskCacheProducer, (String)"newPartialDiskCacheProducer(...)");
                Producer partialDiskCacheProducer3 = partialDiskCacheProducer;
                diskCacheWriteProducer = this.producerFactory.newDiskCacheWriteProducer(partialDiskCacheProducer3);
            } else {
                diskCacheWriteProducer = this.producerFactory.newDiskCacheWriteProducer(inputProducer);
            }
            DiskCacheWriteProducer diskCacheWriteProducer3 = diskCacheWriteProducer;
            Intrinsics.checkNotNull((Object)diskCacheWriteProducer3);
            DiskCacheWriteProducer cacheWriteProducer = diskCacheWriteProducer3;
            DiskCacheReadProducer diskCacheReadProducer = this.producerFactory.newDiskCacheReadProducer(cacheWriteProducer);
            Intrinsics.checkNotNullExpressionValue((Object)diskCacheReadProducer, (String)"newDiskCacheReadProducer(...)");
            Producer producer = diskCacheReadProducer;
            return producer;
        }
        finally {
            FrescoSystrace.endSection();
        }
    }

    private final Producer<CloseableReference<CloseableImage>> newBitmapCacheGetToBitmapCacheSequence(Producer<CloseableReference<CloseableImage>> inputProducer) {
        BitmapMemoryCacheProducer bitmapMemoryCacheProducer = this.producerFactory.newBitmapMemoryCacheProducer(inputProducer);
        Intrinsics.checkNotNullExpressionValue((Object)bitmapMemoryCacheProducer, (String)"newBitmapMemoryCacheProducer(...)");
        BitmapMemoryCacheProducer bitmapMemoryCacheProducer2 = bitmapMemoryCacheProducer;
        BitmapMemoryCacheKeyMultiplexProducer bitmapMemoryCacheKeyMultiplexProducer = this.producerFactory.newBitmapMemoryCacheKeyMultiplexProducer(bitmapMemoryCacheProducer2);
        Intrinsics.checkNotNullExpressionValue((Object)bitmapMemoryCacheKeyMultiplexProducer, (String)"newBitmapMemoryCacheKeyMultiplexProducer(...)");
        BitmapMemoryCacheKeyMultiplexProducer bitmapKeyMultiplexProducer = bitmapMemoryCacheKeyMultiplexProducer;
        Producer<CloseableReference<CloseableImage>> producer = this.producerFactory.newBackgroundThreadHandoffProducer(bitmapKeyMultiplexProducer, this.threadHandoffProducerQueue);
        Intrinsics.checkNotNullExpressionValue(producer, (String)"newBackgroundThreadHandoffProducer(...)");
        Producer<CloseableReference<CloseableImage>> threadHandoffProducer = producer;
        if (this.isEncodedMemoryCacheProbingEnabled || this.isDiskCacheProbingEnabled) {
            BitmapMemoryCacheGetProducer bitmapMemoryCacheGetProducer = this.producerFactory.newBitmapMemoryCacheGetProducer(threadHandoffProducer);
            Intrinsics.checkNotNullExpressionValue((Object)bitmapMemoryCacheGetProducer, (String)"newBitmapMemoryCacheGetProducer(...)");
            BitmapMemoryCacheGetProducer bitmapMemoryCacheGetProducer2 = bitmapMemoryCacheGetProducer;
            BitmapProbeProducer bitmapProbeProducer = this.producerFactory.newBitmapProbeProducer(bitmapMemoryCacheGetProducer2);
            Intrinsics.checkNotNullExpressionValue((Object)bitmapProbeProducer, (String)"newBitmapProbeProducer(...)");
            return bitmapProbeProducer;
        }
        BitmapMemoryCacheGetProducer bitmapMemoryCacheGetProducer = this.producerFactory.newBitmapMemoryCacheGetProducer(threadHandoffProducer);
        Intrinsics.checkNotNullExpressionValue((Object)bitmapMemoryCacheGetProducer, (String)"newBitmapMemoryCacheGetProducer(...)");
        return bitmapMemoryCacheGetProducer;
    }

    private final Producer<EncodedImage> newLocalTransformationsSequence(Producer<EncodedImage> inputProducer, ThumbnailProducer<EncodedImage>[] thumbnailProducers) {
        AddImageTransformMetaDataProducer addImageTransformMetaDataProducer = ProducerFactory.newAddImageTransformMetaDataProducer(inputProducer);
        Intrinsics.checkNotNullExpressionValue((Object)addImageTransformMetaDataProducer, (String)"newAddImageTransformMetaDataProducer(...)");
        Producer localImageProducer = addImageTransformMetaDataProducer;
        localImageProducer = this.producerFactory.newResizeAndRotateProducer(localImageProducer, true, this.imageTranscoderFactory);
        ThrottlingProducer throttlingProducer = this.producerFactory.newThrottlingProducer(localImageProducer);
        Intrinsics.checkNotNullExpressionValue(throttlingProducer, (String)"newThrottlingProducer(...)");
        ThrottlingProducer localImageThrottlingProducer = throttlingProducer;
        BranchOnSeparateImagesProducer branchOnSeparateImagesProducer = ProducerFactory.newBranchOnSeparateImagesProducer(this.newLocalThumbnailProducer(thumbnailProducers), localImageThrottlingProducer);
        Intrinsics.checkNotNullExpressionValue((Object)branchOnSeparateImagesProducer, (String)"newBranchOnSeparateImagesProducer(...)");
        return branchOnSeparateImagesProducer;
    }

    private final Producer<EncodedImage> newLocalThumbnailProducer(ThumbnailProducer<EncodedImage>[] thumbnailProducers) {
        ThumbnailBranchProducer thumbnailBranchProducer = this.producerFactory.newThumbnailBranchProducer(thumbnailProducers);
        Intrinsics.checkNotNullExpressionValue((Object)thumbnailBranchProducer, (String)"newThumbnailBranchProducer(...)");
        ThumbnailBranchProducer thumbnailBranchProducer2 = thumbnailBranchProducer;
        ResizeAndRotateProducer resizeAndRotateProducer = this.producerFactory.newResizeAndRotateProducer(thumbnailBranchProducer2, true, this.imageTranscoderFactory);
        Intrinsics.checkNotNullExpressionValue((Object)resizeAndRotateProducer, (String)"newResizeAndRotateProducer(...)");
        return resizeAndRotateProducer;
    }

    private final synchronized Producer<CloseableReference<CloseableImage>> getPostprocessorSequence(Producer<CloseableReference<CloseableImage>> inputProducer) {
        Producer result = this.postprocessorSequences.get(inputProducer);
        if (result == null) {
            PostprocessorProducer postprocessorProducer = this.producerFactory.newPostprocessorProducer(inputProducer);
            Intrinsics.checkNotNullExpressionValue((Object)postprocessorProducer, (String)"newPostprocessorProducer(...)");
            PostprocessorProducer postprocessorProducer2 = postprocessorProducer;
            result = this.producerFactory.newPostprocessorBitmapMemoryCacheProducer(postprocessorProducer2);
            this.postprocessorSequences.put(inputProducer, result);
        }
        return result;
    }

    private final synchronized Producer<Void> getDecodedImagePrefetchSequence(Producer<CloseableReference<CloseableImage>> inputProducer) {
        Producer result = this.closeableImagePrefetchSequences.get(inputProducer);
        if (result == null) {
            result = this.producerFactory.newSwallowResultProducer(inputProducer);
            this.closeableImagePrefetchSequences.put(inputProducer, result);
        }
        return result;
    }

    private final synchronized Producer<CloseableReference<CloseableImage>> getBitmapPrepareSequence(Producer<CloseableReference<CloseableImage>> inputProducer) {
        Producer bitmapPrepareProducer = this.bitmapPrepareSequences.get(inputProducer);
        if (bitmapPrepareProducer == null) {
            bitmapPrepareProducer = this.producerFactory.newBitmapPrepareProducer(inputProducer);
            this.bitmapPrepareSequences.put(inputProducer, bitmapPrepareProducer);
        }
        return bitmapPrepareProducer;
    }

    private final synchronized Producer<CloseableReference<CloseableImage>> getDelaySequence(Producer<CloseableReference<CloseableImage>> inputProducer) {
        DelayProducer delayProducer = this.producerFactory.newDelayProducer(inputProducer);
        Intrinsics.checkNotNullExpressionValue((Object)delayProducer, (String)"newDelayProducer(...)");
        return delayProducer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final RemoveImageTransformMetaDataProducer networkFetchEncodedImageProducerSequence_delegate$lambda$2(ProducerSequenceFactory this$0) {
        RemoveImageTransformMetaDataProducer removeImageTransformMetaDataProducer;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        FrescoSystrace frescoSystrace = FrescoSystrace.INSTANCE;
        String name$iv = "ProducerSequenceFactory#getNetworkFetchEncodedImageProducerSequence:init";
        boolean $i$f$traceSection = false;
        if (!FrescoSystrace.isTracing()) {
            boolean bl = false;
            removeImageTransformMetaDataProducer = new RemoveImageTransformMetaDataProducer(this$0.getBackgroundNetworkFetchToEncodedMemorySequence());
        } else {
            FrescoSystrace.beginSection((String)name$iv);
            try {
                boolean bl = false;
                RemoveImageTransformMetaDataProducer removeImageTransformMetaDataProducer2 = new RemoveImageTransformMetaDataProducer(this$0.getBackgroundNetworkFetchToEncodedMemorySequence());
                removeImageTransformMetaDataProducer = removeImageTransformMetaDataProducer2;
            }
            finally {
                FrescoSystrace.endSection();
            }
        }
        return removeImageTransformMetaDataProducer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final RemoveImageTransformMetaDataProducer localFileFetchEncodedImageProducerSequence_delegate$lambda$4(ProducerSequenceFactory this$0) {
        RemoveImageTransformMetaDataProducer removeImageTransformMetaDataProducer;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        FrescoSystrace frescoSystrace = FrescoSystrace.INSTANCE;
        String name$iv = "ProducerSequenceFactory#getLocalFileFetchEncodedImageProducerSequence:init";
        boolean $i$f$traceSection = false;
        if (!FrescoSystrace.isTracing()) {
            boolean bl = false;
            removeImageTransformMetaDataProducer = new RemoveImageTransformMetaDataProducer(this$0.getBackgroundLocalFileFetchToEncodeMemorySequence());
        } else {
            FrescoSystrace.beginSection((String)name$iv);
            try {
                boolean bl = false;
                RemoveImageTransformMetaDataProducer removeImageTransformMetaDataProducer2 = new RemoveImageTransformMetaDataProducer(this$0.getBackgroundLocalFileFetchToEncodeMemorySequence());
                removeImageTransformMetaDataProducer = removeImageTransformMetaDataProducer2;
            }
            finally {
                FrescoSystrace.endSection();
            }
        }
        return removeImageTransformMetaDataProducer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final RemoveImageTransformMetaDataProducer localContentUriFetchEncodedImageProducerSequence_delegate$lambda$6(ProducerSequenceFactory this$0) {
        RemoveImageTransformMetaDataProducer removeImageTransformMetaDataProducer;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        FrescoSystrace frescoSystrace = FrescoSystrace.INSTANCE;
        String name$iv = "ProducerSequenceFactory#getLocalContentUriFetchEncodedImageProducerSequence:init";
        boolean $i$f$traceSection = false;
        if (!FrescoSystrace.isTracing()) {
            boolean bl = false;
            removeImageTransformMetaDataProducer = new RemoveImageTransformMetaDataProducer(this$0.getBackgroundLocalContentUriFetchToEncodeMemorySequence());
        } else {
            FrescoSystrace.beginSection((String)name$iv);
            try {
                boolean bl = false;
                RemoveImageTransformMetaDataProducer removeImageTransformMetaDataProducer2 = new RemoveImageTransformMetaDataProducer(this$0.getBackgroundLocalContentUriFetchToEncodeMemorySequence());
                removeImageTransformMetaDataProducer = removeImageTransformMetaDataProducer2;
            }
            finally {
                FrescoSystrace.endSection();
            }
        }
        return removeImageTransformMetaDataProducer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Producer networkFetchSequence_delegate$lambda$11(ProducerSequenceFactory this$0) {
        Producer<CloseableReference<CloseableImage>> producer;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        FrescoSystrace frescoSystrace = FrescoSystrace.INSTANCE;
        String name$iv = "ProducerSequenceFactory#getNetworkFetchSequence:init";
        boolean $i$f$traceSection = false;
        if (!FrescoSystrace.isTracing()) {
            boolean bl = false;
            producer = this$0.newBitmapCacheGetToDecodeSequence(this$0.getCommonNetworkFetchToEncodedMemorySequence());
        } else {
            FrescoSystrace.beginSection((String)name$iv);
            try {
                boolean bl = false;
                Producer<CloseableReference<CloseableImage>> producer2 = this$0.newBitmapCacheGetToDecodeSequence(this$0.getCommonNetworkFetchToEncodedMemorySequence());
                producer = producer2;
            }
            finally {
                FrescoSystrace.endSection();
            }
        }
        return producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Producer backgroundNetworkFetchToEncodedMemorySequence_delegate$lambda$13(ProducerSequenceFactory this$0) {
        Producer<EncodedImage> producer;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        FrescoSystrace frescoSystrace = FrescoSystrace.INSTANCE;
        String name$iv = "ProducerSequenceFactory#getBackgroundNetworkFetchToEncodedMemorySequence:init";
        boolean $i$f$traceSection = false;
        if (!FrescoSystrace.isTracing()) {
            boolean bl = false;
            producer = this$0.producerFactory.newBackgroundThreadHandoffProducer(this$0.getCommonNetworkFetchToEncodedMemorySequence(), this$0.threadHandoffProducerQueue);
        } else {
            FrescoSystrace.beginSection((String)name$iv);
            try {
                boolean bl = false;
                Producer<EncodedImage> producer2 = this$0.producerFactory.newBackgroundThreadHandoffProducer(this$0.getCommonNetworkFetchToEncodedMemorySequence(), this$0.threadHandoffProducerQueue);
                producer = producer2;
            }
            finally {
                FrescoSystrace.endSection();
            }
        }
        return producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final SwallowResultProducer networkFetchToEncodedMemoryPrefetchSequence_delegate$lambda$15(ProducerSequenceFactory this$0) {
        SwallowResultProducer<EncodedImage> swallowResultProducer;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        FrescoSystrace frescoSystrace = FrescoSystrace.INSTANCE;
        String name$iv = "ProducerSequenceFactory#getNetworkFetchToEncodedMemoryPrefetchSequence";
        boolean $i$f$traceSection = false;
        if (!FrescoSystrace.isTracing()) {
            boolean bl = false;
            swallowResultProducer = this$0.producerFactory.newSwallowResultProducer(this$0.getBackgroundNetworkFetchToEncodedMemorySequence());
        } else {
            FrescoSystrace.beginSection((String)name$iv);
            try {
                boolean bl = false;
                SwallowResultProducer<EncodedImage> swallowResultProducer2 = this$0.producerFactory.newSwallowResultProducer(this$0.getBackgroundNetworkFetchToEncodedMemorySequence());
                swallowResultProducer = swallowResultProducer2;
            }
            finally {
                FrescoSystrace.endSection();
            }
        }
        return swallowResultProducer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Producer commonNetworkFetchToEncodedMemorySequence_delegate$lambda$17(ProducerSequenceFactory this$0) {
        Producer<EncodedImage> producer;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        FrescoSystrace frescoSystrace = FrescoSystrace.INSTANCE;
        String name$iv = "ProducerSequenceFactory#getCommonNetworkFetchToEncodedMemorySequence";
        boolean $i$f$traceSection = false;
        if (!FrescoSystrace.isTracing()) {
            boolean bl = false;
            producer = this$0.newCommonNetworkFetchToEncodedMemorySequence(this$0.networkFetcher);
        } else {
            FrescoSystrace.beginSection((String)name$iv);
            try {
                boolean bl = false;
                Producer<EncodedImage> producer2 = this$0.newCommonNetworkFetchToEncodedMemorySequence(this$0.networkFetcher);
                producer = producer2;
            }
            finally {
                FrescoSystrace.endSection();
            }
        }
        return producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final SwallowResultProducer localFileFetchToEncodedMemoryPrefetchSequence_delegate$lambda$20(ProducerSequenceFactory this$0) {
        SwallowResultProducer<EncodedImage> swallowResultProducer;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        FrescoSystrace frescoSystrace = FrescoSystrace.INSTANCE;
        String name$iv = "ProducerSequenceFactory#getLocalFileFetchToEncodedMemoryPrefetchSequence:init";
        boolean $i$f$traceSection = false;
        if (!FrescoSystrace.isTracing()) {
            boolean bl = false;
            swallowResultProducer = this$0.producerFactory.newSwallowResultProducer(this$0.getBackgroundLocalFileFetchToEncodeMemorySequence());
        } else {
            FrescoSystrace.beginSection((String)name$iv);
            try {
                boolean bl = false;
                SwallowResultProducer<EncodedImage> swallowResultProducer2 = this$0.producerFactory.newSwallowResultProducer(this$0.getBackgroundLocalFileFetchToEncodeMemorySequence());
                swallowResultProducer = swallowResultProducer2;
            }
            finally {
                FrescoSystrace.endSection();
            }
        }
        return swallowResultProducer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Producer backgroundLocalFileFetchToEncodeMemorySequence_delegate$lambda$22(ProducerSequenceFactory this$0) {
        Producer<EncodedImage> producer;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        FrescoSystrace frescoSystrace = FrescoSystrace.INSTANCE;
        String name$iv = "ProducerSequenceFactory#getBackgroundLocalFileFetchToEncodeMemorySequence";
        boolean $i$f$traceSection = false;
        if (!FrescoSystrace.isTracing()) {
            boolean bl = false;
            LocalFileFetchProducer localFileFetchProducer = this$0.producerFactory.newLocalFileFetchProducer();
            Intrinsics.checkNotNullExpressionValue((Object)localFileFetchProducer, (String)"newLocalFileFetchProducer(...)");
            LocalFileFetchProducer localFileFetchProducer2 = localFileFetchProducer;
            Producer<EncodedImage> toEncodedMultiplexProducer = this$0.newEncodedCacheMultiplexToTranscodeSequence(localFileFetchProducer2);
            producer = this$0.producerFactory.newBackgroundThreadHandoffProducer(toEncodedMultiplexProducer, this$0.threadHandoffProducerQueue);
        } else {
            FrescoSystrace.beginSection((String)name$iv);
            try {
                boolean bl = false;
                LocalFileFetchProducer localFileFetchProducer = this$0.producerFactory.newLocalFileFetchProducer();
                Intrinsics.checkNotNullExpressionValue((Object)localFileFetchProducer, (String)"newLocalFileFetchProducer(...)");
                LocalFileFetchProducer localFileFetchProducer3 = localFileFetchProducer;
                Producer<EncodedImage> toEncodedMultiplexProducer = this$0.newEncodedCacheMultiplexToTranscodeSequence(localFileFetchProducer3);
                Producer<EncodedImage> producer2 = this$0.producerFactory.newBackgroundThreadHandoffProducer(toEncodedMultiplexProducer, this$0.threadHandoffProducerQueue);
                producer = producer2;
            }
            finally {
                FrescoSystrace.endSection();
            }
        }
        return producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Producer backgroundLocalContentUriFetchToEncodeMemorySequence_delegate$lambda$24(ProducerSequenceFactory this$0) {
        Producer<EncodedImage> producer;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        FrescoSystrace frescoSystrace = FrescoSystrace.INSTANCE;
        String name$iv = "ProducerSequenceFactory#getBackgroundLocalContentUriFetchToEncodeMemorySequence:init";
        boolean $i$f$traceSection = false;
        if (!FrescoSystrace.isTracing()) {
            boolean bl = false;
            LocalContentUriFetchProducer localContentUriFetchProducer = this$0.producerFactory.newLocalContentUriFetchProducer();
            Intrinsics.checkNotNullExpressionValue((Object)localContentUriFetchProducer, (String)"newLocalContentUriFetchProducer(...)");
            LocalContentUriFetchProducer localFileFetchProducer = localContentUriFetchProducer;
            Producer<EncodedImage> toEncodedMultiplexProducer = this$0.newEncodedCacheMultiplexToTranscodeSequence(localFileFetchProducer);
            producer = this$0.producerFactory.newBackgroundThreadHandoffProducer(toEncodedMultiplexProducer, this$0.threadHandoffProducerQueue);
        } else {
            FrescoSystrace.beginSection((String)name$iv);
            try {
                boolean bl = false;
                LocalContentUriFetchProducer localContentUriFetchProducer = this$0.producerFactory.newLocalContentUriFetchProducer();
                Intrinsics.checkNotNullExpressionValue((Object)localContentUriFetchProducer, (String)"newLocalContentUriFetchProducer(...)");
                LocalContentUriFetchProducer localFileFetchProducer = localContentUriFetchProducer;
                Producer<EncodedImage> toEncodedMultiplexProducer = this$0.newEncodedCacheMultiplexToTranscodeSequence(localFileFetchProducer);
                Producer<EncodedImage> producer2 = this$0.producerFactory.newBackgroundThreadHandoffProducer(toEncodedMultiplexProducer, this$0.threadHandoffProducerQueue);
                producer = producer2;
            }
            finally {
                FrescoSystrace.endSection();
            }
        }
        return producer;
    }

    private static final Producer localImageFileFetchSequence_delegate$lambda$25(ProducerSequenceFactory this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        LocalFileFetchProducer localFileFetchProducer = this$0.producerFactory.newLocalFileFetchProducer();
        Intrinsics.checkNotNullExpressionValue((Object)localFileFetchProducer, (String)"newLocalFileFetchProducer(...)");
        LocalFileFetchProducer localFileFetchProducer2 = localFileFetchProducer;
        return this$0.newBitmapCacheGetToLocalTransformSequence(localFileFetchProducer2);
    }

    private static final Producer localVideoFileFetchSequence_delegate$lambda$26(ProducerSequenceFactory this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        LocalVideoThumbnailProducer localVideoThumbnailProducer = this$0.producerFactory.newLocalVideoThumbnailProducer();
        Intrinsics.checkNotNullExpressionValue((Object)localVideoThumbnailProducer, (String)"newLocalVideoThumbnailProducer(...)");
        LocalVideoThumbnailProducer localVideoThumbnailProducer2 = localVideoThumbnailProducer;
        return this$0.newBitmapCacheGetToBitmapCacheSequence(localVideoThumbnailProducer2);
    }

    private static final Producer localContentUriFetchSequence_delegate$lambda$27(ProducerSequenceFactory this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        LocalContentUriFetchProducer localContentUriFetchProducer = this$0.producerFactory.newLocalContentUriFetchProducer();
        Intrinsics.checkNotNullExpressionValue((Object)localContentUriFetchProducer, (String)"newLocalContentUriFetchProducer(...)");
        LocalContentUriFetchProducer localContentUriFetchProducer2 = localContentUriFetchProducer;
        ThumbnailProducer[] thumbnailProducerArray = new ThumbnailProducer[]{this$0.producerFactory.newLocalContentUriThumbnailFetchProducer(), this$0.producerFactory.newLocalExifThumbnailProducer()};
        ThumbnailProducer[] thumbnailProducers = thumbnailProducerArray;
        return this$0.newBitmapCacheGetToLocalTransformSequence(localContentUriFetchProducer2, thumbnailProducers);
    }

    private static final Producer localThumbnailBitmapSdk29FetchSequence_delegate$lambda$28(ProducerSequenceFactory this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (Build.VERSION.SDK_INT < 29) {
            throw new Throwable("Unreachable exception. Just to make linter happy for the lazy block.");
        }
        LocalThumbnailBitmapSdk29Producer localThumbnailBitmapSdk29Producer = this$0.producerFactory.newLocalThumbnailBitmapSdk29Producer();
        Intrinsics.checkNotNullExpressionValue((Object)localThumbnailBitmapSdk29Producer, (String)"newLocalThumbnailBitmapSdk29Producer(...)");
        return this$0.newBitmapCacheGetToBitmapCacheSequence(localThumbnailBitmapSdk29Producer);
    }

    private static final Producer qualifiedResourceFetchSequence_delegate$lambda$29(ProducerSequenceFactory this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        QualifiedResourceFetchProducer qualifiedResourceFetchProducer = this$0.producerFactory.newQualifiedResourceFetchProducer();
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedResourceFetchProducer, (String)"newQualifiedResourceFetchProducer(...)");
        QualifiedResourceFetchProducer qualifiedResourceFetchProducer2 = qualifiedResourceFetchProducer;
        return this$0.newBitmapCacheGetToLocalTransformSequence(qualifiedResourceFetchProducer2);
    }

    private static final Producer localResourceFetchSequence_delegate$lambda$30(ProducerSequenceFactory this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        LocalResourceFetchProducer localResourceFetchProducer = this$0.producerFactory.newLocalResourceFetchProducer();
        Intrinsics.checkNotNullExpressionValue((Object)localResourceFetchProducer, (String)"newLocalResourceFetchProducer(...)");
        LocalResourceFetchProducer localResourceFetchProducer2 = localResourceFetchProducer;
        return this$0.newBitmapCacheGetToLocalTransformSequence(localResourceFetchProducer2);
    }

    private static final Producer localAssetFetchSequence_delegate$lambda$31(ProducerSequenceFactory this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        LocalAssetFetchProducer localAssetFetchProducer = this$0.producerFactory.newLocalAssetFetchProducer();
        Intrinsics.checkNotNullExpressionValue((Object)localAssetFetchProducer, (String)"newLocalAssetFetchProducer(...)");
        LocalAssetFetchProducer localAssetFetchProducer2 = localAssetFetchProducer;
        return this$0.newBitmapCacheGetToLocalTransformSequence(localAssetFetchProducer2);
    }

    private static final Producer dataFetchSequence_delegate$lambda$32(ProducerSequenceFactory this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DataFetchProducer dataFetchProducer = this$0.producerFactory.newDataFetchProducer();
        Intrinsics.checkNotNullExpressionValue((Object)dataFetchProducer, (String)"newDataFetchProducer(...)");
        Producer inputProducer = dataFetchProducer;
        inputProducer = ProducerFactory.newAddImageTransformMetaDataProducer(inputProducer);
        inputProducer = this$0.producerFactory.newResizeAndRotateProducer(inputProducer, true, this$0.imageTranscoderFactory);
        return this$0.newBitmapCacheGetToDecodeSequence(inputProducer);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lcom/facebook/imagepipeline/core/ProducerSequenceFactory$Companion;", "", "<init>", "()V", "validateEncodedImageRequest", "", "imageRequest", "Lcom/facebook/imagepipeline/request/ImageRequest;", "getShortenedUriString", "", "uri", "Landroid/net/Uri;", "imagepipeline_release"})
    public static final class Companion {
        private Companion() {
        }

        private final void validateEncodedImageRequest(ImageRequest imageRequest) {
            Preconditions.checkArgument((Boolean)(imageRequest.getLowestPermittedRequestLevel().getValue() <= ImageRequest.RequestLevel.ENCODED_MEMORY_CACHE.getValue() ? 1 : 0));
        }

        private final String getShortenedUriString(Uri uri) {
            Object object;
            String string = uri.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String uriString = string;
            if (uriString.length() > 30) {
                String string2 = uriString.substring(0, 30);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                object = string2 + "...";
            } else {
                object = uriString;
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

