/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.infer.annotation.Nullsafe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class StagingArea {
    private static final Class<?> TAG = StagingArea.class;
    @GuardedBy(value="this")
    private Map<CacheKey, EncodedImage> mMap = new HashMap<CacheKey, EncodedImage>();

    private StagingArea() {
    }

    public static StagingArea getInstance() {
        return new StagingArea();
    }

    public synchronized void put(CacheKey key, EncodedImage encodedImage) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((Boolean)EncodedImage.isValid((EncodedImage)encodedImage));
        EncodedImage oldEntry = this.mMap.put(key, EncodedImage.cloneOrNull((EncodedImage)encodedImage));
        EncodedImage.closeSafely((EncodedImage)oldEntry);
        this.logStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        ArrayList<EncodedImage> old;
        StagingArea stagingArea = this;
        synchronized (stagingArea) {
            old = new ArrayList<EncodedImage>(this.mMap.values());
            this.mMap.clear();
        }
        for (int i = 0; i < old.size(); ++i) {
            EncodedImage encodedImage = (EncodedImage)old.get(i);
            if (encodedImage == null) continue;
            encodedImage.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(CacheKey key) {
        EncodedImage encodedImage;
        Preconditions.checkNotNull((Object)key);
        StagingArea stagingArea = this;
        synchronized (stagingArea) {
            encodedImage = this.mMap.remove(key);
        }
        if (encodedImage == null) {
            return false;
        }
        try {
            boolean bl = encodedImage.isValid();
            return bl;
        }
        finally {
            encodedImage.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean remove(CacheKey key, EncodedImage encodedImage) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)encodedImage);
        Preconditions.checkArgument((Boolean)EncodedImage.isValid((EncodedImage)encodedImage));
        EncodedImage oldValue = this.mMap.get(key);
        if (oldValue == null) {
            return false;
        }
        CloseableReference oldRef = oldValue.getByteBufferRef();
        CloseableReference ref = encodedImage.getByteBufferRef();
        try {
            if (oldRef == null || ref == null || oldRef.get() != ref.get()) {
                boolean bl = false;
                return bl;
            }
            this.mMap.remove(key);
        }
        finally {
            CloseableReference.closeSafely((CloseableReference)ref);
            CloseableReference.closeSafely((CloseableReference)oldRef);
            EncodedImage.closeSafely((EncodedImage)oldValue);
        }
        this.logStats();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public synchronized EncodedImage get(CacheKey key) {
        Preconditions.checkNotNull((Object)key);
        EncodedImage storedEncodedImage = this.mMap.get(key);
        if (storedEncodedImage != null) {
            EncodedImage encodedImage = storedEncodedImage;
            synchronized (encodedImage) {
                if (!EncodedImage.isValid((EncodedImage)storedEncodedImage)) {
                    this.mMap.remove(key);
                    FLog.w(TAG, (String)"Found closed reference %d for key %s (%d)", (Object[])new Object[]{System.identityHashCode(storedEncodedImage), key.getUriString(), System.identityHashCode(key)});
                    return null;
                }
                storedEncodedImage = EncodedImage.cloneOrNull((EncodedImage)storedEncodedImage);
            }
        }
        return storedEncodedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean containsKey(CacheKey key) {
        EncodedImage storedEncodedImage;
        Preconditions.checkNotNull((Object)key);
        if (!this.mMap.containsKey(key)) {
            return false;
        }
        EncodedImage encodedImage = storedEncodedImage = this.mMap.get(key);
        synchronized (encodedImage) {
            if (!EncodedImage.isValid((EncodedImage)storedEncodedImage)) {
                this.mMap.remove(key);
                FLog.w(TAG, (String)"Found closed reference %d for key %s (%d)", (Object[])new Object[]{System.identityHashCode(storedEncodedImage), key.getUriString(), System.identityHashCode(key)});
                return false;
            }
            return true;
        }
    }

    private synchronized void logStats() {
        FLog.v(TAG, (String)"Count = %d", (Object)this.mMap.size());
    }
}

