/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.bitmaps;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.core.CloseableReferenceFactory;
import com.facebook.imagepipeline.memory.BitmapPool;
import com.facebook.imageutils.BitmapUtil;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/facebook/imagepipeline/bitmaps/ArtBitmapFactory;", "Lcom/facebook/imagepipeline/bitmaps/PlatformBitmapFactory;", "bitmapPool", "Lcom/facebook/imagepipeline/memory/BitmapPool;", "closeableReferenceFactory", "Lcom/facebook/imagepipeline/core/CloseableReferenceFactory;", "<init>", "(Lcom/facebook/imagepipeline/memory/BitmapPool;Lcom/facebook/imagepipeline/core/CloseableReferenceFactory;)V", "createBitmapInternal", "Lcom/facebook/common/references/CloseableReference;", "Landroid/graphics/Bitmap;", "width", "", "height", "bitmapConfig", "Landroid/graphics/Bitmap$Config;", "imagepipeline_release"})
@TargetApi(value=21)
@ThreadSafe
public final class ArtBitmapFactory
extends PlatformBitmapFactory {
    @NotNull
    private final BitmapPool bitmapPool;
    @NotNull
    private final CloseableReferenceFactory closeableReferenceFactory;

    public ArtBitmapFactory(@NotNull BitmapPool bitmapPool, @NotNull CloseableReferenceFactory closeableReferenceFactory) {
        Intrinsics.checkNotNullParameter((Object)bitmapPool, (String)"bitmapPool");
        Intrinsics.checkNotNullParameter((Object)closeableReferenceFactory, (String)"closeableReferenceFactory");
        this.bitmapPool = bitmapPool;
        this.closeableReferenceFactory = closeableReferenceFactory;
    }

    @NotNull
    public CloseableReference<Bitmap> createBitmapInternal(int width, int height, @NotNull Bitmap.Config bitmapConfig) {
        Intrinsics.checkNotNullParameter((Object)bitmapConfig, (String)"bitmapConfig");
        int sizeInBytes = BitmapUtil.getSizeInByteForBitmap((int)width, (int)height, (Bitmap.Config)bitmapConfig);
        Bitmap bitmap = (Bitmap)this.bitmapPool.get(sizeInBytes);
        if (!(bitmap.getAllocationByteCount() >= width * height * BitmapUtil.getPixelSizeForBitmapConfig((Bitmap.Config)bitmapConfig))) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        bitmap.reconfigure(width, height, bitmapConfig);
        CloseableReference<Bitmap> closeableReference = this.closeableReferenceFactory.create(bitmap, (ResourceReleaser)this.bitmapPool);
        Intrinsics.checkNotNullExpressionValue(closeableReference, (String)"create(...)");
        return closeableReference;
    }
}

