/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.image.EncodedImage;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\u001c\u0010\t\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/facebook/imagepipeline/producers/ThumbnailSizeChecker;", "", "<init>", "()V", "ACCEPTABLE_REQUESTED_TO_ACTUAL_SIZE_RATIO", "", "ROTATED_90_DEGREES_CLOCKWISE", "", "ROTATED_90_DEGREES_COUNTER_CLOCKWISE", "isImageBigEnough", "", "width", "height", "resizeOptions", "Lcom/facebook/imagepipeline/common/ResizeOptions;", "encodedImage", "Lcom/facebook/imagepipeline/image/EncodedImage;", "getAcceptableSize", "size", "imagepipeline_release"})
public final class ThumbnailSizeChecker {
    @NotNull
    public static final ThumbnailSizeChecker INSTANCE = new ThumbnailSizeChecker();
    public static final float ACCEPTABLE_REQUESTED_TO_ACTUAL_SIZE_RATIO = 1.3333334f;
    private static final int ROTATED_90_DEGREES_CLOCKWISE = 90;
    private static final int ROTATED_90_DEGREES_COUNTER_CLOCKWISE = 270;

    private ThumbnailSizeChecker() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isImageBigEnough(int width, int height, @Nullable ResizeOptions resizeOptions) {
        if (resizeOptions == null) {
            if (!((float)ThumbnailSizeChecker.getAcceptableSize(width) >= 2048.0f)) return false;
            if (ThumbnailSizeChecker.getAcceptableSize(height) < 2048) return false;
            return true;
        }
        if (ThumbnailSizeChecker.getAcceptableSize(width) < resizeOptions.width) return false;
        if (ThumbnailSizeChecker.getAcceptableSize(height) < resizeOptions.height) return false;
        return true;
    }

    @JvmStatic
    public static final boolean isImageBigEnough(@Nullable EncodedImage encodedImage, @Nullable ResizeOptions resizeOptions) {
        boolean bl;
        if (encodedImage == null) {
            bl = false;
        } else {
            switch (encodedImage.getRotationAngle()) {
                case 90: 
                case 270: {
                    bl = ThumbnailSizeChecker.isImageBigEnough(encodedImage.getHeight(), encodedImage.getWidth(), resizeOptions);
                    break;
                }
                default: {
                    bl = ThumbnailSizeChecker.isImageBigEnough(encodedImage.getWidth(), encodedImage.getHeight(), resizeOptions);
                }
            }
        }
        return bl;
    }

    @JvmStatic
    public static final int getAcceptableSize(int size) {
        return (int)((float)size * 1.3333334f);
    }
}

