/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.Supplier;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.cache.BoundedLinkedHashSet;
import com.facebook.imagepipeline.cache.BufferedDiskCache;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.core.DiskCachesStore;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener2;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.systrace.FrescoSystrace;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class EncodedProbeProducer
implements Producer<EncodedImage> {
    public static final String PRODUCER_NAME = "EncodedProbeProducer";
    private final Supplier<DiskCachesStore> mDiskCachesStoreSupplier;
    private final CacheKeyFactory mCacheKeyFactory;
    private final Producer<EncodedImage> mInputProducer;
    private final BoundedLinkedHashSet<CacheKey> mEncodedMemoryCacheHistory;
    private final BoundedLinkedHashSet<CacheKey> mDiskCacheHistory;

    public EncodedProbeProducer(Supplier<DiskCachesStore> diskCachesStoreSupplier, CacheKeyFactory cacheKeyFactory, BoundedLinkedHashSet encodedMemoryCacheHistory, BoundedLinkedHashSet diskCacheHistory, Producer<EncodedImage> inputProducer) {
        this.mDiskCachesStoreSupplier = diskCachesStoreSupplier;
        this.mCacheKeyFactory = cacheKeyFactory;
        this.mEncodedMemoryCacheHistory = encodedMemoryCacheHistory;
        this.mDiskCacheHistory = diskCacheHistory;
        this.mInputProducer = inputProducer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void produceResults(Consumer<EncodedImage> consumer, ProducerContext producerContext) {
        try {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"EncodedProbeProducer#produceResults");
            }
            ProducerListener2 listener = producerContext.getProducerListener();
            listener.onProducerStart(producerContext, this.getProducerName());
            ProbeConsumer consumerOfInputProducer = new ProbeConsumer(consumer, producerContext, this.mDiskCachesStoreSupplier, this.mCacheKeyFactory, this.mEncodedMemoryCacheHistory, this.mDiskCacheHistory);
            listener.onProducerFinishWithSuccess(producerContext, PRODUCER_NAME, null);
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"mInputProducer.produceResult");
            }
            this.mInputProducer.produceResults(consumerOfInputProducer, producerContext);
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
        finally {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
    }

    protected String getProducerName() {
        return PRODUCER_NAME;
    }

    private static class ProbeConsumer
    extends DelegatingConsumer<EncodedImage, EncodedImage> {
        private final ProducerContext mProducerContext;
        private final Supplier<DiskCachesStore> mDefaultBufferedDiskCache;
        private final CacheKeyFactory mCacheKeyFactory;
        private final BoundedLinkedHashSet<CacheKey> mEncodedMemoryCacheHistory;
        private final BoundedLinkedHashSet<CacheKey> mDiskCacheHistory;

        public ProbeConsumer(Consumer<EncodedImage> consumer, ProducerContext producerContext, Supplier<DiskCachesStore> diskCachesStoreSupplier, CacheKeyFactory cacheKeyFactory, BoundedLinkedHashSet<CacheKey> encodedMemoryCacheHistory, BoundedLinkedHashSet<CacheKey> diskCacheHistory) {
            super(consumer);
            this.mProducerContext = producerContext;
            this.mDefaultBufferedDiskCache = diskCachesStoreSupplier;
            this.mCacheKeyFactory = cacheKeyFactory;
            this.mEncodedMemoryCacheHistory = encodedMemoryCacheHistory;
            this.mDiskCacheHistory = diskCacheHistory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNewResultImpl(@Nullable EncodedImage newResult, int status) {
            try {
                if (FrescoSystrace.isTracing()) {
                    FrescoSystrace.beginSection((String)"EncodedProbeProducer#onNewResultImpl");
                }
                if (ProbeConsumer.isNotLast(status) || newResult == null || ProbeConsumer.statusHasAnyFlag(status, 10) || newResult.getImageFormat() == ImageFormat.UNKNOWN) {
                    this.getConsumer().onNewResult(newResult, status);
                    return;
                }
                ImageRequest imageRequest = this.mProducerContext.getImageRequest();
                CacheKey cacheKey = this.mCacheKeyFactory.getEncodedCacheKey(imageRequest, this.mProducerContext.getCallerContext());
                this.mEncodedMemoryCacheHistory.add((Object)cacheKey);
                if ("memory_encoded".equals(this.mProducerContext.getExtra("origin"))) {
                    if (!this.mDiskCacheHistory.contains((Object)cacheKey)) {
                        boolean isSmallRequest = imageRequest.getCacheChoice() == ImageRequest.CacheChoice.SMALL;
                        DiskCachesStore diskCachesStore2 = (DiskCachesStore)this.mDefaultBufferedDiskCache.get();
                        BufferedDiskCache preferredCache = isSmallRequest ? diskCachesStore2.getSmallImageBufferedDiskCache() : diskCachesStore2.getMainBufferedDiskCache();
                        preferredCache.addKeyForAsyncProbing(cacheKey);
                        this.mDiskCacheHistory.add((Object)cacheKey);
                    }
                } else if ("disk".equals(this.mProducerContext.getExtra("origin"))) {
                    this.mDiskCacheHistory.add((Object)cacheKey);
                }
                this.getConsumer().onNewResult(newResult, status);
            }
            finally {
                if (FrescoSystrace.isTracing()) {
                    FrescoSystrace.endSection();
                }
            }
        }
    }
}

