/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.graphics.Bitmap;
import android.net.Uri;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.Supplier;
import com.facebook.common.logging.FLog;
import com.facebook.common.memory.ByteArrayPool;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.ExceptionWithNoStacktrace;
import com.facebook.common.util.UriUtil;
import com.facebook.imageformat.DefaultImageFormats;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.common.RotationOptions;
import com.facebook.imagepipeline.core.CloseableReferenceFactory;
import com.facebook.imagepipeline.core.DownsampleMode;
import com.facebook.imagepipeline.decoder.DecodeException;
import com.facebook.imagepipeline.decoder.ImageDecoder;
import com.facebook.imagepipeline.decoder.ProgressiveJpegConfig;
import com.facebook.imagepipeline.decoder.ProgressiveJpegParser;
import com.facebook.imagepipeline.image.CloseableBitmap;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.image.ImmutableQualityInfo;
import com.facebook.imagepipeline.image.QualityInfo;
import com.facebook.imagepipeline.producers.BaseConsumer;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.JobScheduler;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener2;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.facebook.imagepipeline.systrace.FrescoSystrace;
import com.facebook.imagepipeline.transcoder.DownsampleUtil;
import com.facebook.imageutils.BitmapUtil;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 =2\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0004:;<=Bw\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0001\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u0012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a\u00a2\u0006\u0004\b\u001b\u0010\u001cJ$\u00104\u001a\u0002052\u0012\u00106\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002072\u0006\u00108\u001a\u000209H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010(R\u0019\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103\u00a8\u0006>"}, d2={"Lcom/facebook/imagepipeline/producers/DecodeProducer;", "Lcom/facebook/imagepipeline/producers/Producer;", "Lcom/facebook/common/references/CloseableReference;", "Lcom/facebook/imagepipeline/image/CloseableImage;", "byteArrayPool", "Lcom/facebook/common/memory/ByteArrayPool;", "executor", "Ljava/util/concurrent/Executor;", "imageDecoder", "Lcom/facebook/imagepipeline/decoder/ImageDecoder;", "progressiveJpegConfig", "Lcom/facebook/imagepipeline/decoder/ProgressiveJpegConfig;", "downsampleMode", "Lcom/facebook/imagepipeline/core/DownsampleMode;", "downsampleEnabledForNetwork", "", "decodeCancellationEnabled", "inputProducer", "Lcom/facebook/imagepipeline/image/EncodedImage;", "maxBitmapDimension", "", "closeableReferenceFactory", "Lcom/facebook/imagepipeline/core/CloseableReferenceFactory;", "reclaimMemoryRunnable", "Ljava/lang/Runnable;", "recoverFromDecoderOOM", "Lcom/facebook/common/internal/Supplier;", "<init>", "(Lcom/facebook/common/memory/ByteArrayPool;Ljava/util/concurrent/Executor;Lcom/facebook/imagepipeline/decoder/ImageDecoder;Lcom/facebook/imagepipeline/decoder/ProgressiveJpegConfig;Lcom/facebook/imagepipeline/core/DownsampleMode;ZZLcom/facebook/imagepipeline/producers/Producer;ILcom/facebook/imagepipeline/core/CloseableReferenceFactory;Ljava/lang/Runnable;Lcom/facebook/common/internal/Supplier;)V", "getByteArrayPool", "()Lcom/facebook/common/memory/ByteArrayPool;", "getExecutor", "()Ljava/util/concurrent/Executor;", "getImageDecoder", "()Lcom/facebook/imagepipeline/decoder/ImageDecoder;", "getProgressiveJpegConfig", "()Lcom/facebook/imagepipeline/decoder/ProgressiveJpegConfig;", "getDownsampleMode", "()Lcom/facebook/imagepipeline/core/DownsampleMode;", "getDownsampleEnabledForNetwork", "()Z", "getDecodeCancellationEnabled", "getInputProducer", "()Lcom/facebook/imagepipeline/producers/Producer;", "getMaxBitmapDimension", "()I", "getCloseableReferenceFactory", "()Lcom/facebook/imagepipeline/core/CloseableReferenceFactory;", "getReclaimMemoryRunnable", "()Ljava/lang/Runnable;", "getRecoverFromDecoderOOM", "()Lcom/facebook/common/internal/Supplier;", "produceResults", "", "consumer", "Lcom/facebook/imagepipeline/producers/Consumer;", "context", "Lcom/facebook/imagepipeline/producers/ProducerContext;", "ProgressiveDecoder", "LocalImagesProgressiveDecoder", "NetworkImagesProgressiveDecoder", "Companion", "imagepipeline_release"})
@SourceDebugExtension(value={"SMAP\nDecodeProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecodeProducer.kt\ncom/facebook/imagepipeline/producers/DecodeProducer\n+ 2 FrescoSystrace.kt\ncom/facebook/imagepipeline/systrace/FrescoSystrace\n*L\n1#1,550:1\n40#2,9:551\n*S KotlinDebug\n*F\n+ 1 DecodeProducer.kt\ncom/facebook/imagepipeline/producers/DecodeProducer\n*L\n68#1:551,9\n*E\n"})
public final class DecodeProducer
implements Producer<CloseableReference<CloseableImage>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteArrayPool byteArrayPool;
    @NotNull
    private final Executor executor;
    @NotNull
    private final ImageDecoder imageDecoder;
    @NotNull
    private final ProgressiveJpegConfig progressiveJpegConfig;
    @NotNull
    private final DownsampleMode downsampleMode;
    private final boolean downsampleEnabledForNetwork;
    private final boolean decodeCancellationEnabled;
    @NotNull
    private final Producer<EncodedImage> inputProducer;
    private final int maxBitmapDimension;
    @NotNull
    private final CloseableReferenceFactory closeableReferenceFactory;
    @Nullable
    private final Runnable reclaimMemoryRunnable;
    @NotNull
    private final Supplier<Boolean> recoverFromDecoderOOM;
    @NotNull
    public static final String PRODUCER_NAME = "DecodeProducer";
    private static final int DECODE_EXCEPTION_MESSAGE_NUM_HEADER_BYTES = 10;
    private static final int MAX_BITMAP_SIZE = 0x6400000;
    @NotNull
    public static final String EXTRA_BITMAP_SIZE = "bitmapSize";
    @NotNull
    public static final String EXTRA_HAS_GOOD_QUALITY = "hasGoodQuality";
    @NotNull
    public static final String EXTRA_IS_FINAL = "isFinal";
    @NotNull
    public static final String EXTRA_IMAGE_FORMAT_NAME = "imageFormat";
    @NotNull
    public static final String EXTRA_BITMAP_BYTES = "byteCount";
    @NotNull
    public static final String ENCODED_IMAGE_SIZE = "encodedImageSize";
    @NotNull
    public static final String REQUESTED_IMAGE_SIZE = "requestedImageSize";
    @NotNull
    public static final String SAMPLE_SIZE = "sampleSize";
    @NotNull
    public static final String NON_FATAL_DECODE_ERROR = "non_fatal_decode_error";

    public DecodeProducer(@NotNull ByteArrayPool byteArrayPool, @NotNull Executor executor, @NotNull ImageDecoder imageDecoder, @NotNull ProgressiveJpegConfig progressiveJpegConfig, @NotNull DownsampleMode downsampleMode, boolean downsampleEnabledForNetwork, boolean decodeCancellationEnabled, @NotNull Producer<EncodedImage> inputProducer, int maxBitmapDimension, @NotNull CloseableReferenceFactory closeableReferenceFactory, @Nullable Runnable reclaimMemoryRunnable, @NotNull Supplier<Boolean> recoverFromDecoderOOM) {
        Intrinsics.checkNotNullParameter((Object)byteArrayPool, (String)"byteArrayPool");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)imageDecoder, (String)"imageDecoder");
        Intrinsics.checkNotNullParameter((Object)progressiveJpegConfig, (String)"progressiveJpegConfig");
        Intrinsics.checkNotNullParameter((Object)((Object)downsampleMode), (String)"downsampleMode");
        Intrinsics.checkNotNullParameter(inputProducer, (String)"inputProducer");
        Intrinsics.checkNotNullParameter((Object)closeableReferenceFactory, (String)"closeableReferenceFactory");
        Intrinsics.checkNotNullParameter(recoverFromDecoderOOM, (String)"recoverFromDecoderOOM");
        this.byteArrayPool = byteArrayPool;
        this.executor = executor;
        this.imageDecoder = imageDecoder;
        this.progressiveJpegConfig = progressiveJpegConfig;
        this.downsampleMode = downsampleMode;
        this.downsampleEnabledForNetwork = downsampleEnabledForNetwork;
        this.decodeCancellationEnabled = decodeCancellationEnabled;
        this.inputProducer = inputProducer;
        this.maxBitmapDimension = maxBitmapDimension;
        this.closeableReferenceFactory = closeableReferenceFactory;
        this.reclaimMemoryRunnable = reclaimMemoryRunnable;
        this.recoverFromDecoderOOM = recoverFromDecoderOOM;
    }

    @NotNull
    public final ByteArrayPool getByteArrayPool() {
        return this.byteArrayPool;
    }

    @NotNull
    public final Executor getExecutor() {
        return this.executor;
    }

    @NotNull
    public final ImageDecoder getImageDecoder() {
        return this.imageDecoder;
    }

    @NotNull
    public final ProgressiveJpegConfig getProgressiveJpegConfig() {
        return this.progressiveJpegConfig;
    }

    @NotNull
    public final DownsampleMode getDownsampleMode() {
        return this.downsampleMode;
    }

    public final boolean getDownsampleEnabledForNetwork() {
        return this.downsampleEnabledForNetwork;
    }

    public final boolean getDecodeCancellationEnabled() {
        return this.decodeCancellationEnabled;
    }

    @NotNull
    public final Producer<EncodedImage> getInputProducer() {
        return this.inputProducer;
    }

    public final int getMaxBitmapDimension() {
        return this.maxBitmapDimension;
    }

    @NotNull
    public final CloseableReferenceFactory getCloseableReferenceFactory() {
        return this.closeableReferenceFactory;
    }

    @Nullable
    public final Runnable getReclaimMemoryRunnable() {
        return this.reclaimMemoryRunnable;
    }

    @NotNull
    public final Supplier<Boolean> getRecoverFromDecoderOOM() {
        return this.recoverFromDecoderOOM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void produceResults(@NotNull Consumer<CloseableReference<CloseableImage>> consumer, @NotNull ProducerContext context) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        FrescoSystrace frescoSystrace = FrescoSystrace.INSTANCE;
        String name$iv = "DecodeProducer#produceResults";
        boolean $i$f$traceSection = false;
        if (!FrescoSystrace.isTracing()) {
            ProgressiveDecoder progressiveDecoder;
            boolean bl = false;
            ImageRequest imageRequest = context.getImageRequest();
            if (!UriUtil.isNetworkUri((Uri)imageRequest.getSourceUri()) && !ImageRequestBuilder.isCustomNetworkUri(imageRequest.getSourceUri())) {
                progressiveDecoder = new LocalImagesProgressiveDecoder(consumer, context, this.decodeCancellationEnabled, this.maxBitmapDimension);
            } else {
                ProgressiveJpegParser jpegParser = new ProgressiveJpegParser(this.byteArrayPool);
                progressiveDecoder = new NetworkImagesProgressiveDecoder(consumer, context, jpegParser, this.progressiveJpegConfig, this.decodeCancellationEnabled, this.maxBitmapDimension);
            }
            ProgressiveDecoder progressiveDecoder2 = progressiveDecoder;
            this.inputProducer.produceResults(progressiveDecoder2, context);
        } else {
            FrescoSystrace.beginSection((String)name$iv);
            try {
                ProgressiveDecoder progressiveDecoder;
                boolean bl = false;
                ImageRequest imageRequest = context.getImageRequest();
                if (!UriUtil.isNetworkUri((Uri)imageRequest.getSourceUri()) && !ImageRequestBuilder.isCustomNetworkUri(imageRequest.getSourceUri())) {
                    progressiveDecoder = new LocalImagesProgressiveDecoder(consumer, context, this.decodeCancellationEnabled, this.maxBitmapDimension);
                } else {
                    ProgressiveJpegParser jpegParser = new ProgressiveJpegParser(this.byteArrayPool);
                    progressiveDecoder = new NetworkImagesProgressiveDecoder(consumer, context, jpegParser, this.progressiveJpegConfig, this.decodeCancellationEnabled, this.maxBitmapDimension);
                }
                ProgressiveDecoder progressiveDecoder3 = progressiveDecoder;
                this.inputProducer.produceResults(progressiveDecoder3, context);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                FrescoSystrace.endSection();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/facebook/imagepipeline/producers/DecodeProducer$Companion;", "", "<init>", "()V", "PRODUCER_NAME", "", "DECODE_EXCEPTION_MESSAGE_NUM_HEADER_BYTES", "", "MAX_BITMAP_SIZE", "EXTRA_BITMAP_SIZE", "EXTRA_HAS_GOOD_QUALITY", "EXTRA_IS_FINAL", "EXTRA_IMAGE_FORMAT_NAME", "EXTRA_BITMAP_BYTES", "ENCODED_IMAGE_SIZE", "REQUESTED_IMAGE_SIZE", "SAMPLE_SIZE", "NON_FATAL_DECODE_ERROR", "isTooBig", "", "encodedImage", "Lcom/facebook/imagepipeline/image/EncodedImage;", "imageDecodeOptions", "Lcom/facebook/imagepipeline/common/ImageDecodeOptions;", "imagepipeline_release"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isTooBig(EncodedImage encodedImage, ImageDecodeOptions imageDecodeOptions) {
            int size;
            long h;
            long w = encodedImage.getWidth();
            return w * (h = (long)encodedImage.getHeight()) * (long)(size = BitmapUtil.getPixelSizeForBitmapConfig((Bitmap.Config)imageDecodeOptions.bitmapConfig)) > 0x6400000L;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B3\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0014J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0014\u0010\u0014\u001a\u00020\u00158TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/facebook/imagepipeline/producers/DecodeProducer$LocalImagesProgressiveDecoder;", "Lcom/facebook/imagepipeline/producers/DecodeProducer$ProgressiveDecoder;", "Lcom/facebook/imagepipeline/producers/DecodeProducer;", "consumer", "Lcom/facebook/imagepipeline/producers/Consumer;", "Lcom/facebook/common/references/CloseableReference;", "Lcom/facebook/imagepipeline/image/CloseableImage;", "producerContext", "Lcom/facebook/imagepipeline/producers/ProducerContext;", "decodeCancellationEnabled", "", "maxBitmapDimension", "", "<init>", "(Lcom/facebook/imagepipeline/producers/DecodeProducer;Lcom/facebook/imagepipeline/producers/Consumer;Lcom/facebook/imagepipeline/producers/ProducerContext;ZI)V", "updateDecodeJob", "encodedImage", "Lcom/facebook/imagepipeline/image/EncodedImage;", "status", "getIntermediateImageEndOffset", "qualityInfo", "Lcom/facebook/imagepipeline/image/QualityInfo;", "getQualityInfo", "()Lcom/facebook/imagepipeline/image/QualityInfo;", "imagepipeline_release"})
    private final class LocalImagesProgressiveDecoder
    extends ProgressiveDecoder {
        public LocalImagesProgressiveDecoder(@NotNull Consumer<CloseableReference<CloseableImage>> consumer, ProducerContext producerContext, boolean decodeCancellationEnabled, int maxBitmapDimension) {
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            Intrinsics.checkNotNullParameter((Object)producerContext, (String)"producerContext");
            super(consumer, producerContext, decodeCancellationEnabled, maxBitmapDimension);
        }

        @Override
        protected synchronized boolean updateDecodeJob(@Nullable EncodedImage encodedImage, int status) {
            return BaseConsumer.isNotLast(status) ? false : super.updateDecodeJob(encodedImage, status);
        }

        @Override
        protected int getIntermediateImageEndOffset(@NotNull EncodedImage encodedImage) {
            Intrinsics.checkNotNullParameter((Object)encodedImage, (String)"encodedImage");
            return encodedImage.getSize();
        }

        @Override
        @NotNull
        protected QualityInfo getQualityInfo() {
            QualityInfo qualityInfo = ImmutableQualityInfo.of((int)0, (boolean)false, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)qualityInfo, (String)"of(...)");
            return qualityInfo;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002BC\u0012\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001a\u0010\u0017\u001a\u00020\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0010H\u0014J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u001c\u001a\u00020\u001d8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/facebook/imagepipeline/producers/DecodeProducer$NetworkImagesProgressiveDecoder;", "Lcom/facebook/imagepipeline/producers/DecodeProducer$ProgressiveDecoder;", "Lcom/facebook/imagepipeline/producers/DecodeProducer;", "consumer", "Lcom/facebook/imagepipeline/producers/Consumer;", "Lcom/facebook/common/references/CloseableReference;", "Lcom/facebook/imagepipeline/image/CloseableImage;", "producerContext", "Lcom/facebook/imagepipeline/producers/ProducerContext;", "progressiveJpegParser", "Lcom/facebook/imagepipeline/decoder/ProgressiveJpegParser;", "progressiveJpegConfig", "Lcom/facebook/imagepipeline/decoder/ProgressiveJpegConfig;", "decodeCancellationEnabled", "", "maxBitmapDimension", "", "<init>", "(Lcom/facebook/imagepipeline/producers/DecodeProducer;Lcom/facebook/imagepipeline/producers/Consumer;Lcom/facebook/imagepipeline/producers/ProducerContext;Lcom/facebook/imagepipeline/decoder/ProgressiveJpegParser;Lcom/facebook/imagepipeline/decoder/ProgressiveJpegConfig;ZI)V", "getProgressiveJpegParser", "()Lcom/facebook/imagepipeline/decoder/ProgressiveJpegParser;", "getProgressiveJpegConfig", "()Lcom/facebook/imagepipeline/decoder/ProgressiveJpegConfig;", "updateDecodeJob", "encodedImage", "Lcom/facebook/imagepipeline/image/EncodedImage;", "status", "getIntermediateImageEndOffset", "qualityInfo", "Lcom/facebook/imagepipeline/image/QualityInfo;", "getQualityInfo", "()Lcom/facebook/imagepipeline/image/QualityInfo;", "imagepipeline_release"})
    private final class NetworkImagesProgressiveDecoder
    extends ProgressiveDecoder {
        @NotNull
        private final ProgressiveJpegParser progressiveJpegParser;
        @NotNull
        private final ProgressiveJpegConfig progressiveJpegConfig;

        public NetworkImagesProgressiveDecoder(@NotNull Consumer<CloseableReference<CloseableImage>> consumer, @NotNull ProducerContext producerContext, @NotNull ProgressiveJpegParser progressiveJpegParser, ProgressiveJpegConfig progressiveJpegConfig, boolean decodeCancellationEnabled, int maxBitmapDimension) {
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            Intrinsics.checkNotNullParameter((Object)producerContext, (String)"producerContext");
            Intrinsics.checkNotNullParameter((Object)progressiveJpegParser, (String)"progressiveJpegParser");
            Intrinsics.checkNotNullParameter((Object)progressiveJpegConfig, (String)"progressiveJpegConfig");
            super(consumer, producerContext, decodeCancellationEnabled, maxBitmapDimension);
            this.progressiveJpegParser = progressiveJpegParser;
            this.progressiveJpegConfig = progressiveJpegConfig;
            this.setLastScheduledScanNumber(0);
        }

        @NotNull
        public final ProgressiveJpegParser getProgressiveJpegParser() {
            return this.progressiveJpegParser;
        }

        @NotNull
        public final ProgressiveJpegConfig getProgressiveJpegConfig() {
            return this.progressiveJpegConfig;
        }

        @Override
        protected synchronized boolean updateDecodeJob(@Nullable EncodedImage encodedImage, int status) {
            if (encodedImage == null) {
                return false;
            }
            boolean ret = super.updateDecodeJob(encodedImage, status);
            if ((BaseConsumer.isNotLast(status) || BaseConsumer.statusHasFlag(status, 8)) && !BaseConsumer.statusHasFlag(status, 4) && EncodedImage.isValid((EncodedImage)encodedImage) && encodedImage.getImageFormat() == DefaultImageFormats.JPEG) {
                if (!this.progressiveJpegParser.parseMoreData(encodedImage)) {
                    return false;
                }
                int scanNum = this.progressiveJpegParser.getBestScanNumber();
                if (scanNum <= this.getLastScheduledScanNumber()) {
                    return false;
                }
                if (scanNum < this.progressiveJpegConfig.getNextScanNumberToDecode(this.getLastScheduledScanNumber()) && !this.progressiveJpegParser.isEndMarkerRead()) {
                    return false;
                }
                this.setLastScheduledScanNumber(scanNum);
            }
            return ret;
        }

        @Override
        protected int getIntermediateImageEndOffset(@NotNull EncodedImage encodedImage) {
            Intrinsics.checkNotNullParameter((Object)encodedImage, (String)"encodedImage");
            return this.progressiveJpegParser.getBestScanEndOffset();
        }

        @Override
        @NotNull
        protected QualityInfo getQualityInfo() {
            QualityInfo qualityInfo = this.progressiveJpegConfig.getQualityInfo(this.progressiveJpegParser.getBestScanNumber());
            Intrinsics.checkNotNullExpressionValue((Object)qualityInfo, (String)"getQualityInfo(...)");
            return qualityInfo;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\t\n\u0002\b\u0010\b\u00a2\u0004\u0018\u00002\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0001B3\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0002H\u0002J\u001a\u0010 \u001a\u00020\u001e2\b\u0010!\u001a\u0004\u0018\u00010\u00022\u0006\u0010\"\u001a\u00020\fH\u0016J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%H\u0014J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u001eH\u0016J\u001a\u0010*\u001a\u00020\n2\b\u0010+\u001a\u0004\u0018\u00010\u00022\u0006\u0010\"\u001a\u00020\fH\u0014J \u0010,\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fH\u0002J\"\u0010-\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\f2\u0006\u0010/\u001a\u000200H\u0002J\"\u00101\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00022\b\u00102\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0018\u001a\u00020\fH\u0002JX\u00103\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010\u0018\u0001042\b\u00102\u001a\u0004\u0018\u00010\u00042\u0006\u00105\u001a\u0002062\u0006\u0010/\u001a\u0002002\u0006\u00107\u001a\u00020\n2\u0006\u00108\u001a\u00020\u00102\u0006\u00109\u001a\u00020\u00102\u0006\u0010:\u001a\u00020\u00102\u0006\u0010;\u001a\u00020\u0010H\u0002J\u0010\u0010<\u001a\u00020\u001e2\u0006\u0010=\u001a\u00020\nH\u0002J\u001a\u0010>\u001a\u00020\u001e2\b\u0010?\u001a\u0004\u0018\u00010\u00042\u0006\u0010\"\u001a\u00020\fH\u0002J\u0010\u0010@\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010A\u001a\u00020\u001eH\u0002J\u0010\u0010B\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u0002H$R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u00020\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0012\u0010C\u001a\u000200X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010E\u00a8\u0006F"}, d2={"Lcom/facebook/imagepipeline/producers/DecodeProducer$ProgressiveDecoder;", "Lcom/facebook/imagepipeline/producers/DelegatingConsumer;", "Lcom/facebook/imagepipeline/image/EncodedImage;", "Lcom/facebook/common/references/CloseableReference;", "Lcom/facebook/imagepipeline/image/CloseableImage;", "consumer", "Lcom/facebook/imagepipeline/producers/Consumer;", "producerContext", "Lcom/facebook/imagepipeline/producers/ProducerContext;", "decodeCancellationEnabled", "", "maxBitmapDimension", "", "<init>", "(Lcom/facebook/imagepipeline/producers/DecodeProducer;Lcom/facebook/imagepipeline/producers/Consumer;Lcom/facebook/imagepipeline/producers/ProducerContext;ZI)V", "TAG", "", "producerListener", "Lcom/facebook/imagepipeline/producers/ProducerListener2;", "imageDecodeOptions", "Lcom/facebook/imagepipeline/common/ImageDecodeOptions;", "isFinished", "jobScheduler", "Lcom/facebook/imagepipeline/producers/JobScheduler;", "lastScheduledScanNumber", "getLastScheduledScanNumber", "()I", "setLastScheduledScanNumber", "(I)V", "maybeIncreaseSampleSize", "", "encodedImage", "onNewResultImpl", "newResult", "status", "onProgressUpdateImpl", "progress", "", "onFailureImpl", "t", "", "onCancellationImpl", "updateDecodeJob", "ref", "doDecode", "internalDecode", "length", "quality", "Lcom/facebook/imagepipeline/image/QualityInfo;", "setImageExtras", "image", "getExtraMap", "", "queueTime", "", "isFinal", "imageFormatName", "encodedImageSize", "requestImageSize", "sampleSize", "maybeFinish", "shouldFinish", "handleResult", "decodedImage", "handleError", "handleCancellation", "getIntermediateImageEndOffset", "qualityInfo", "getQualityInfo", "()Lcom/facebook/imagepipeline/image/QualityInfo;", "imagepipeline_release"})
    @SourceDebugExtension(value={"SMAP\nDecodeProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecodeProducer.kt\ncom/facebook/imagepipeline/producers/DecodeProducer$ProgressiveDecoder\n+ 2 FrescoSystrace.kt\ncom/facebook/imagepipeline/systrace/FrescoSystrace\n*L\n1#1,550:1\n40#2,9:551\n*S KotlinDebug\n*F\n+ 1 DecodeProducer.kt\ncom/facebook/imagepipeline/producers/DecodeProducer$ProgressiveDecoder\n*L\n115#1:551,9\n*E\n"})
    private abstract class ProgressiveDecoder
    extends DelegatingConsumer<EncodedImage, CloseableReference<CloseableImage>> {
        @NotNull
        private final ProducerContext producerContext;
        @NotNull
        private final String TAG;
        @NotNull
        private final ProducerListener2 producerListener;
        @NotNull
        private final ImageDecodeOptions imageDecodeOptions;
        @GuardedBy(value="this")
        private boolean isFinished;
        @NotNull
        private final JobScheduler jobScheduler;
        private int lastScheduledScanNumber;

        public ProgressiveDecoder(@NotNull Consumer<CloseableReference<CloseableImage>> consumer, ProducerContext producerContext, final boolean decodeCancellationEnabled, int maxBitmapDimension) {
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            Intrinsics.checkNotNullParameter((Object)producerContext, (String)"producerContext");
            super(consumer);
            this.producerContext = producerContext;
            this.TAG = "ProgressiveDecoder";
            this.producerListener = this.producerContext.getProducerListener();
            ImageDecodeOptions imageDecodeOptions = this.producerContext.getImageRequest().getImageDecodeOptions();
            Intrinsics.checkNotNullExpressionValue((Object)imageDecodeOptions, (String)"getImageDecodeOptions(...)");
            this.imageDecodeOptions = imageDecodeOptions;
            JobScheduler.JobRunnable job = (arg_0, arg_1) -> ProgressiveDecoder._init_$lambda$2(this, DecodeProducer.this, maxBitmapDimension, arg_0, arg_1);
            this.jobScheduler = new JobScheduler(DecodeProducer.this.getExecutor(), job, this.imageDecodeOptions.minDecodeIntervalMs);
            this.producerContext.addCallbacks(new BaseProducerContextCallbacks(){

                @Override
                public void onIsIntermediateResultExpectedChanged() {
                    if (producerContext.isIntermediateResultExpected()) {
                        jobScheduler.scheduleJob();
                    }
                }

                @Override
                public void onCancellationRequested() {
                    if (decodeCancellationEnabled) {
                        this.handleCancellation();
                    }
                }
            });
        }

        protected final int getLastScheduledScanNumber() {
            return this.lastScheduledScanNumber;
        }

        protected final void setLastScheduledScanNumber(int n) {
            this.lastScheduledScanNumber = n;
        }

        private final void maybeIncreaseSampleSize(EncodedImage encodedImage) {
            if (encodedImage.getImageFormat() != DefaultImageFormats.JPEG) {
                return;
            }
            int pixelSize = BitmapUtil.getPixelSizeForBitmapConfig((Bitmap.Config)this.imageDecodeOptions.bitmapConfig);
            int sampleSize = DownsampleUtil.determineSampleSizeJPEG((EncodedImage)encodedImage, (int)pixelSize, (int)0x6400000);
            encodedImage.setSampleSize(sampleSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNewResultImpl(@Nullable EncodedImage newResult, int status) {
            FrescoSystrace frescoSystrace = FrescoSystrace.INSTANCE;
            String name$iv = "DecodeProducer#onNewResultImpl";
            boolean $i$f$traceSection = false;
            if (!FrescoSystrace.isTracing()) {
                boolean bl = false;
                boolean isLast = BaseConsumer.isLast(status);
                if (isLast) {
                    if (newResult == null) {
                        boolean cacheHit = Intrinsics.areEqual((Object)this.producerContext.getExtra("cached_value_found"), (Object)true);
                        if (!this.producerContext.getImagePipelineConfig().getExperiments().getCancelDecodeOnCacheMiss() || this.producerContext.getLowestPermittedRequestLevel() == ImageRequest.RequestLevel.FULL_FETCH || cacheHit) {
                            this.handleError((Throwable)new ExceptionWithNoStacktrace("Encoded image is null."));
                            return;
                        }
                    } else if (!newResult.isValid()) {
                        this.handleError((Throwable)new ExceptionWithNoStacktrace("Encoded image is not valid."));
                        return;
                    }
                }
                if (!this.updateDecodeJob(newResult, status)) {
                    return;
                }
                boolean isPlaceholder = BaseConsumer.statusHasFlag(status, 4);
                if (isLast || isPlaceholder || this.producerContext.isIntermediateResultExpected()) {
                    this.jobScheduler.scheduleJob();
                }
            } else {
                FrescoSystrace.beginSection((String)name$iv);
                try {
                    boolean bl = false;
                    boolean isLast = BaseConsumer.isLast(status);
                    if (isLast) {
                        if (newResult == null) {
                            boolean cacheHit = Intrinsics.areEqual((Object)this.producerContext.getExtra("cached_value_found"), (Object)true);
                            if (!this.producerContext.getImagePipelineConfig().getExperiments().getCancelDecodeOnCacheMiss() || this.producerContext.getLowestPermittedRequestLevel() == ImageRequest.RequestLevel.FULL_FETCH || cacheHit) {
                                this.handleError((Throwable)new ExceptionWithNoStacktrace("Encoded image is null."));
                                return;
                            }
                        } else if (!newResult.isValid()) {
                            this.handleError((Throwable)new ExceptionWithNoStacktrace("Encoded image is not valid."));
                            return;
                        }
                    }
                    if (!this.updateDecodeJob(newResult, status)) {
                        return;
                    }
                    boolean isPlaceholder = BaseConsumer.statusHasFlag(status, 4);
                    if (isLast || isPlaceholder || this.producerContext.isIntermediateResultExpected()) {
                        this.jobScheduler.scheduleJob();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    FrescoSystrace.endSection();
                }
            }
        }

        @Override
        protected void onProgressUpdateImpl(float progress) {
            super.onProgressUpdateImpl(progress * 0.99f);
        }

        @Override
        public void onFailureImpl(@NotNull Throwable t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            this.handleError(t);
        }

        @Override
        public void onCancellationImpl() {
            this.handleCancellation();
        }

        protected boolean updateDecodeJob(@Nullable EncodedImage ref, int status) {
            return this.jobScheduler.updateJob(ref, status);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void doDecode(EncodedImage encodedImage, int status, int lastScheduledScanNumber) {
            int newStatus = status;
            if (encodedImage.getImageFormat() != DefaultImageFormats.JPEG && BaseConsumer.isNotLast(status)) {
                return;
            }
            if (this.isFinished || !EncodedImage.isValid((EncodedImage)encodedImage)) {
                return;
            }
            if (Intrinsics.areEqual((Object)encodedImage.getImageFormat(), (Object)DefaultImageFormats.GIF) && Companion.isTooBig(encodedImage, this.imageDecodeOptions)) {
                IllegalStateException e = new IllegalStateException("Image is too big to attempt decoding: w = " + encodedImage.getWidth() + ", h = " + encodedImage.getHeight() + ", pixel config = " + this.imageDecodeOptions.bitmapConfig + ", max bitmap size = 104857600");
                this.producerListener.onProducerFinishWithFailure(this.producerContext, DecodeProducer.PRODUCER_NAME, e, null);
                this.handleError(e);
                return;
            }
            ImageFormat imageFormat = encodedImage.getImageFormat();
            Intrinsics.checkNotNullExpressionValue((Object)imageFormat, (String)"getImageFormat(...)");
            ImageFormat imageFormat2 = imageFormat;
            String string = imageFormat2.getName();
            if (string == null) {
                string = "unknown";
            }
            String imageFormatStr = string;
            String encodedImageSize = encodedImage.getWidth() + "x" + encodedImage.getHeight();
            String sampleSize = String.valueOf(encodedImage.getSampleSize());
            boolean isLast = BaseConsumer.isLast(status);
            boolean isLastAndComplete = isLast && !BaseConsumer.statusHasFlag(status, 8);
            boolean isPlaceholder = BaseConsumer.statusHasFlag(status, 4);
            ResizeOptions resizeOptions = this.producerContext.getImageRequest().getResizeOptions();
            String requestedSizeStr = resizeOptions != null ? resizeOptions.width + "x" + resizeOptions.height : "unknown";
            try {
                long queueTime = this.jobScheduler.getQueuedTime();
                String string2 = this.producerContext.getImageRequest().getSourceUri().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                String requestUri = string2;
                int length = isLastAndComplete || isPlaceholder ? encodedImage.getSize() : this.getIntermediateImageEndOffset(encodedImage);
                QualityInfo quality = isLastAndComplete || isPlaceholder ? ImmutableQualityInfo.FULL_QUALITY : this.getQualityInfo();
                this.producerListener.onProducerStart(this.producerContext, DecodeProducer.PRODUCER_NAME);
                CloseableImage image = null;
                try {
                    CloseableImage closeableImage;
                    try {
                        Intrinsics.checkNotNull((Object)quality);
                        closeableImage = this.internalDecode(encodedImage, length, quality);
                    }
                    catch (DecodeException e) {
                        EncodedImage failedEncodedImage = e.getEncodedImage();
                        Object[] objectArray = new Object[]{e.getMessage(), requestUri, failedEncodedImage.getFirstBytesAsHexString(10), failedEncodedImage.getSize()};
                        FLog.w((String)this.TAG, (String)"%s, {uri: %s, firstEncodedBytes: %s, length: %d}", (Object[])objectArray);
                        throw e;
                    }
                    image = closeableImage;
                    if (encodedImage.getSampleSize() != 1) {
                        newStatus = status | 0x10;
                    }
                }
                catch (Exception e) {
                    Intrinsics.checkNotNull((Object)quality);
                    Map<String, String> extraMap = this.getExtraMap(image, queueTime, quality, isLast, imageFormatStr, encodedImageSize, requestedSizeStr, sampleSize);
                    this.producerListener.onProducerFinishWithFailure(this.producerContext, DecodeProducer.PRODUCER_NAME, e, extraMap);
                    this.handleError(e);
                    EncodedImage.closeSafely((EncodedImage)encodedImage);
                    return;
                }
                Map<String, String> extraMap = this.getExtraMap(image, queueTime, quality, isLast, imageFormatStr, encodedImageSize, requestedSizeStr, sampleSize);
                this.producerListener.onProducerFinishWithSuccess(this.producerContext, DecodeProducer.PRODUCER_NAME, extraMap);
                this.setImageExtras(encodedImage, image, lastScheduledScanNumber);
                this.handleResult(image, newStatus);
            }
            finally {
                EncodedImage.closeSafely((EncodedImage)encodedImage);
            }
        }

        private final CloseableImage internalDecode(EncodedImage encodedImage, int length, QualityInfo quality) {
            CloseableImage closeableImage;
            boolean recover = DecodeProducer.this.getReclaimMemoryRunnable() != null && (Boolean)DecodeProducer.this.getRecoverFromDecoderOOM().get() != false;
            try {
                closeableImage = DecodeProducer.this.getImageDecoder().decode(encodedImage, length, quality, this.imageDecodeOptions);
            }
            catch (OutOfMemoryError e) {
                if (!recover) {
                    throw e;
                }
                Runnable runnable = DecodeProducer.this.getReclaimMemoryRunnable();
                if (runnable != null) {
                    runnable.run();
                }
                System.gc();
                closeableImage = DecodeProducer.this.getImageDecoder().decode(encodedImage, length, quality, this.imageDecodeOptions);
            }
            CloseableImage image = closeableImage;
            return image;
        }

        private final void setImageExtras(EncodedImage encodedImage, CloseableImage image, int lastScheduledScanNumber) {
            this.producerContext.putExtra("encoded_width", encodedImage.getWidth());
            this.producerContext.putExtra("encoded_height", encodedImage.getHeight());
            this.producerContext.putExtra("encoded_size", encodedImage.getSize());
            this.producerContext.putExtra("image_color_space", encodedImage.getColorSpace());
            if (image instanceof CloseableBitmap) {
                Bitmap.Config config = ((CloseableBitmap)image).getUnderlyingBitmap().getConfig();
                this.producerContext.putExtra("bitmap_config", String.valueOf(config));
            }
            CloseableImage closeableImage = image;
            if (closeableImage != null) {
                closeableImage.putExtras(this.producerContext.getExtras());
            }
            this.producerContext.putExtra("last_scan_num", lastScheduledScanNumber);
        }

        private final Map<String, String> getExtraMap(CloseableImage image, long queueTime, QualityInfo quality, boolean isFinal, String imageFormatName, String encodedImageSize, String requestImageSize, String sampleSize) {
            Map map;
            String nonFatalErrorStr;
            if (!this.producerListener.requiresExtraMap(this.producerContext, DecodeProducer.PRODUCER_NAME)) {
                return null;
            }
            String queueStr = String.valueOf(queueTime);
            String qualityStr = String.valueOf(quality.isOfGoodEnoughQuality());
            String finalStr = String.valueOf(isFinal);
            Object object = image;
            String string = object != null && (object = object.getExtras()) != null && (object = object.get(DecodeProducer.NON_FATAL_DECODE_ERROR)) != null ? object.toString() : (nonFatalErrorStr = null);
            if (image instanceof CloseableStaticBitmap) {
                Bitmap bitmap = ((CloseableStaticBitmap)image).getUnderlyingBitmap();
                Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"getUnderlyingBitmap(...)");
                Bitmap bitmap2 = bitmap;
                String sizeStr = bitmap2.getWidth() + "x" + bitmap2.getHeight();
                Map tmpMap = new HashMap(8);
                tmpMap.put(DecodeProducer.EXTRA_BITMAP_SIZE, sizeStr);
                tmpMap.put("queueTime", queueStr);
                tmpMap.put(DecodeProducer.EXTRA_HAS_GOOD_QUALITY, qualityStr);
                tmpMap.put(DecodeProducer.EXTRA_IS_FINAL, finalStr);
                tmpMap.put(DecodeProducer.ENCODED_IMAGE_SIZE, encodedImageSize);
                tmpMap.put(DecodeProducer.EXTRA_IMAGE_FORMAT_NAME, imageFormatName);
                tmpMap.put(DecodeProducer.REQUESTED_IMAGE_SIZE, requestImageSize);
                tmpMap.put(DecodeProducer.SAMPLE_SIZE, sampleSize);
                tmpMap.put(DecodeProducer.EXTRA_BITMAP_BYTES, "" + bitmap2.getByteCount());
                if (nonFatalErrorStr != null) {
                    tmpMap.put(DecodeProducer.NON_FATAL_DECODE_ERROR, nonFatalErrorStr);
                }
                map = (Map)ImmutableMap.copyOf((Map)tmpMap);
            } else {
                Map tmpMap = new HashMap(7);
                tmpMap.put("queueTime", queueStr);
                tmpMap.put(DecodeProducer.EXTRA_HAS_GOOD_QUALITY, qualityStr);
                tmpMap.put(DecodeProducer.EXTRA_IS_FINAL, finalStr);
                tmpMap.put(DecodeProducer.ENCODED_IMAGE_SIZE, encodedImageSize);
                tmpMap.put(DecodeProducer.EXTRA_IMAGE_FORMAT_NAME, imageFormatName);
                tmpMap.put(DecodeProducer.REQUESTED_IMAGE_SIZE, requestImageSize);
                tmpMap.put(DecodeProducer.SAMPLE_SIZE, sampleSize);
                if (nonFatalErrorStr != null) {
                    tmpMap.put(DecodeProducer.NON_FATAL_DECODE_ERROR, nonFatalErrorStr);
                }
                map = (Map)ImmutableMap.copyOf((Map)tmpMap);
            }
            return map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void maybeFinish(boolean shouldFinish) {
            ProgressiveDecoder progressiveDecoder = this;
            synchronized (progressiveDecoder) {
                block6: {
                    block5: {
                        boolean bl = false;
                        if (!shouldFinish) break block5;
                        if (!this.isFinished) break block6;
                    }
                    return;
                }
                this.getConsumer().onProgressUpdate(1.0f);
                this.isFinished = true;
                Unit unit = Unit.INSTANCE;
            }
            this.jobScheduler.clearJob();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handleResult(CloseableImage decodedImage, int status) {
            CloseableReference<Closeable> decodedImageRef = DecodeProducer.this.getCloseableReferenceFactory().create((Closeable)decodedImage);
            try {
                this.maybeFinish(BaseConsumer.isLast(status));
                this.getConsumer().onNewResult(decodedImageRef, status);
            }
            finally {
                CloseableReference.closeSafely(decodedImageRef);
            }
        }

        private final void handleError(Throwable t) {
            this.maybeFinish(true);
            this.getConsumer().onFailure(t);
        }

        private final void handleCancellation() {
            this.maybeFinish(true);
            this.getConsumer().onCancellation();
        }

        protected abstract int getIntermediateImageEndOffset(@NotNull EncodedImage var1);

        @NotNull
        protected abstract QualityInfo getQualityInfo();

        private static final void _init_$lambda$2(ProgressiveDecoder this$0, DecodeProducer this$1, int $maxBitmapDimension, EncodedImage encodedImage, int status) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            if (encodedImage != null) {
                boolean shouldAdjustSampleSize;
                ImageRequest request = this$0.producerContext.getImageRequest();
                this$0.producerContext.putExtra("image_format", encodedImage.getImageFormat().getName());
                Uri uri = request.getSourceUri();
                encodedImage.setSource(uri != null ? uri.toString() : null);
                DownsampleMode downsampleMode = request.getDownsampleOverride();
                if (downsampleMode == null) {
                    downsampleMode = this$1.getDownsampleMode();
                }
                DownsampleMode requestDownsampleMode = downsampleMode;
                boolean isResizingDone = BaseConsumer.statusHasFlag(status, 16);
                boolean bl = shouldAdjustSampleSize = (requestDownsampleMode == DownsampleMode.ALWAYS || requestDownsampleMode == DownsampleMode.AUTO && !isResizingDone) && (this$1.getDownsampleEnabledForNetwork() || !UriUtil.isNetworkUri((Uri)request.getSourceUri()));
                if (shouldAdjustSampleSize) {
                    RotationOptions rotationOptions = request.getRotationOptions();
                    Intrinsics.checkNotNullExpressionValue((Object)rotationOptions, (String)"getRotationOptions(...)");
                    encodedImage.setSampleSize(DownsampleUtil.determineSampleSize((RotationOptions)rotationOptions, (ResizeOptions)request.getResizeOptions(), (EncodedImage)encodedImage, (int)$maxBitmapDimension));
                }
                if (this$0.producerContext.getImagePipelineConfig().getExperiments().getDownsampleIfLargeBitmap()) {
                    this$0.maybeIncreaseSampleSize(encodedImage);
                }
                this$0.doDecode(encodedImage, status, this$0.lastScheduledScanNumber);
            }
        }
    }
}

