/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.multiuri;

import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class MultiUri {
    @Nullable
    private ImageRequest mLowResImageRequest;
    @Nullable
    private ImageRequest[] mMultiImageRequests;
    @Nullable
    private ImageRequest mHighResImageRequest;

    private MultiUri(Builder builder) {
        this.mLowResImageRequest = builder.mLowResImageRequest;
        this.mHighResImageRequest = builder.mHighResImageRequest;
        this.mMultiImageRequests = builder.mMultiImageRequests;
    }

    @Nullable
    public ImageRequest getLowResImageRequest() {
        return this.mLowResImageRequest;
    }

    @Nullable
    public ImageRequest getHighResImageRequest() {
        return this.mHighResImageRequest;
    }

    @Nullable
    public ImageRequest[] getMultiImageRequests() {
        return this.mMultiImageRequests;
    }

    public static Builder create() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private ImageRequest mLowResImageRequest;
        @Nullable
        private ImageRequest mHighResImageRequest;
        @Nullable
        private ImageRequest[] mMultiImageRequests;

        private Builder() {
        }

        public MultiUri build() {
            return new MultiUri(this);
        }

        public Builder setLowResImageRequest(@Nullable ImageRequest lowResImageRequest) {
            this.mLowResImageRequest = lowResImageRequest;
            return this;
        }

        public Builder setHighResImageRequest(@Nullable ImageRequest highResImageRequest) {
            this.mHighResImageRequest = highResImageRequest;
            return this;
        }

        public Builder setImageRequests(ImageRequest ... multiImageRequests) {
            this.mMultiImageRequests = multiImageRequests;
            return this;
        }
    }
}

