/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.executors.StatefulRunnable;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener2;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B+\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0017\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00018\u0000H$\u00a2\u0006\u0002\u0010\u0013J \u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J)\u0010\u0017\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\r2\b\u0010\u0012\u001a\u0004\u0018\u00018\u0000H\u0014\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u0011H\u0014J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0016H\u0014J\u0017\u0010\u001c\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00018\u0000H\u0014\u00a2\u0006\u0002\u0010\u0013R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/facebook/imagepipeline/producers/StatefulProducerRunnable;", "T", "Lcom/facebook/common/executors/StatefulRunnable;", "consumer", "Lcom/facebook/imagepipeline/producers/Consumer;", "producerListener", "Lcom/facebook/imagepipeline/producers/ProducerListener2;", "producerContext", "Lcom/facebook/imagepipeline/producers/ProducerContext;", "producerName", "", "(Lcom/facebook/imagepipeline/producers/Consumer;Lcom/facebook/imagepipeline/producers/ProducerListener2;Lcom/facebook/imagepipeline/producers/ProducerContext;Ljava/lang/String;)V", "extraMapOnCancellation", "", "getExtraMapOnCancellation", "()Ljava/util/Map;", "disposeResult", "", "result", "(Ljava/lang/Object;)V", "getExtraMapOnFailure", "exception", "Ljava/lang/Exception;", "getExtraMapOnSuccess", "(Ljava/lang/Object;)Ljava/util/Map;", "onCancellation", "onFailure", "e", "onSuccess", "imagepipeline_release"})
public abstract class StatefulProducerRunnable<T>
extends StatefulRunnable<T> {
    @NotNull
    private final Consumer<T> consumer;
    @NotNull
    private final ProducerListener2 producerListener;
    @NotNull
    private final ProducerContext producerContext;
    @NotNull
    private final String producerName;

    public StatefulProducerRunnable(@NotNull Consumer<T> consumer, @NotNull ProducerListener2 producerListener, @NotNull ProducerContext producerContext, @NotNull String producerName) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)producerListener, (String)"producerListener");
        Intrinsics.checkNotNullParameter((Object)producerContext, (String)"producerContext");
        Intrinsics.checkNotNullParameter((Object)producerName, (String)"producerName");
        this.consumer = consumer;
        this.producerListener = producerListener;
        this.producerContext = producerContext;
        this.producerName = producerName;
        this.producerListener.onProducerStart(this.producerContext, this.producerName);
    }

    protected void onSuccess(@Nullable T result) {
        this.producerListener.onProducerFinishWithSuccess(this.producerContext, this.producerName, this.producerListener.requiresExtraMap(this.producerContext, this.producerName) ? this.getExtraMapOnSuccess(result) : null);
        this.consumer.onNewResult(result, 1);
    }

    protected void onFailure(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.producerListener.onProducerFinishWithFailure(this.producerContext, this.producerName, e, this.producerListener.requiresExtraMap(this.producerContext, this.producerName) ? this.getExtraMapOnFailure(e) : null);
        this.consumer.onFailure(e);
    }

    protected void onCancellation() {
        this.producerListener.onProducerFinishWithCancellation(this.producerContext, this.producerName, this.producerListener.requiresExtraMap(this.producerContext, this.producerName) ? this.getExtraMapOnCancellation() : null);
        this.consumer.onCancellation();
    }

    @Nullable
    protected Map<String, String> getExtraMapOnSuccess(@Nullable T result) {
        return null;
    }

    @Nullable
    protected Map<String, String> getExtraMapOnFailure(@Nullable Exception exception) {
        return null;
    }

    @Nullable
    protected Map<String, String> getExtraMapOnCancellation() {
        return null;
    }

    protected abstract void disposeResult(@Nullable T var1);
}

