/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.datasource;

import android.graphics.Bitmap;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.BaseDataSubscriber;
import com.facebook.datasource.DataSource;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public abstract class BaseBitmapReferenceDataSubscriber
extends BaseDataSubscriber<CloseableReference<CloseableImage>> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNewResultImpl(DataSource<CloseableReference<CloseableImage>> dataSource) {
        if (!dataSource.isFinished()) {
            return;
        }
        CloseableReference closeableImageRef = (CloseableReference)dataSource.getResult();
        CloseableReference bitmapReference = null;
        if (closeableImageRef != null && closeableImageRef.get() instanceof CloseableStaticBitmap) {
            bitmapReference = ((CloseableStaticBitmap)closeableImageRef.get()).cloneUnderlyingBitmapReference();
        }
        try {
            this.onNewResultImpl(bitmapReference);
        }
        finally {
            CloseableReference.closeSafely(bitmapReference);
            CloseableReference.closeSafely((CloseableReference)closeableImageRef);
        }
    }

    protected abstract void onNewResultImpl(@Nullable CloseableReference<Bitmap> var1);
}

