/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.filter;

import android.graphics.Bitmap;
import com.facebook.common.internal.Preconditions;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/facebook/imagepipeline/filter/InPlaceRoundFilter;", "", "()V", "roundBitmapInPlace", "", "bitmap", "Landroid/graphics/Bitmap;", "imagepipeline_release"})
public final class InPlaceRoundFilter {
    @NotNull
    public static final InPlaceRoundFilter INSTANCE = new InPlaceRoundFilter();

    private InPlaceRoundFilter() {
    }

    @JvmStatic
    public static final void roundBitmapInPlace(@NotNull Bitmap bitmap) {
        int i;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        int radius = Math.min(w, h) / 2;
        int centerX = w / 2;
        int centerY = h / 2;
        if (radius == 0) {
            return;
        }
        Preconditions.checkArgument((Boolean)(radius >= 1 ? 1 : 0));
        Preconditions.checkArgument((Boolean)(w > 0 && (float)w <= 2048.0f ? 1 : 0));
        Preconditions.checkArgument((Boolean)(h > 0 && (float)h <= 2048.0f ? 1 : 0));
        Preconditions.checkArgument((Boolean)(centerX > 0 && centerX < w ? 1 : 0));
        Preconditions.checkArgument((Boolean)(centerY > 0 && centerY < h ? 1 : 0));
        int[] pixels = new int[w * h];
        bitmap.getPixels(pixels, 0, w, 0, 0, w, h);
        int x = radius - 1;
        int y = 0;
        int maxX = centerX + x;
        int maxY = centerY + x;
        int minX = centerX - x;
        int minY = centerY - x;
        Preconditions.checkArgument((Boolean)(minX >= 0 && minY >= 0 && maxX < w && maxY < h ? 1 : 0));
        int dx = 1;
        int dy = 1;
        int rInc = -radius * 2;
        int[] transparentColor = new int[w];
        int err = dx + rInc;
        int cXpX = 0;
        int cXmX = 0;
        int cXpY = 0;
        int cXmY = 0;
        int cYpX = 0;
        int cYmX = 0;
        int cYpY = 0;
        int cYmY = 0;
        int offA = 0;
        int offB = 0;
        int offC = 0;
        int offD = 0;
        while (x >= y) {
            cXpX = centerX + x;
            cXmX = centerX - x;
            cXpY = centerX + y;
            cXmY = centerX - y;
            cYpX = centerY + x;
            cYmX = centerY - x;
            cYpY = centerY + y;
            cYmY = centerY - y;
            Preconditions.checkArgument((Boolean)(x >= 0 && cXpY < w && cXmY >= 0 && cYpY < h && cYmY >= 0 ? 1 : 0));
            offA = w * cYpY;
            offB = w * cYmY;
            offC = w * cYpX;
            offD = w * cYmX;
            System.arraycopy(transparentColor, 0, pixels, offA, cXmX);
            System.arraycopy(transparentColor, 0, pixels, offB, cXmX);
            System.arraycopy(transparentColor, 0, pixels, offC, cXmY);
            System.arraycopy(transparentColor, 0, pixels, offD, cXmY);
            System.arraycopy(transparentColor, 0, pixels, offA + cXpX, w - cXpX);
            System.arraycopy(transparentColor, 0, pixels, offB + cXpX, w - cXpX);
            System.arraycopy(transparentColor, 0, pixels, offC + cXpY, w - cXpY);
            System.arraycopy(transparentColor, 0, pixels, offD + cXpY, w - cXpY);
            if (err <= 0) {
                ++y;
                err += (dy += 2);
            }
            if (err <= 0) continue;
            --x;
            err += (dx += 2) + rInc;
        }
        for (i = centerY - radius; -1 < i; --i) {
            System.arraycopy(transparentColor, 0, pixels, i * w, w);
        }
        for (i = centerY + radius; i < h; ++i) {
            System.arraycopy(transparentColor, 0, pixels, i * w, w);
        }
        bitmap.setPixels(pixels, 0, w, 0, 0, w, h);
    }
}

