/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import androidx.annotation.VisibleForTesting;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.memory.MemoryChunk;
import com.facebook.infer.annotation.Nullsafe;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class MemoryPooledByteBuffer
implements PooledByteBuffer {
    private final int mSize;
    @Nullable
    @GuardedBy(value="this")
    @VisibleForTesting
    CloseableReference<MemoryChunk> mBufRef;

    public MemoryPooledByteBuffer(CloseableReference<MemoryChunk> bufRef, int size) {
        Preconditions.checkNotNull(bufRef);
        Preconditions.checkArgument((Boolean)(size >= 0 && size <= ((MemoryChunk)bufRef.get()).getSize() ? 1 : 0));
        this.mBufRef = bufRef.clone();
        this.mSize = size;
    }

    public synchronized int size() {
        this.ensureValid();
        return this.mSize;
    }

    public synchronized byte read(int offset) {
        this.ensureValid();
        Preconditions.checkArgument((Boolean)(offset >= 0 ? 1 : 0));
        Preconditions.checkArgument((Boolean)(offset < this.mSize ? 1 : 0));
        Preconditions.checkNotNull(this.mBufRef);
        return ((MemoryChunk)this.mBufRef.get()).read(offset);
    }

    public synchronized int read(int offset, byte[] buffer, int bufferOffset, int length) {
        this.ensureValid();
        Preconditions.checkArgument((Boolean)(offset + length <= this.mSize ? 1 : 0));
        Preconditions.checkNotNull(this.mBufRef);
        return ((MemoryChunk)this.mBufRef.get()).read(offset, buffer, bufferOffset, length);
    }

    public synchronized long getNativePtr() throws UnsupportedOperationException {
        this.ensureValid();
        Preconditions.checkNotNull(this.mBufRef);
        return ((MemoryChunk)this.mBufRef.get()).getNativePtr();
    }

    @Nullable
    public synchronized ByteBuffer getByteBuffer() {
        Preconditions.checkNotNull(this.mBufRef);
        return ((MemoryChunk)this.mBufRef.get()).getByteBuffer();
    }

    public synchronized boolean isClosed() {
        return !CloseableReference.isValid(this.mBufRef);
    }

    public synchronized void close() {
        CloseableReference.closeSafely(this.mBufRef);
        this.mBufRef = null;
    }

    synchronized void ensureValid() {
        if (this.isClosed()) {
            throw new PooledByteBuffer.ClosedException();
        }
    }

    @Nullable
    @GuardedBy(value="this")
    @VisibleForTesting
    CloseableReference<MemoryChunk> getCloseableReference() {
        return this.mBufRef;
    }
}

