/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.util.Pair;
import androidx.annotation.VisibleForTesting;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.common.memory.PooledByteBufferFactory;
import com.facebook.common.memory.PooledByteBufferInputStream;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.UriUtil;
import com.facebook.imageformat.DefaultImageFormats;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener2;
import com.facebook.imagepipeline.producers.StatefulProducerRunnable;
import com.facebook.imagepipeline.producers.ThumbnailProducer;
import com.facebook.imagepipeline.producers.ThumbnailSizeChecker;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imageutils.BitmapUtil;
import com.facebook.imageutils.JfifUtil;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.soloader.DoNotOptimize;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class LocalExifThumbnailProducer
implements ThumbnailProducer<EncodedImage> {
    private static final int COMMON_EXIF_THUMBNAIL_MAX_DIMENSION = 512;
    public static final String PRODUCER_NAME = "LocalExifThumbnailProducer";
    @VisibleForTesting
    static final String CREATED_THUMBNAIL = "createdThumbnail";
    private final Executor mExecutor;
    private final PooledByteBufferFactory mPooledByteBufferFactory;
    private final ContentResolver mContentResolver;

    public LocalExifThumbnailProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory, ContentResolver contentResolver) {
        this.mExecutor = executor;
        this.mPooledByteBufferFactory = pooledByteBufferFactory;
        this.mContentResolver = contentResolver;
    }

    @Override
    public boolean canProvideImageForSize(@Nullable ResizeOptions resizeOptions) {
        return ThumbnailSizeChecker.isImageBigEnough(512, 512, resizeOptions);
    }

    @Override
    public void produceResults(Consumer<EncodedImage> consumer, ProducerContext producerContext) {
        ProducerListener2 listener = producerContext.getProducerListener();
        final ImageRequest imageRequest = producerContext.getImageRequest();
        producerContext.putOriginExtra("local", "exif");
        final StatefulProducerRunnable<EncodedImage> cancellableProducerRunnable = new StatefulProducerRunnable<EncodedImage>(consumer, listener, producerContext, PRODUCER_NAME){

            @Nullable
            protected EncodedImage getResult() throws Exception {
                Uri sourceUri = imageRequest.getSourceUri();
                ExifInterface exifInterface = LocalExifThumbnailProducer.this.getExifInterface(sourceUri);
                if (exifInterface == null || !exifInterface.hasThumbnail()) {
                    return null;
                }
                byte[] bytes = (byte[])Preconditions.checkNotNull((Object)exifInterface.getThumbnail());
                PooledByteBuffer pooledByteBuffer = LocalExifThumbnailProducer.this.mPooledByteBufferFactory.newByteBuffer(bytes);
                return LocalExifThumbnailProducer.this.buildEncodedImage(pooledByteBuffer, exifInterface);
            }

            @Override
            protected void disposeResult(@Nullable EncodedImage result) {
                EncodedImage.closeSafely((EncodedImage)result);
            }

            @Override
            protected Map<String, String> getExtraMapOnSuccess(@Nullable EncodedImage result) {
                return ImmutableMap.of((Object)LocalExifThumbnailProducer.CREATED_THUMBNAIL, (Object)Boolean.toString(result != null));
            }
        };
        producerContext.addCallbacks(new BaseProducerContextCallbacks(){

            @Override
            public void onCancellationRequested() {
                cancellableProducerRunnable.cancel();
            }
        });
        this.mExecutor.execute((Runnable)((Object)cancellableProducerRunnable));
    }

    @Nullable
    @VisibleForTesting
    ExifInterface getExifInterface(Uri uri) {
        String realPath = UriUtil.getRealPathFromUri((ContentResolver)this.mContentResolver, (Uri)uri);
        if (realPath == null) {
            return null;
        }
        try {
            if (this.canReadAsFile(realPath)) {
                return new ExifInterface(realPath);
            }
            AssetFileDescriptor assetFileDescriptor = UriUtil.getAssetFileDescriptor((ContentResolver)this.mContentResolver, (Uri)uri);
            if (assetFileDescriptor != null && Build.VERSION.SDK_INT >= 24) {
                ExifInterface exifInterface = new Api24Utils().getExifInterface(assetFileDescriptor.getFileDescriptor());
                assetFileDescriptor.close();
                return exifInterface;
            }
        }
        catch (IOException assetFileDescriptor) {
        }
        catch (StackOverflowError e) {
            FLog.e(LocalExifThumbnailProducer.class, (String)"StackOverflowError in ExifInterface constructor");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EncodedImage buildEncodedImage(PooledByteBuffer imageBytes, ExifInterface exifInterface) {
        EncodedImage encodedImage;
        Pair dimensions = BitmapUtil.decodeDimensions((InputStream)new PooledByteBufferInputStream(imageBytes));
        int rotationAngle = this.getRotationAngle(exifInterface);
        int width = dimensions != null ? (Integer)dimensions.first : -1;
        int height = dimensions != null ? (Integer)dimensions.second : -1;
        CloseableReference closeableByteBuffer = CloseableReference.of((Closeable)imageBytes);
        try {
            encodedImage = new EncodedImage(closeableByteBuffer);
        }
        finally {
            CloseableReference.closeSafely((CloseableReference)closeableByteBuffer);
        }
        encodedImage.setImageFormat(DefaultImageFormats.JPEG);
        encodedImage.setRotationAngle(rotationAngle);
        encodedImage.setWidth(width);
        encodedImage.setHeight(height);
        return encodedImage;
    }

    private int getRotationAngle(ExifInterface exifInterface) {
        String s = (String)Preconditions.checkNotNull((Object)exifInterface.getAttribute("Orientation"));
        return JfifUtil.getAutoRotateAngleFromOrientation((int)Integer.parseInt(s));
    }

    @VisibleForTesting
    boolean canReadAsFile(String realPath) throws IOException {
        if (realPath == null) {
            return false;
        }
        File file = new File(realPath);
        return file.exists() && file.canRead();
    }

    @DoNotOptimize
    private class Api24Utils {
        private Api24Utils() {
        }

        @Nullable
        ExifInterface getExifInterface(FileDescriptor fileDescriptor) throws IOException {
            return Build.VERSION.SDK_INT >= 24 ? new ExifInterface(fileDescriptor) : null;
        }
    }
}

