/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.content.ContentResolver;
import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import android.provider.ContactsContract;
import com.facebook.common.memory.PooledByteBufferFactory;
import com.facebook.common.util.UriUtil;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.LocalFetchProducer;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/facebook/imagepipeline/producers/LocalContentUriFetchProducer;", "Lcom/facebook/imagepipeline/producers/LocalFetchProducer;", "executor", "Ljava/util/concurrent/Executor;", "pooledByteBufferFactory", "Lcom/facebook/common/memory/PooledByteBufferFactory;", "contentResolver", "Landroid/content/ContentResolver;", "(Ljava/util/concurrent/Executor;Lcom/facebook/common/memory/PooledByteBufferFactory;Landroid/content/ContentResolver;)V", "getCameraImage", "Lcom/facebook/imagepipeline/image/EncodedImage;", "uri", "Landroid/net/Uri;", "getEncodedImage", "imageRequest", "Lcom/facebook/imagepipeline/request/ImageRequest;", "getProducerName", "", "Companion", "imagepipeline_release"})
public final class LocalContentUriFetchProducer
extends LocalFetchProducer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ContentResolver contentResolver;
    @NotNull
    public static final String PRODUCER_NAME = "LocalContentUriFetchProducer";
    @NotNull
    private static final String[] PROJECTION;

    public LocalContentUriFetchProducer(@NotNull Executor executor, @NotNull PooledByteBufferFactory pooledByteBufferFactory, @NotNull ContentResolver contentResolver) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)pooledByteBufferFactory, (String)"pooledByteBufferFactory");
        Intrinsics.checkNotNullParameter((Object)contentResolver, (String)"contentResolver");
        super(executor, pooledByteBufferFactory);
        this.contentResolver = contentResolver;
    }

    @Override
    @Nullable
    protected EncodedImage getEncodedImage(@NotNull ImageRequest imageRequest) throws IOException {
        Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"imageRequest");
        Uri uri = imageRequest.getSourceUri();
        if (UriUtil.isLocalContactUri((Uri)uri)) {
            Object object;
            Object inputStream = null;
            String string = uri.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.toString()");
            if (StringsKt.endsWith$default((String)string, (String)"/photo", (boolean)false, (int)2, null)) {
                inputStream = this.contentResolver.openInputStream(uri);
            } else {
                String string2 = uri.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"uri.toString()");
                if (StringsKt.endsWith$default((String)string2, (String)"/display_photo", (boolean)false, (int)2, null)) {
                    try {
                        AssetFileDescriptor fd = this.contentResolver.openAssetFileDescriptor(uri, "r");
                        if (fd == null) {
                            String string3 = "Required value was null.";
                            throw new IllegalStateException(string3.toString());
                        }
                        object = fd.createInputStream();
                    }
                    catch (IOException e) {
                        throw new IOException("Contact photo does not exist: " + uri);
                    }
                    inputStream = object;
                } else {
                    inputStream = ContactsContract.Contacts.openContactPhotoInputStream((ContentResolver)this.contentResolver, (Uri)uri);
                    if (inputStream == null) {
                        throw new IOException("Contact photo does not exist: " + uri);
                    }
                }
            }
            if (inputStream == null) {
                object = "Required value was null.";
                throw new IllegalStateException(object.toString());
            }
            return this.getEncodedImage((InputStream)inputStream, -1);
        }
        if (UriUtil.isLocalCameraUri((Uri)uri)) {
            Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
            EncodedImage cameraImage = this.getCameraImage(uri);
            if (cameraImage != null) {
                return cameraImage;
            }
        }
        InputStream inputStream = this.contentResolver.openInputStream(uri);
        if (inputStream == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return this.getEncodedImage(inputStream, -1);
    }

    private final EncodedImage getCameraImage(Uri uri) throws IOException {
        Object object;
        try {
            object = this.contentResolver.openFileDescriptor(uri, "r");
        }
        catch (FileNotFoundException e) {
            return null;
        }
        Object parcelFileDescriptor = object;
        if (parcelFileDescriptor == null) {
            object = "Required value was null.";
            throw new IllegalStateException(object.toString());
        }
        FileDescriptor fd = parcelFileDescriptor.getFileDescriptor();
        EncodedImage encodedImage = this.getEncodedImage(new FileInputStream(fd), (int)parcelFileDescriptor.getStatSize());
        Intrinsics.checkNotNullExpressionValue((Object)encodedImage, (String)"this.getEncodedImage(Fil\u2026criptor.statSize.toInt())");
        EncodedImage encodedImage2 = encodedImage;
        parcelFileDescriptor.close();
        return encodedImage2;
    }

    @Override
    @NotNull
    protected String getProducerName() {
        return PRODUCER_NAME;
    }

    static {
        String[] stringArray = new String[]{"_id", "_data"};
        PROJECTION = stringArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/facebook/imagepipeline/producers/LocalContentUriFetchProducer$Companion;", "", "()V", "PRODUCER_NAME", "", "PROJECTION", "", "[Ljava/lang/String;", "imagepipeline_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

