/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.net.Uri;
import androidx.annotation.VisibleForTesting;
import bolts.Continuation;
import bolts.Task;
import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;
import com.facebook.common.memory.ByteArrayPool;
import com.facebook.common.memory.PooledByteBufferFactory;
import com.facebook.common.memory.PooledByteBufferOutputStream;
import com.facebook.common.references.CloseableReference;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.cache.BufferedDiskCache;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.common.BytesRange;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener2;
import com.facebook.imagepipeline.producers.SettableProducerContext;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.facebook.infer.annotation.Nullsafe;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class PartialDiskCacheProducer
implements Producer<EncodedImage> {
    public static final String PRODUCER_NAME = "PartialDiskCacheProducer";
    public static final String EXTRA_CACHED_VALUE_FOUND = "cached_value_found";
    public static final String ENCODED_IMAGE_SIZE = "encodedImageSize";
    private final BufferedDiskCache mDefaultBufferedDiskCache;
    private final CacheKeyFactory mCacheKeyFactory;
    private final PooledByteBufferFactory mPooledByteBufferFactory;
    private final ByteArrayPool mByteArrayPool;
    private final Producer<EncodedImage> mInputProducer;

    public PartialDiskCacheProducer(BufferedDiskCache defaultBufferedDiskCache, CacheKeyFactory cacheKeyFactory, PooledByteBufferFactory pooledByteBufferFactory, ByteArrayPool byteArrayPool, Producer<EncodedImage> inputProducer) {
        this.mDefaultBufferedDiskCache = defaultBufferedDiskCache;
        this.mCacheKeyFactory = cacheKeyFactory;
        this.mPooledByteBufferFactory = pooledByteBufferFactory;
        this.mByteArrayPool = byteArrayPool;
        this.mInputProducer = inputProducer;
    }

    @Override
    public void produceResults(Consumer<EncodedImage> consumer, ProducerContext producerContext) {
        ImageRequest imageRequest = producerContext.getImageRequest();
        boolean isDiskCacheEnabledForRead = producerContext.getImageRequest().isCacheEnabled(16);
        ProducerListener2 listener = producerContext.getProducerListener();
        listener.onProducerStart(producerContext, PRODUCER_NAME);
        Uri uriForPartialCacheKey = PartialDiskCacheProducer.createUriForPartialCacheKey(imageRequest);
        CacheKey partialImageCacheKey = this.mCacheKeyFactory.getEncodedCacheKey(imageRequest, uriForPartialCacheKey, producerContext.getCallerContext());
        if (!isDiskCacheEnabledForRead) {
            listener.onProducerFinishWithSuccess(producerContext, PRODUCER_NAME, PartialDiskCacheProducer.getExtraMap(listener, producerContext, false, 0));
            this.startInputProducer(consumer, producerContext, partialImageCacheKey, null);
            return;
        }
        AtomicBoolean isCancelled = new AtomicBoolean(false);
        Task<EncodedImage> diskLookupTask = this.mDefaultBufferedDiskCache.get(partialImageCacheKey, isCancelled);
        Continuation<EncodedImage, Void> continuation = this.onFinishDiskReads(consumer, producerContext, partialImageCacheKey);
        diskLookupTask.continueWith(continuation);
        this.subscribeTaskForRequestCancellation(isCancelled, producerContext);
    }

    private Continuation<EncodedImage, Void> onFinishDiskReads(final Consumer<EncodedImage> consumer, final ProducerContext producerContext, final CacheKey partialImageCacheKey) {
        final ProducerListener2 listener = producerContext.getProducerListener();
        return new Continuation<EncodedImage, Void>(){

            public Void then(Task<EncodedImage> task) throws Exception {
                if (PartialDiskCacheProducer.isTaskCancelled(task)) {
                    listener.onProducerFinishWithCancellation(producerContext, PartialDiskCacheProducer.PRODUCER_NAME, null);
                    consumer.onCancellation();
                } else if (task.isFaulted()) {
                    listener.onProducerFinishWithFailure(producerContext, PartialDiskCacheProducer.PRODUCER_NAME, task.getError(), null);
                    PartialDiskCacheProducer.this.startInputProducer(consumer, producerContext, partialImageCacheKey, null);
                } else {
                    EncodedImage cachedReference = (EncodedImage)task.getResult();
                    if (cachedReference != null) {
                        listener.onProducerFinishWithSuccess(producerContext, PartialDiskCacheProducer.PRODUCER_NAME, PartialDiskCacheProducer.getExtraMap(listener, producerContext, true, cachedReference.getSize()));
                        BytesRange cachedRange = BytesRange.toMax((int)(cachedReference.getSize() - 1));
                        cachedReference.setBytesRange(cachedRange);
                        int cachedLength = cachedReference.getSize();
                        ImageRequest originalRequest = producerContext.getImageRequest();
                        if (cachedRange.contains(originalRequest.getBytesRange())) {
                            producerContext.putOriginExtra("disk", "partial");
                            listener.onUltimateProducerReached(producerContext, PartialDiskCacheProducer.PRODUCER_NAME, true);
                            consumer.onNewResult(cachedReference, 9);
                        } else {
                            consumer.onNewResult(cachedReference, 8);
                            ImageRequest remainingRequest = ImageRequestBuilder.fromRequest(originalRequest).setBytesRange(BytesRange.from((int)(cachedLength - 1))).build();
                            SettableProducerContext contextForRemainingRequest = new SettableProducerContext(remainingRequest, producerContext);
                            PartialDiskCacheProducer.this.startInputProducer(consumer, contextForRemainingRequest, partialImageCacheKey, cachedReference);
                        }
                    } else {
                        listener.onProducerFinishWithSuccess(producerContext, PartialDiskCacheProducer.PRODUCER_NAME, PartialDiskCacheProducer.getExtraMap(listener, producerContext, false, 0));
                        PartialDiskCacheProducer.this.startInputProducer(consumer, producerContext, partialImageCacheKey, cachedReference);
                    }
                }
                return null;
            }
        };
    }

    private void startInputProducer(Consumer<EncodedImage> consumerOfPartialDiskCacheProducer, ProducerContext producerContext, CacheKey partialImageCacheKey, @Nullable EncodedImage partialResultFromCache) {
        PartialDiskCacheConsumer consumer = new PartialDiskCacheConsumer(consumerOfPartialDiskCacheProducer, this.mDefaultBufferedDiskCache, partialImageCacheKey, this.mPooledByteBufferFactory, this.mByteArrayPool, partialResultFromCache, producerContext.getImageRequest().isCacheEnabled(32));
        this.mInputProducer.produceResults(consumer, producerContext);
    }

    private static boolean isTaskCancelled(Task<?> task) {
        return task.isCancelled() || task.isFaulted() && task.getError() instanceof CancellationException;
    }

    @Nullable
    @VisibleForTesting
    static Map<String, String> getExtraMap(ProducerListener2 listener, ProducerContext producerContext, boolean valueFound, int sizeInBytes) {
        if (!listener.requiresExtraMap(producerContext, PRODUCER_NAME)) {
            return null;
        }
        if (valueFound) {
            return ImmutableMap.of((Object)EXTRA_CACHED_VALUE_FOUND, (Object)String.valueOf(valueFound), (Object)ENCODED_IMAGE_SIZE, (Object)String.valueOf(sizeInBytes));
        }
        return ImmutableMap.of((Object)EXTRA_CACHED_VALUE_FOUND, (Object)String.valueOf(valueFound));
    }

    private void subscribeTaskForRequestCancellation(final AtomicBoolean isCancelled, ProducerContext producerContext) {
        producerContext.addCallbacks(new BaseProducerContextCallbacks(){

            @Override
            public void onCancellationRequested() {
                isCancelled.set(true);
            }
        });
    }

    private static Uri createUriForPartialCacheKey(ImageRequest imageRequest) {
        return imageRequest.getSourceUri().buildUpon().appendQueryParameter("fresco_partial", "true").build();
    }

    private static class PartialDiskCacheConsumer
    extends DelegatingConsumer<EncodedImage, EncodedImage> {
        private static final int READ_SIZE = 16384;
        private final BufferedDiskCache mDefaultBufferedDiskCache;
        private final CacheKey mPartialImageCacheKey;
        private final PooledByteBufferFactory mPooledByteBufferFactory;
        private final ByteArrayPool mByteArrayPool;
        @Nullable
        private final EncodedImage mPartialEncodedImageFromCache;
        private final boolean mIsDiskCacheEnabledForWrite;

        private PartialDiskCacheConsumer(Consumer<EncodedImage> consumer, BufferedDiskCache defaultBufferedDiskCache, CacheKey partialImageCacheKey, PooledByteBufferFactory pooledByteBufferFactory, ByteArrayPool byteArrayPool, @Nullable EncodedImage partialEncodedImageFromCache, boolean isDiskCacheEnabledForWrite) {
            super(consumer);
            this.mDefaultBufferedDiskCache = defaultBufferedDiskCache;
            this.mPartialImageCacheKey = partialImageCacheKey;
            this.mPooledByteBufferFactory = pooledByteBufferFactory;
            this.mByteArrayPool = byteArrayPool;
            this.mPartialEncodedImageFromCache = partialEncodedImageFromCache;
            this.mIsDiskCacheEnabledForWrite = isDiskCacheEnabledForWrite;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNewResultImpl(@Nullable EncodedImage newResult, int status) {
            if (PartialDiskCacheConsumer.isNotLast(status)) {
                return;
            }
            if (this.mPartialEncodedImageFromCache != null && newResult != null && newResult.getBytesRange() != null) {
                try {
                    PooledByteBufferOutputStream pooledOutputStream = this.merge(this.mPartialEncodedImageFromCache, newResult);
                    this.sendFinalResultToConsumer(pooledOutputStream);
                }
                catch (IOException e) {
                    FLog.e((String)PartialDiskCacheProducer.PRODUCER_NAME, (String)"Error while merging image data", (Throwable)e);
                    this.getConsumer().onFailure(e);
                }
                finally {
                    newResult.close();
                    this.mPartialEncodedImageFromCache.close();
                }
                this.mDefaultBufferedDiskCache.remove(this.mPartialImageCacheKey);
            } else if (this.mIsDiskCacheEnabledForWrite && PartialDiskCacheConsumer.statusHasFlag(status, 8) && PartialDiskCacheConsumer.isLast(status) && newResult != null && newResult.getImageFormat() != ImageFormat.UNKNOWN) {
                this.mDefaultBufferedDiskCache.put(this.mPartialImageCacheKey, newResult);
                this.getConsumer().onNewResult(newResult, status);
            } else {
                this.getConsumer().onNewResult(newResult, status);
            }
        }

        private PooledByteBufferOutputStream merge(EncodedImage initialData, EncodedImage remainingData) throws IOException {
            int bytesToReadFromInitialData = ((BytesRange)Preconditions.checkNotNull((Object)remainingData.getBytesRange())).from;
            int totalLength = remainingData.getSize() + bytesToReadFromInitialData;
            PooledByteBufferOutputStream pooledOutputStream = this.mPooledByteBufferFactory.newOutputStream(totalLength);
            this.copy(initialData.getInputStreamOrThrow(), (OutputStream)pooledOutputStream, bytesToReadFromInitialData);
            this.copy(remainingData.getInputStreamOrThrow(), (OutputStream)pooledOutputStream, remainingData.getSize());
            return pooledOutputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copy(InputStream from, OutputStream to, int length) throws IOException {
            int bytesStillToRead = length;
            byte[] ioArray = (byte[])this.mByteArrayPool.get(16384);
            try {
                int bufferLength;
                while (bytesStillToRead > 0 && (bufferLength = from.read(ioArray, 0, Math.min(16384, bytesStillToRead))) >= 0) {
                    if (bufferLength <= 0) continue;
                    to.write(ioArray, 0, bufferLength);
                    bytesStillToRead -= bufferLength;
                }
            }
            finally {
                this.mByteArrayPool.release((Object)ioArray);
            }
            if (bytesStillToRead > 0) {
                throw new IOException(String.format((Locale)null, "Failed to read %d bytes - finished %d short", length, bytesStillToRead));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendFinalResultToConsumer(PooledByteBufferOutputStream pooledOutputStream) {
            CloseableReference result = CloseableReference.of((Closeable)pooledOutputStream.toByteBuffer());
            EncodedImage encodedImage = null;
            try {
                encodedImage = new EncodedImage(result);
                encodedImage.parseMetaData();
                this.getConsumer().onNewResult(encodedImage, 1);
            }
            catch (Throwable throwable) {
                EncodedImage.closeSafely(encodedImage);
                CloseableReference.closeSafely((CloseableReference)result);
                throw throwable;
            }
            EncodedImage.closeSafely((EncodedImage)encodedImage);
            CloseableReference.closeSafely((CloseableReference)result);
        }
    }
}

