/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.decoder;

import com.facebook.common.internal.Preconditions;
import com.facebook.imagepipeline.decoder.ProgressiveJpegConfig;
import com.facebook.imagepipeline.image.ImmutableQualityInfo;
import com.facebook.imagepipeline.image.QualityInfo;
import com.facebook.infer.annotation.Nullsafe;
import java.util.Collections;
import java.util.List;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class SimpleProgressiveJpegConfig
implements ProgressiveJpegConfig {
    private final DynamicValueConfig mDynamicValueConfig;

    public SimpleProgressiveJpegConfig() {
        this(new DefaultDynamicValueConfig());
    }

    public SimpleProgressiveJpegConfig(DynamicValueConfig dynamicValueConfig) {
        this.mDynamicValueConfig = (DynamicValueConfig)Preconditions.checkNotNull((Object)dynamicValueConfig);
    }

    @Override
    public int getNextScanNumberToDecode(int scanNumber) {
        List<Integer> scansToDecode = this.mDynamicValueConfig.getScansToDecode();
        if (scansToDecode == null || scansToDecode.isEmpty()) {
            return scanNumber + 1;
        }
        for (int i = 0; i < scansToDecode.size(); ++i) {
            if (scansToDecode.get(i) <= scanNumber) continue;
            return scansToDecode.get(i);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public QualityInfo getQualityInfo(int scanNumber) {
        return ImmutableQualityInfo.of((int)scanNumber, (scanNumber >= this.mDynamicValueConfig.getGoodEnoughScanNumber() ? 1 : 0) != 0, (boolean)false);
    }

    private static class DefaultDynamicValueConfig
    implements DynamicValueConfig {
        private DefaultDynamicValueConfig() {
        }

        @Override
        public List<Integer> getScansToDecode() {
            return Collections.EMPTY_LIST;
        }

        @Override
        public int getGoodEnoughScanNumber() {
            return 0;
        }
    }

    public static interface DynamicValueConfig {
        public List<Integer> getScansToDecode();

        public int getGoodEnoughScanNumber();
    }
}

