/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.transcoder;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.os.Build;
import com.facebook.common.logging.FLog;
import com.facebook.imageformat.DefaultImageFormats;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.common.RotationOptions;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.transcoder.DownsampleUtil;
import com.facebook.imagepipeline.transcoder.ImageTranscodeResult;
import com.facebook.imagepipeline.transcoder.ImageTranscoder;
import com.facebook.imagepipeline.transcoder.JpegTranscoderUtils;
import com.facebook.infer.annotation.Nullsafe;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class SimpleImageTranscoder
implements ImageTranscoder {
    private static final String TAG = "SimpleImageTranscoder";
    private final boolean mResizingEnabled;
    private final int mMaxBitmapSize;

    public SimpleImageTranscoder(boolean resizingEnabled, int maxBitmapSize) {
        this.mResizingEnabled = resizingEnabled;
        this.mMaxBitmapSize = maxBitmapSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageTranscodeResult transcode(EncodedImage encodedImage, OutputStream outputStream, @Nullable RotationOptions rotationOptions, @Nullable ResizeOptions resizeOptions, @Nullable ImageFormat outputFormat, @Nullable Integer quality) {
        Bitmap resizedBitmap;
        if (quality == null) {
            quality = 85;
        }
        if (rotationOptions == null) {
            rotationOptions = RotationOptions.autoRotate();
        }
        int sampleSize = this.getSampleSize(encodedImage, rotationOptions, resizeOptions);
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = sampleSize;
        try {
            resizedBitmap = BitmapFactory.decodeStream((InputStream)encodedImage.getInputStream(), null, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError oom) {
            FLog.e((String)TAG, (String)"Out-Of-Memory during transcode", (Throwable)oom);
            return new ImageTranscodeResult(2);
        }
        if (resizedBitmap == null) {
            FLog.e((String)TAG, (String)"Couldn't decode the EncodedImage InputStream ! ");
            return new ImageTranscodeResult(2);
        }
        Matrix transformationMatrix = JpegTranscoderUtils.getTransformationMatrix((EncodedImage)encodedImage, (RotationOptions)rotationOptions);
        Bitmap srcBitmap = resizedBitmap;
        try {
            if (transformationMatrix != null) {
                srcBitmap = Bitmap.createBitmap((Bitmap)resizedBitmap, (int)0, (int)0, (int)resizedBitmap.getWidth(), (int)resizedBitmap.getHeight(), (Matrix)transformationMatrix, (boolean)false);
            }
            srcBitmap.compress(SimpleImageTranscoder.getOutputFormat(outputFormat), quality.intValue(), outputStream);
            ImageTranscodeResult imageTranscodeResult = new ImageTranscodeResult(sampleSize > 1 ? 0 : 1);
            return imageTranscodeResult;
        }
        catch (OutOfMemoryError oom) {
            FLog.e((String)TAG, (String)"Out-Of-Memory during transcode", (Throwable)oom);
            ImageTranscodeResult imageTranscodeResult = new ImageTranscodeResult(2);
            return imageTranscodeResult;
        }
        finally {
            srcBitmap.recycle();
            resizedBitmap.recycle();
        }
    }

    public boolean canResize(EncodedImage encodedImage, @Nullable RotationOptions rotationOptions, @Nullable ResizeOptions resizeOptions) {
        if (rotationOptions == null) {
            rotationOptions = RotationOptions.autoRotate();
        }
        return this.mResizingEnabled && DownsampleUtil.determineSampleSize((RotationOptions)rotationOptions, (ResizeOptions)resizeOptions, (EncodedImage)encodedImage, (int)this.mMaxBitmapSize) > 1;
    }

    public boolean canTranscode(ImageFormat imageFormat) {
        return imageFormat == DefaultImageFormats.HEIF || imageFormat == DefaultImageFormats.JPEG;
    }

    public String getIdentifier() {
        return TAG;
    }

    private int getSampleSize(EncodedImage encodedImage, RotationOptions rotationOptions, @Nullable ResizeOptions resizeOptions) {
        int sampleSize = !this.mResizingEnabled ? 1 : DownsampleUtil.determineSampleSize((RotationOptions)rotationOptions, (ResizeOptions)resizeOptions, (EncodedImage)encodedImage, (int)this.mMaxBitmapSize);
        return sampleSize;
    }

    private static Bitmap.CompressFormat getOutputFormat(@Nullable ImageFormat format) {
        if (format == null) {
            return Bitmap.CompressFormat.JPEG;
        }
        if (format == DefaultImageFormats.JPEG) {
            return Bitmap.CompressFormat.JPEG;
        }
        if (format == DefaultImageFormats.PNG) {
            return Bitmap.CompressFormat.PNG;
        }
        if (Build.VERSION.SDK_INT >= 14 && DefaultImageFormats.isStaticWebpFormat((ImageFormat)format)) {
            return Bitmap.CompressFormat.WEBP;
        }
        return Bitmap.CompressFormat.JPEG;
    }
}

