/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.facebook.common.logging.FLog;
import com.facebook.common.time.MonotonicClock;
import com.facebook.common.time.RealtimeSinceBootClock;
import com.facebook.imagepipeline.common.Priority;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.FetchState;
import com.facebook.imagepipeline.producers.NetworkFetcher;
import com.facebook.imagepipeline.producers.ProducerContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PriorityNetworkFetcher<FETCH_STATE extends FetchState>
implements NetworkFetcher<PriorityFetchState<FETCH_STATE>> {
    public static final String TAG = PriorityNetworkFetcher.class.getSimpleName();
    private final NetworkFetcher<FETCH_STATE> mDelegate;
    private final boolean mIsHiPriFifo;
    private final int mMaxOutstandingHiPri;
    private final int mMaxOutstandingLowPri;
    private final MonotonicClock mClock;
    private final Object mLock = new Object();
    private final LinkedList<PriorityFetchState<FETCH_STATE>> mHiPriQueue = new LinkedList();
    private final LinkedList<PriorityFetchState<FETCH_STATE>> mLowPriQueue = new LinkedList();
    private final HashSet<PriorityFetchState<FETCH_STATE>> mCurrentlyFetching = new HashSet();
    private volatile boolean isRunning = true;
    private final boolean inflightFetchesCanBeCancelled;
    private final boolean infiniteRetries;

    public PriorityNetworkFetcher(NetworkFetcher<FETCH_STATE> delegate, boolean isHiPriFifo, int maxOutstandingHiPri, int maxOutstandingLowPri, boolean inflightFetchesCanBeCancelled, boolean infiniteRetries) {
        this(delegate, isHiPriFifo, maxOutstandingHiPri, maxOutstandingLowPri, inflightFetchesCanBeCancelled, infiniteRetries, (MonotonicClock)RealtimeSinceBootClock.get());
    }

    @VisibleForTesting
    public PriorityNetworkFetcher(NetworkFetcher<FETCH_STATE> delegate, boolean isHiPriFifo, int maxOutstandingHiPri, int maxOutstandingLowPri, boolean inflightFetchesCanBeCancelled, boolean infiniteRetries, MonotonicClock clock) {
        this.mDelegate = delegate;
        this.mIsHiPriFifo = isHiPriFifo;
        this.mMaxOutstandingHiPri = maxOutstandingHiPri;
        this.mMaxOutstandingLowPri = maxOutstandingLowPri;
        if (maxOutstandingHiPri <= maxOutstandingLowPri) {
            throw new IllegalArgumentException("maxOutstandingHiPri should be > maxOutstandingLowPri");
        }
        this.inflightFetchesCanBeCancelled = inflightFetchesCanBeCancelled;
        this.infiniteRetries = infiniteRetries;
        this.mClock = clock;
    }

    public void pause() {
        this.isRunning = false;
    }

    public void resume() {
        this.isRunning = true;
        this.dequeueIfAvailableSlots();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetch(final PriorityFetchState<FETCH_STATE> fetchState, final NetworkFetcher.Callback callback) {
        fetchState.getContext().addCallbacks(new BaseProducerContextCallbacks(){

            @Override
            public void onCancellationRequested() {
                if (!PriorityNetworkFetcher.this.inflightFetchesCanBeCancelled && PriorityNetworkFetcher.this.mCurrentlyFetching.contains(fetchState)) {
                    return;
                }
                PriorityNetworkFetcher.this.removeFromQueue(fetchState, "CANCEL");
                callback.onCancellation();
            }

            @Override
            public void onPriorityChanged() {
                PriorityNetworkFetcher.this.changePriority(fetchState, fetchState.getContext().getPriority() == Priority.HIGH);
            }
        });
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCurrentlyFetching.contains(fetchState)) {
                FLog.e((String)TAG, (String)("fetch state was enqueued twice: " + fetchState));
                return;
            }
            boolean isHiPri = fetchState.getContext().getPriority() == Priority.HIGH;
            FLog.v((String)TAG, (String)"enqueue: %s %s", (Object)(isHiPri ? "HI-PRI" : "LOW-PRI"), (Object)fetchState.getUri());
            fetchState.callback = callback;
            this.putInQueue(fetchState, isHiPri);
        }
        this.dequeueIfAvailableSlots();
    }

    @Override
    public void onFetchCompletion(PriorityFetchState<FETCH_STATE> fetchState, int byteSize) {
        this.removeFromQueue(fetchState, "SUCCESS");
        this.mDelegate.onFetchCompletion(fetchState.delegatedState, byteSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromQueue(PriorityFetchState<FETCH_STATE> fetchState, String reasonForLogging) {
        Object object = this.mLock;
        synchronized (object) {
            FLog.v((String)TAG, (String)"remove: %s %s", (Object)reasonForLogging, (Object)fetchState.getUri());
            this.mCurrentlyFetching.remove(fetchState);
            if (!this.mHiPriQueue.remove(fetchState)) {
                this.mLowPriQueue.remove(fetchState);
            }
        }
        this.dequeueIfAvailableSlots();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requeue(PriorityFetchState<FETCH_STATE> fetchState) {
        Object object = this.mLock;
        synchronized (object) {
            FLog.v((String)TAG, (String)"requeue: %s", (Object)fetchState.getUri());
            ++fetchState.requeueCount;
            fetchState.delegatedState = this.mDelegate.createFetchState(fetchState.getConsumer(), fetchState.getContext());
            this.mCurrentlyFetching.remove(fetchState);
            if (!this.mHiPriQueue.remove(fetchState)) {
                this.mLowPriQueue.remove(fetchState);
            }
            this.putInQueue(fetchState, fetchState.getContext().getPriority() == Priority.HIGH);
        }
        this.dequeueIfAvailableSlots();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dequeueIfAvailableSlots() {
        if (!this.isRunning) {
            return;
        }
        PriorityFetchState<FETCH_STATE> toFetch = null;
        Object object = this.mLock;
        synchronized (object) {
            int outstandingRequests = this.mCurrentlyFetching.size();
            if (outstandingRequests < this.mMaxOutstandingHiPri) {
                toFetch = this.mHiPriQueue.pollFirst();
            }
            if (toFetch == null && outstandingRequests < this.mMaxOutstandingLowPri) {
                toFetch = this.mLowPriQueue.pollFirst();
            }
            if (toFetch == null) {
                return;
            }
            toFetch.dequeuedTimestamp = this.mClock.now();
            this.mCurrentlyFetching.add(toFetch);
            FLog.v((String)TAG, (String)"fetching: %s (concurrent: %s hi-pri queue: %s low-pri queue: %s)", (Object)toFetch.getUri(), (Object)outstandingRequests, (Object)this.mHiPriQueue.size(), (Object)this.mLowPriQueue.size());
        }
        this.delegateFetch(toFetch);
    }

    private void delegateFetch(final PriorityFetchState<FETCH_STATE> fetchState) {
        try {
            NetworkFetcher.Callback callbackWrapper = new NetworkFetcher.Callback(){

                @Override
                public void onResponse(InputStream response, int responseLength) throws IOException {
                    fetchState.callback.onResponse(response, responseLength);
                }

                @Override
                public void onFailure(Throwable throwable) {
                    if (PriorityNetworkFetcher.this.infiniteRetries && !(throwable instanceof NonrecoverableException)) {
                        PriorityNetworkFetcher.this.requeue(fetchState);
                    } else {
                        PriorityNetworkFetcher.this.removeFromQueue(fetchState, "FAIL");
                        fetchState.callback.onFailure(throwable);
                    }
                }

                @Override
                public void onCancellation() {
                    PriorityNetworkFetcher.this.removeFromQueue(fetchState, "CANCEL");
                    fetchState.callback.onCancellation();
                }
            };
            this.mDelegate.fetch(fetchState.delegatedState, callbackWrapper);
        }
        catch (Exception e) {
            this.removeFromQueue(fetchState, "FAIL");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changePriority(PriorityFetchState<FETCH_STATE> fetchState, boolean isNewHiPri) {
        Object object = this.mLock;
        synchronized (object) {
            boolean existed;
            boolean bl = existed = isNewHiPri ? this.mLowPriQueue.remove(fetchState) : this.mHiPriQueue.remove(fetchState);
            if (!existed) {
                return;
            }
            FLog.v((String)TAG, (String)"change-pri: %s %s", (Object)(isNewHiPri ? "HIPRI" : "LOWPRI"), (Object)fetchState.getUri());
            ++fetchState.priorityChangedCount;
            this.putInQueue(fetchState, isNewHiPri);
        }
        this.dequeueIfAvailableSlots();
    }

    private void putInQueue(PriorityFetchState<FETCH_STATE> entry, boolean isHiPri) {
        if (isHiPri) {
            if (this.mIsHiPriFifo) {
                this.mHiPriQueue.addLast(entry);
            } else {
                this.mHiPriQueue.addFirst(entry);
            }
        } else {
            this.mLowPriQueue.addLast(entry);
        }
    }

    @VisibleForTesting
    List<PriorityFetchState<FETCH_STATE>> getHiPriQueue() {
        return this.mHiPriQueue;
    }

    @VisibleForTesting
    List<PriorityFetchState<FETCH_STATE>> getLowPriQueue() {
        return this.mLowPriQueue;
    }

    @VisibleForTesting
    HashSet<PriorityFetchState<FETCH_STATE>> getCurrentlyFetching() {
        return this.mCurrentlyFetching;
    }

    @Override
    public PriorityFetchState<FETCH_STATE> createFetchState(Consumer<EncodedImage> consumer, ProducerContext producerContext) {
        return new PriorityFetchState(consumer, producerContext, (FetchState)this.mDelegate.createFetchState(consumer, producerContext), this.mClock.now(), this.mHiPriQueue.size(), this.mLowPriQueue.size(), this.mCurrentlyFetching.size(), null);
    }

    @Override
    public boolean shouldPropagate(PriorityFetchState<FETCH_STATE> fetchState) {
        return this.mDelegate.shouldPropagate(fetchState.delegatedState);
    }

    @Override
    @javax.annotation.Nullable
    public Map<String, String> getExtraMap(PriorityFetchState<FETCH_STATE> fetchState, int byteSize) {
        Map<String, String> delegateExtras = this.mDelegate.getExtraMap(fetchState.delegatedState, byteSize);
        HashMap<String, String> extras = delegateExtras != null ? new HashMap<String, String>(delegateExtras) : new HashMap();
        extras.put("pri_queue_time", "" + (fetchState.dequeuedTimestamp - fetchState.enqueuedTimestamp));
        extras.put("hipri_queue_size", "" + fetchState.hiPriCountWhenCreated);
        extras.put("lowpri_queue_size", "" + fetchState.lowPriCountWhenCreated);
        extras.put("requeueCount", "" + fetchState.requeueCount);
        extras.put("priority_changed_count", "" + fetchState.priorityChangedCount);
        extras.put("request_initial_priority_is_high", "" + fetchState.isInitialPriorityHigh);
        extras.put("currently_fetching_size", "" + fetchState.currentlyFetchingCountWhenCreated);
        return extras;
    }

    public static class NonrecoverableException
    extends Throwable {
        public NonrecoverableException(@Nullable String message) {
            super(message);
        }
    }

    public static class PriorityFetchState<FETCH_STATE extends FetchState>
    extends FetchState {
        public FETCH_STATE delegatedState;
        final long enqueuedTimestamp;
        final int hiPriCountWhenCreated;
        final int lowPriCountWhenCreated;
        final int currentlyFetchingCountWhenCreated;
        @javax.annotation.Nullable
        NetworkFetcher.Callback callback;
        long dequeuedTimestamp;
        int requeueCount = 0;
        int priorityChangedCount = 0;
        final boolean isInitialPriorityHigh;

        private PriorityFetchState(Consumer<EncodedImage> consumer, ProducerContext producerContext, FETCH_STATE delegatedState, long enqueuedTimestamp, int hiPriCountWhenCreated, int lowPriCountWhenCreated, int currentlyFetchingCountWhenCreated) {
            super(consumer, producerContext);
            this.delegatedState = delegatedState;
            this.enqueuedTimestamp = enqueuedTimestamp;
            this.hiPriCountWhenCreated = hiPriCountWhenCreated;
            this.lowPriCountWhenCreated = lowPriCountWhenCreated;
            this.isInitialPriorityHigh = producerContext.getPriority() == Priority.HIGH;
            this.currentlyFetchingCountWhenCreated = currentlyFetchingCountWhenCreated;
        }

        /* synthetic */ PriorityFetchState(Consumer x0, ProducerContext x1, FetchState x2, long x3, int x4, int x5, int x6, 1 x7) {
            this(x0, x1, x2, x3, x4, x5, x6);
        }
    }
}

