/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.util.Pair;
import androidx.annotation.VisibleForTesting;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Sets;
import com.facebook.common.util.TriState;
import com.facebook.imagepipeline.common.Priority;
import com.facebook.imagepipeline.producers.BaseConsumer;
import com.facebook.imagepipeline.producers.BaseProducerContext;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.MultiplexProducer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerContextCallbacks;
import com.facebook.imagepipeline.systrace.FrescoSystrace;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class MultiplexProducer<K, T extends Closeable>
implements Producer<T> {
    public static final String EXTRAS_STARTED_AS_PREFETCH = "started_as_prefetch";
    @GuardedBy(value="this")
    @VisibleForTesting
    final Map<K, Multiplexer> mMultiplexers;
    private final Producer<T> mInputProducer;
    private final boolean mKeepCancelledFetchAsLowPriority;
    private final String mProducerName;
    private final String mDedupedRequestsCountKey;

    protected MultiplexProducer(Producer<T> inputProducer, String producerName, @ProducerContext.ExtraKeys String dedupedRequestsCountKey) {
        this(inputProducer, producerName, dedupedRequestsCountKey, false);
    }

    protected MultiplexProducer(Producer<T> inputProducer, String producerName, @ProducerContext.ExtraKeys String dedupedRequestsCountKey, boolean keepCancelledFetchAsLowPriority) {
        this.mInputProducer = inputProducer;
        this.mMultiplexers = new HashMap<K, Multiplexer>();
        this.mKeepCancelledFetchAsLowPriority = keepCancelledFetchAsLowPriority;
        this.mProducerName = producerName;
        this.mDedupedRequestsCountKey = dedupedRequestsCountKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void produceResults(Consumer<T> consumer, ProducerContext context) {
        try {
            boolean createdNewMultiplexer;
            Multiplexer multiplexer;
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"MultiplexProducer#produceResults");
            }
            context.getProducerListener().onProducerStart(context, this.mProducerName);
            K key = this.getKey(context);
            do {
                createdNewMultiplexer = false;
                MultiplexProducer multiplexProducer = this;
                synchronized (multiplexProducer) {
                    multiplexer = this.getExistingMultiplexer(key);
                    if (multiplexer == null) {
                        multiplexer = this.createAndPutNewMultiplexer(key);
                        createdNewMultiplexer = true;
                    }
                }
            } while (!multiplexer.addNewConsumer(consumer, context));
            if (createdNewMultiplexer) {
                multiplexer.startInputProducerIfHasAttachedConsumers(TriState.valueOf((boolean)context.isPrefetch()));
            }
        }
        finally {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
    }

    protected synchronized Multiplexer getExistingMultiplexer(K key) {
        return this.mMultiplexers.get(key);
    }

    private synchronized Multiplexer createAndPutNewMultiplexer(K key) {
        Multiplexer multiplexer = new Multiplexer(key);
        this.mMultiplexers.put(key, multiplexer);
        return multiplexer;
    }

    protected synchronized void removeMultiplexer(K key, Multiplexer multiplexer) {
        if (this.mMultiplexers.get(key) == multiplexer) {
            this.mMultiplexers.remove(key);
        }
    }

    protected abstract K getKey(ProducerContext var1);

    protected abstract T cloneOrNull(T var1);

    @VisibleForTesting
    class Multiplexer {
        private final K mKey;
        private final CopyOnWriteArraySet<Pair<Consumer<T>, ProducerContext>> mConsumerContextPairs = Sets.newCopyOnWriteArraySet();
        @Nullable
        @GuardedBy(value="Multiplexer.this")
        private T mLastIntermediateResult;
        @GuardedBy(value="Multiplexer.this")
        private float mLastProgress;
        @GuardedBy(value="Multiplexer.this")
        private int mLastStatus;
        @Nullable
        @GuardedBy(value="Multiplexer.this")
        private BaseProducerContext mMultiplexProducerContext;
        @Nullable
        @GuardedBy(value="Multiplexer.this")
        private com.facebook.imagepipeline.producers.MultiplexProducer$Multiplexer.ForwardingConsumer mForwardingConsumer;

        public Multiplexer(K key) {
            this.mKey = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addNewConsumer(Consumer<T> consumer, ProducerContext producerContext) {
            int lastStatus;
            float lastProgress;
            Object lastIntermediateResult;
            List<ProducerContextCallbacks> intermediateResultsCallbacks;
            List<ProducerContextCallbacks> priorityCallbacks;
            List<ProducerContextCallbacks> prefetchCallbacks;
            Pair consumerContextPair = Pair.create(consumer, (Object)producerContext);
            Multiplexer multiplexer = this;
            synchronized (multiplexer) {
                if (MultiplexProducer.this.getExistingMultiplexer(this.mKey) != this) {
                    return false;
                }
                this.mConsumerContextPairs.add(consumerContextPair);
                prefetchCallbacks = this.updateIsPrefetch();
                priorityCallbacks = this.updatePriority();
                intermediateResultsCallbacks = this.updateIsIntermediateResultExpected();
                lastIntermediateResult = this.mLastIntermediateResult;
                lastProgress = this.mLastProgress;
                lastStatus = this.mLastStatus;
            }
            BaseProducerContext.callOnIsPrefetchChanged(prefetchCallbacks);
            BaseProducerContext.callOnPriorityChanged(priorityCallbacks);
            BaseProducerContext.callOnIsIntermediateResultExpectedChanged(intermediateResultsCallbacks);
            multiplexer = consumerContextPair;
            synchronized (multiplexer) {
                Multiplexer multiplexer2 = this;
                synchronized (multiplexer2) {
                    if (lastIntermediateResult != this.mLastIntermediateResult) {
                        lastIntermediateResult = null;
                    } else if (lastIntermediateResult != null) {
                        lastIntermediateResult = MultiplexProducer.this.cloneOrNull(lastIntermediateResult);
                    }
                }
                if (lastIntermediateResult != null) {
                    if (lastProgress > 0.0f) {
                        consumer.onProgressUpdate(lastProgress);
                    }
                    consumer.onNewResult(lastIntermediateResult, lastStatus);
                    this.closeSafely((Closeable)lastIntermediateResult);
                }
            }
            this.addCallbacks(consumerContextPair, producerContext);
            return true;
        }

        private void addCallbacks(final Pair<Consumer<T>, ProducerContext> consumerContextPair, ProducerContext producerContext) {
            producerContext.addCallbacks(new BaseProducerContextCallbacks(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onCancellationRequested() {
                    boolean pairWasRemoved;
                    BaseProducerContext contextToCancel = null;
                    List isPrefetchCallbacks = null;
                    List priorityCallbacks = null;
                    List isIntermediateResultExpectedCallbacks = null;
                    Multiplexer multiplexer = Multiplexer.this;
                    synchronized (multiplexer) {
                        pairWasRemoved = Multiplexer.this.mConsumerContextPairs.remove(consumerContextPair);
                        if (pairWasRemoved) {
                            if (Multiplexer.this.mConsumerContextPairs.isEmpty()) {
                                contextToCancel = Multiplexer.this.mMultiplexProducerContext;
                            } else {
                                isPrefetchCallbacks = Multiplexer.this.updateIsPrefetch();
                                priorityCallbacks = Multiplexer.this.updatePriority();
                                isIntermediateResultExpectedCallbacks = Multiplexer.this.updateIsIntermediateResultExpected();
                            }
                        }
                    }
                    BaseProducerContext.callOnIsPrefetchChanged(isPrefetchCallbacks);
                    BaseProducerContext.callOnPriorityChanged(priorityCallbacks);
                    BaseProducerContext.callOnIsIntermediateResultExpectedChanged(isIntermediateResultExpectedCallbacks);
                    if (contextToCancel != null) {
                        if (MultiplexProducer.this.mKeepCancelledFetchAsLowPriority && !contextToCancel.isPrefetch()) {
                            List<ProducerContextCallbacks> callbacks = contextToCancel.setPriorityNoCallbacks(Priority.LOW);
                            BaseProducerContext.callOnPriorityChanged(callbacks);
                        } else {
                            contextToCancel.cancel();
                        }
                    }
                    if (pairWasRemoved) {
                        ((Consumer)consumerContextPair.first).onCancellation();
                    }
                }

                @Override
                public void onIsPrefetchChanged() {
                    BaseProducerContext.callOnIsPrefetchChanged(Multiplexer.this.updateIsPrefetch());
                }

                @Override
                public void onIsIntermediateResultExpectedChanged() {
                    BaseProducerContext.callOnIsIntermediateResultExpectedChanged(Multiplexer.this.updateIsIntermediateResultExpected());
                }

                @Override
                public void onPriorityChanged() {
                    BaseProducerContext.callOnPriorityChanged(Multiplexer.this.updatePriority());
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startInputProducerIfHasAttachedConsumers(TriState startedAsPrefetch) {
            com.facebook.imagepipeline.producers.MultiplexProducer$Multiplexer.ForwardingConsumer forwardingConsumer;
            BaseProducerContext multiplexProducerContext;
            Multiplexer multiplexer = this;
            synchronized (multiplexer) {
                Preconditions.checkArgument((Boolean)(this.mMultiplexProducerContext == null ? 1 : 0));
                Preconditions.checkArgument((Boolean)(this.mForwardingConsumer == null ? 1 : 0));
                if (this.mConsumerContextPairs.isEmpty()) {
                    MultiplexProducer.this.removeMultiplexer(this.mKey, this);
                    return;
                }
                ProducerContext producerContext = (ProducerContext)this.mConsumerContextPairs.iterator().next().second;
                this.mMultiplexProducerContext = new BaseProducerContext(producerContext.getImageRequest(), producerContext.getId(), producerContext.getProducerListener(), producerContext.getCallerContext(), producerContext.getLowestPermittedRequestLevel(), this.computeIsPrefetch(), this.computeIsIntermediateResultExpected(), this.computePriority(), producerContext.getImagePipelineConfig());
                this.mMultiplexProducerContext.putExtras(producerContext.getExtras());
                if (startedAsPrefetch.isSet()) {
                    this.mMultiplexProducerContext.setExtra(MultiplexProducer.EXTRAS_STARTED_AS_PREFETCH, (Object)startedAsPrefetch.asBoolean());
                }
                this.mForwardingConsumer = new ForwardingConsumer();
                multiplexProducerContext = this.mMultiplexProducerContext;
                forwardingConsumer = this.mForwardingConsumer;
            }
            MultiplexProducer.this.mInputProducer.produceResults(forwardingConsumer, multiplexProducerContext);
        }

        @Nullable
        private synchronized List<ProducerContextCallbacks> updateIsPrefetch() {
            if (this.mMultiplexProducerContext == null) {
                return null;
            }
            return this.mMultiplexProducerContext.setIsPrefetchNoCallbacks(this.computeIsPrefetch());
        }

        private synchronized boolean computeIsPrefetch() {
            for (Pair pair : this.mConsumerContextPairs) {
                if (((ProducerContext)pair.second).isPrefetch()) continue;
                return false;
            }
            return true;
        }

        @Nullable
        private synchronized List<ProducerContextCallbacks> updateIsIntermediateResultExpected() {
            if (this.mMultiplexProducerContext == null) {
                return null;
            }
            return this.mMultiplexProducerContext.setIsIntermediateResultExpectedNoCallbacks(this.computeIsIntermediateResultExpected());
        }

        private synchronized boolean computeIsIntermediateResultExpected() {
            for (Pair pair : this.mConsumerContextPairs) {
                if (!((ProducerContext)pair.second).isIntermediateResultExpected()) continue;
                return true;
            }
            return false;
        }

        @Nullable
        private synchronized List<ProducerContextCallbacks> updatePriority() {
            if (this.mMultiplexProducerContext == null) {
                return null;
            }
            return this.mMultiplexProducerContext.setPriorityNoCallbacks(this.computePriority());
        }

        private synchronized Priority computePriority() {
            Priority priority = Priority.LOW;
            for (Pair pair : this.mConsumerContextPairs) {
                priority = Priority.getHigherPriority((Priority)priority, (Priority)((ProducerContext)pair.second).getPriority());
            }
            return priority;
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFailure(ForwardingConsumer consumer, Throwable t) {
            Iterator iterator;
            Multiplexer multiplexer = this;
            synchronized (multiplexer) {
                if (this.mForwardingConsumer != consumer) {
                    return;
                }
                iterator = this.mConsumerContextPairs.iterator();
                this.mConsumerContextPairs.clear();
                MultiplexProducer.this.removeMultiplexer(this.mKey, this);
                this.closeSafely((Closeable)this.mLastIntermediateResult);
                this.mLastIntermediateResult = null;
            }
            while (iterator.hasNext()) {
                Pair pair;
                Pair pair2 = pair = iterator.next();
                synchronized (pair2) {
                    ((ProducerContext)pair.second).getProducerListener().onProducerFinishWithFailure((ProducerContext)pair.second, MultiplexProducer.this.mProducerName, t, null);
                    ((Consumer)pair.first).onFailure(t);
                }
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNextResult(ForwardingConsumer consumer, Closeable closeableObject, int status) {
            int size;
            Iterator iterator;
            Multiplexer multiplexer = this;
            synchronized (multiplexer) {
                if (this.mForwardingConsumer != consumer) {
                    return;
                }
                this.closeSafely((Closeable)this.mLastIntermediateResult);
                this.mLastIntermediateResult = null;
                iterator = this.mConsumerContextPairs.iterator();
                size = this.mConsumerContextPairs.size();
                if (BaseConsumer.isNotLast(status)) {
                    this.mLastIntermediateResult = MultiplexProducer.this.cloneOrNull(closeableObject);
                    this.mLastStatus = status;
                } else {
                    this.mConsumerContextPairs.clear();
                    MultiplexProducer.this.removeMultiplexer(this.mKey, this);
                }
            }
            while (iterator.hasNext()) {
                Pair pair;
                Pair pair2 = pair = iterator.next();
                synchronized (pair2) {
                    if (BaseConsumer.isLast(status)) {
                        ((ProducerContext)pair.second).getProducerListener().onProducerFinishWithSuccess((ProducerContext)pair.second, MultiplexProducer.this.mProducerName, null);
                        if (this.mMultiplexProducerContext != null) {
                            ((ProducerContext)pair.second).putExtras(this.mMultiplexProducerContext.getExtras());
                        }
                        ((ProducerContext)pair.second).setExtra(MultiplexProducer.this.mDedupedRequestsCountKey, size);
                    }
                    ((Consumer)pair.first).onNewResult(closeableObject, status);
                }
            }
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCancelled(ForwardingConsumer forwardingConsumer) {
            Multiplexer multiplexer = this;
            synchronized (multiplexer) {
                if (this.mForwardingConsumer != forwardingConsumer) {
                    return;
                }
                this.mForwardingConsumer = null;
                this.mMultiplexProducerContext = null;
                this.closeSafely((Closeable)this.mLastIntermediateResult);
                this.mLastIntermediateResult = null;
            }
            this.startInputProducerIfHasAttachedConsumers(TriState.UNSET);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onProgressUpdate(ForwardingConsumer forwardingConsumer, float progress) {
            Iterator iterator;
            Multiplexer multiplexer = this;
            synchronized (multiplexer) {
                if (this.mForwardingConsumer != forwardingConsumer) {
                    return;
                }
                this.mLastProgress = progress;
                iterator = this.mConsumerContextPairs.iterator();
            }
            while (iterator.hasNext()) {
                Pair pair;
                Pair pair2 = pair = iterator.next();
                synchronized (pair2) {
                    ((Consumer)pair.first).onProgressUpdate(progress);
                }
            }
        }

        private void closeSafely(Closeable obj) {
            try {
                if (obj != null) {
                    obj.close();
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }

        private class ForwardingConsumer
        extends BaseConsumer<T> {
            private ForwardingConsumer() {
            }

            @Override
            protected void onNewResultImpl(T newResult, int status) {
                try {
                    if (FrescoSystrace.isTracing()) {
                        FrescoSystrace.beginSection((String)"MultiplexProducer#onNewResult");
                    }
                    Multiplexer.this.onNextResult(this, (Closeable)newResult, status);
                }
                finally {
                    if (FrescoSystrace.isTracing()) {
                        FrescoSystrace.endSection();
                    }
                }
            }

            @Override
            protected void onFailureImpl(Throwable t) {
                try {
                    if (FrescoSystrace.isTracing()) {
                        FrescoSystrace.beginSection((String)"MultiplexProducer#onFailure");
                    }
                    Multiplexer.this.onFailure(this, t);
                }
                finally {
                    if (FrescoSystrace.isTracing()) {
                        FrescoSystrace.endSection();
                    }
                }
            }

            @Override
            protected void onCancellationImpl() {
                try {
                    if (FrescoSystrace.isTracing()) {
                        FrescoSystrace.beginSection((String)"MultiplexProducer#onCancellation");
                    }
                    Multiplexer.this.onCancelled(this);
                }
                finally {
                    if (FrescoSystrace.isTracing()) {
                        FrescoSystrace.endSection();
                    }
                }
            }

            @Override
            protected void onProgressUpdateImpl(float progress) {
                try {
                    if (FrescoSystrace.isTracing()) {
                        FrescoSystrace.beginSection((String)"MultiplexProducer#onProgressUpdate");
                    }
                    Multiplexer.this.onProgressUpdate(this, progress);
                }
                finally {
                    if (FrescoSystrace.isTracing()) {
                        FrescoSystrace.endSection();
                    }
                }
            }
        }
    }
}

