/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import android.util.SparseIntArray;
import com.facebook.imagepipeline.memory.PoolParams;
import com.facebook.infer.annotation.Nullsafe;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class DefaultNativeMemoryChunkPoolParams {
    private static final int SMALL_BUCKET_LENGTH = 5;
    private static final int LARGE_BUCKET_LENGTH = 2;

    public static PoolParams get() {
        SparseIntArray DEFAULT_BUCKETS = new SparseIntArray();
        DEFAULT_BUCKETS.put(1024, 5);
        DEFAULT_BUCKETS.put(2048, 5);
        DEFAULT_BUCKETS.put(4096, 5);
        DEFAULT_BUCKETS.put(8192, 5);
        DEFAULT_BUCKETS.put(16384, 5);
        DEFAULT_BUCKETS.put(32768, 5);
        DEFAULT_BUCKETS.put(65536, 5);
        DEFAULT_BUCKETS.put(131072, 5);
        DEFAULT_BUCKETS.put(262144, 2);
        DEFAULT_BUCKETS.put(524288, 2);
        DEFAULT_BUCKETS.put(0x100000, 2);
        return new PoolParams(DefaultNativeMemoryChunkPoolParams.getMaxSizeSoftCap(), DefaultNativeMemoryChunkPoolParams.getMaxSizeHardCap(), DEFAULT_BUCKETS);
    }

    private static int getMaxSizeSoftCap() {
        int maxMemory = (int)Math.min(Runtime.getRuntime().maxMemory(), Integer.MAX_VALUE);
        if (maxMemory < 0x1000000) {
            return 0x300000;
        }
        if (maxMemory < 0x2000000) {
            return 0x600000;
        }
        return 0xC00000;
    }

    private static int getMaxSizeHardCap() {
        int maxMemory = (int)Math.min(Runtime.getRuntime().maxMemory(), Integer.MAX_VALUE);
        if (maxMemory < 0x1000000) {
            return maxMemory / 2;
        }
        return maxMemory / 4 * 3;
    }
}

