/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.memory.MemoryTrimmableRegistry;
import com.facebook.imagepipeline.memory.BasePool;
import com.facebook.imagepipeline.memory.BitmapPool;
import com.facebook.imagepipeline.memory.Bucket;
import com.facebook.imagepipeline.memory.PoolParams;
import com.facebook.imagepipeline.memory.PoolStatsTracker;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@TargetApi(value=21)
public class BucketsBitmapPool
extends BasePool<Bitmap>
implements BitmapPool {
    public BucketsBitmapPool(MemoryTrimmableRegistry memoryTrimmableRegistry, PoolParams poolParams, PoolStatsTracker poolStatsTracker, boolean ignoreHardCap) {
        super(memoryTrimmableRegistry, poolParams, poolStatsTracker, ignoreHardCap);
        this.initialize();
    }

    @Override
    protected Bitmap alloc(int size) {
        return Bitmap.createBitmap((int)1, (int)((int)Math.ceil((double)size / 2.0)), (Bitmap.Config)Bitmap.Config.RGB_565);
    }

    @Override
    protected void free(Bitmap value) {
        Preconditions.checkNotNull((Object)value);
        value.recycle();
    }

    @Override
    protected int getBucketedSize(int requestSize) {
        return requestSize;
    }

    @Override
    protected int getBucketedSizeForValue(Bitmap value) {
        Preconditions.checkNotNull((Object)value);
        return value.getAllocationByteCount();
    }

    @Override
    protected int getSizeInBytes(int bucketedSize) {
        return bucketedSize;
    }

    @Override
    protected boolean isReusable(Bitmap value) {
        Preconditions.checkNotNull((Object)value);
        return !value.isRecycled() && value.isMutable();
    }

    @Override
    @Nullable
    protected Bitmap getValue(Bucket<Bitmap> bucket) {
        Bitmap result = super.getValue(bucket);
        if (result != null) {
            result.eraseColor(0);
        }
        return result;
    }
}

