/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.transcoder;

import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.core.NativeCodeSetup;
import com.facebook.imagepipeline.nativecode.NativeImageTranscoderFactory;
import com.facebook.imagepipeline.transcoder.ImageTranscoder;
import com.facebook.imagepipeline.transcoder.ImageTranscoderFactory;
import com.facebook.imagepipeline.transcoder.SimpleImageTranscoderFactory;
import javax.annotation.Nullable;

public class MultiImageTranscoderFactory
implements ImageTranscoderFactory {
    private final int mMaxBitmapSize;
    private final boolean mUseDownSamplingRatio;
    @Nullable
    private final ImageTranscoderFactory mPrimaryImageTranscoderFactory;
    @Nullable
    private final Integer mImageTranscoderType;

    public MultiImageTranscoderFactory(int maxBitmapSize, boolean useDownSamplingRatio, @Nullable ImageTranscoderFactory primaryImageTranscoderFactory, @Nullable Integer imageTranscoderType) {
        this.mMaxBitmapSize = maxBitmapSize;
        this.mUseDownSamplingRatio = useDownSamplingRatio;
        this.mPrimaryImageTranscoderFactory = primaryImageTranscoderFactory;
        this.mImageTranscoderType = imageTranscoderType;
    }

    public ImageTranscoder createImageTranscoder(ImageFormat imageFormat, boolean isResizingEnabled) {
        ImageTranscoder imageTranscoder = this.getCustomImageTranscoder(imageFormat, isResizingEnabled);
        if (imageTranscoder == null) {
            imageTranscoder = this.getImageTranscoderWithType(imageFormat, isResizingEnabled);
        }
        if (imageTranscoder == null && NativeCodeSetup.getUseNativeCode()) {
            imageTranscoder = this.getNativeImageTranscoder(imageFormat, isResizingEnabled);
        }
        return imageTranscoder == null ? this.getSimpleImageTranscoder(imageFormat, isResizingEnabled) : imageTranscoder;
    }

    @Nullable
    private ImageTranscoder getCustomImageTranscoder(ImageFormat imageFormat, boolean isResizingEnabled) {
        if (this.mPrimaryImageTranscoderFactory == null) {
            return null;
        }
        return this.mPrimaryImageTranscoderFactory.createImageTranscoder(imageFormat, isResizingEnabled);
    }

    @Nullable
    private ImageTranscoder getNativeImageTranscoder(ImageFormat imageFormat, boolean isResizingEnabled) {
        return NativeImageTranscoderFactory.getNativeImageTranscoderFactory((int)this.mMaxBitmapSize, (boolean)this.mUseDownSamplingRatio).createImageTranscoder(imageFormat, isResizingEnabled);
    }

    private ImageTranscoder getSimpleImageTranscoder(ImageFormat imageFormat, boolean isResizingEnabled) {
        return new SimpleImageTranscoderFactory(this.mMaxBitmapSize).createImageTranscoder(imageFormat, isResizingEnabled);
    }

    @Nullable
    private ImageTranscoder getImageTranscoderWithType(ImageFormat imageFormat, boolean isResizingEnabled) {
        if (this.mImageTranscoderType == null) {
            return null;
        }
        switch (this.mImageTranscoderType) {
            case 0: {
                return this.getNativeImageTranscoder(imageFormat, isResizingEnabled);
            }
            case 1: {
                return this.getSimpleImageTranscoder(imageFormat, isResizingEnabled);
            }
        }
        throw new IllegalArgumentException("Invalid ImageTranscoderType");
    }
}

