/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.internal.Preconditions;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener2;
import com.facebook.imagepipeline.producers.StatefulProducerRunnable;
import com.facebook.imagepipeline.producers.ThreadHandoffProducerQueue;
import com.facebook.imagepipeline.systrace.FrescoSystrace;
import javax.annotation.Nullable;

public class ThreadHandoffProducer<T>
implements Producer<T> {
    public static final String PRODUCER_NAME = "BackgroundThreadHandoffProducer";
    private final Producer<T> mInputProducer;
    private final ThreadHandoffProducerQueue mThreadHandoffProducerQueue;

    public ThreadHandoffProducer(Producer<T> inputProducer, ThreadHandoffProducerQueue inputThreadHandoffProducerQueue) {
        this.mInputProducer = (Producer)Preconditions.checkNotNull(inputProducer);
        this.mThreadHandoffProducerQueue = inputThreadHandoffProducerQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void produceResults(final Consumer<T> consumer, final ProducerContext context) {
        try {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"ThreadHandoffProducer#produceResults");
            }
            final ProducerListener2 producerListener = context.getProducerListener();
            final StatefulProducerRunnable statefulRunnable = new StatefulProducerRunnable<T>(consumer, producerListener, context, PRODUCER_NAME){

                @Override
                protected void onSuccess(T ignored) {
                    producerListener.onProducerFinishWithSuccess(context, ThreadHandoffProducer.PRODUCER_NAME, null);
                    ThreadHandoffProducer.this.mInputProducer.produceResults(consumer, context);
                }

                @Override
                protected void disposeResult(T ignored) {
                }

                @Nullable
                protected T getResult() throws Exception {
                    return null;
                }
            };
            context.addCallbacks(new BaseProducerContextCallbacks(){

                @Override
                public void onCancellationRequested() {
                    statefulRunnable.cancel();
                    ThreadHandoffProducer.this.mThreadHandoffProducerQueue.remove((Runnable)((Object)statefulRunnable));
                }
            });
            this.mThreadHandoffProducerQueue.addToQueueOrExecute((Runnable)((Object)statefulRunnable));
        }
        finally {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
    }
}

