/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;
import com.facebook.common.memory.ByteArrayPool;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.ExceptionWithNoStacktrace;
import com.facebook.common.util.UriUtil;
import com.facebook.imageformat.DefaultImageFormats;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.common.RotationOptions;
import com.facebook.imagepipeline.core.CloseableReferenceFactory;
import com.facebook.imagepipeline.decoder.DecodeException;
import com.facebook.imagepipeline.decoder.ImageDecoder;
import com.facebook.imagepipeline.decoder.ProgressiveJpegConfig;
import com.facebook.imagepipeline.decoder.ProgressiveJpegParser;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.image.ImmutableQualityInfo;
import com.facebook.imagepipeline.image.OriginalEncodedImageInfo;
import com.facebook.imagepipeline.image.QualityInfo;
import com.facebook.imagepipeline.producers.BaseConsumer;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.JobScheduler;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener2;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.systrace.FrescoSystrace;
import com.facebook.imagepipeline.transcoder.DownsampleUtil;
import com.facebook.imageutils.BitmapUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class DecodeProducer
implements Producer<CloseableReference<CloseableImage>> {
    public static final String PRODUCER_NAME = "DecodeProducer";
    private static final int MAX_BITMAP_SIZE = 0x6400000;
    public static final String EXTRA_BITMAP_SIZE = "bitmapSize";
    public static final String EXTRA_HAS_GOOD_QUALITY = "hasGoodQuality";
    public static final String EXTRA_IS_FINAL = "isFinal";
    public static final String EXTRA_IMAGE_FORMAT_NAME = "imageFormat";
    public static final String EXTRA_BITMAP_BYTES = "byteCount";
    public static final String ENCODED_IMAGE_SIZE = "encodedImageSize";
    public static final String REQUESTED_IMAGE_SIZE = "requestedImageSize";
    public static final String SAMPLE_SIZE = "sampleSize";
    private final ByteArrayPool mByteArrayPool;
    private final Executor mExecutor;
    private final ImageDecoder mImageDecoder;
    private final ProgressiveJpegConfig mProgressiveJpegConfig;
    private final Producer<EncodedImage> mInputProducer;
    private final boolean mDownsampleEnabled;
    private final boolean mDownsampleEnabledForNetwork;
    private final boolean mDecodeCancellationEnabled;
    private final int mMaxBitmapSize;
    private final CloseableReferenceFactory mCloseableReferenceFactory;

    public DecodeProducer(ByteArrayPool byteArrayPool, Executor executor, ImageDecoder imageDecoder, ProgressiveJpegConfig progressiveJpegConfig, boolean downsampleEnabled, boolean downsampleEnabledForNetwork, boolean decodeCancellationEnabled, Producer<EncodedImage> inputProducer, int maxBitmapSize, CloseableReferenceFactory closeableReferenceFactory) {
        this.mByteArrayPool = (ByteArrayPool)Preconditions.checkNotNull((Object)byteArrayPool);
        this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.mImageDecoder = (ImageDecoder)Preconditions.checkNotNull((Object)imageDecoder);
        this.mProgressiveJpegConfig = (ProgressiveJpegConfig)Preconditions.checkNotNull((Object)progressiveJpegConfig);
        this.mDownsampleEnabled = downsampleEnabled;
        this.mDownsampleEnabledForNetwork = downsampleEnabledForNetwork;
        this.mInputProducer = (Producer)Preconditions.checkNotNull(inputProducer);
        this.mDecodeCancellationEnabled = decodeCancellationEnabled;
        this.mMaxBitmapSize = maxBitmapSize;
        this.mCloseableReferenceFactory = closeableReferenceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void produceResults(Consumer<CloseableReference<CloseableImage>> consumer, ProducerContext producerContext) {
        try {
            ProgressiveDecoder progressiveDecoder;
            ImageRequest imageRequest;
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"DecodeProducer#produceResults");
            }
            if (!UriUtil.isNetworkUri((Uri)(imageRequest = producerContext.getImageRequest()).getSourceUri())) {
                progressiveDecoder = new LocalImagesProgressiveDecoder(consumer, producerContext, this.mDecodeCancellationEnabled, this.mMaxBitmapSize);
            } else {
                ProgressiveJpegParser jpegParser = new ProgressiveJpegParser(this.mByteArrayPool);
                progressiveDecoder = new NetworkImagesProgressiveDecoder(consumer, producerContext, jpegParser, this.mProgressiveJpegConfig, this.mDecodeCancellationEnabled, this.mMaxBitmapSize);
            }
            this.mInputProducer.produceResults(progressiveDecoder, producerContext);
        }
        finally {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
    }

    private class NetworkImagesProgressiveDecoder
    extends ProgressiveDecoder {
        private final ProgressiveJpegParser mProgressiveJpegParser;
        private final ProgressiveJpegConfig mProgressiveJpegConfig;
        private int mLastScheduledScanNumber;

        public NetworkImagesProgressiveDecoder(Consumer<CloseableReference<CloseableImage>> consumer, ProducerContext producerContext, ProgressiveJpegParser progressiveJpegParser, ProgressiveJpegConfig progressiveJpegConfig, boolean decodeCancellationEnabled, int maxBitmapSize) {
            super(consumer, producerContext, decodeCancellationEnabled, maxBitmapSize);
            this.mProgressiveJpegParser = (ProgressiveJpegParser)Preconditions.checkNotNull((Object)progressiveJpegParser);
            this.mProgressiveJpegConfig = (ProgressiveJpegConfig)Preconditions.checkNotNull((Object)progressiveJpegConfig);
            this.mLastScheduledScanNumber = 0;
        }

        @Override
        protected synchronized boolean updateDecodeJob(EncodedImage encodedImage, int status) {
            boolean ret = super.updateDecodeJob(encodedImage, status);
            if ((NetworkImagesProgressiveDecoder.isNotLast(status) || NetworkImagesProgressiveDecoder.statusHasFlag(status, 8)) && !NetworkImagesProgressiveDecoder.statusHasFlag(status, 4) && EncodedImage.isValid((EncodedImage)encodedImage) && encodedImage.getImageFormat() == DefaultImageFormats.JPEG) {
                if (!this.mProgressiveJpegParser.parseMoreData(encodedImage)) {
                    return false;
                }
                int scanNum = this.mProgressiveJpegParser.getBestScanNumber();
                if (scanNum <= this.mLastScheduledScanNumber) {
                    return false;
                }
                if (scanNum < this.mProgressiveJpegConfig.getNextScanNumberToDecode(this.mLastScheduledScanNumber) && !this.mProgressiveJpegParser.isEndMarkerRead()) {
                    return false;
                }
                this.mLastScheduledScanNumber = scanNum;
            }
            return ret;
        }

        @Override
        protected int getIntermediateImageEndOffset(EncodedImage encodedImage) {
            return this.mProgressiveJpegParser.getBestScanEndOffset();
        }

        @Override
        protected QualityInfo getQualityInfo() {
            return this.mProgressiveJpegConfig.getQualityInfo(this.mProgressiveJpegParser.getBestScanNumber());
        }
    }

    private class LocalImagesProgressiveDecoder
    extends ProgressiveDecoder {
        public LocalImagesProgressiveDecoder(Consumer<CloseableReference<CloseableImage>> consumer, ProducerContext producerContext, boolean decodeCancellationEnabled, int maxBitmapSize) {
            super(consumer, producerContext, decodeCancellationEnabled, maxBitmapSize);
        }

        @Override
        protected synchronized boolean updateDecodeJob(EncodedImage encodedImage, int status) {
            if (LocalImagesProgressiveDecoder.isNotLast(status)) {
                return false;
            }
            return super.updateDecodeJob(encodedImage, status);
        }

        @Override
        protected int getIntermediateImageEndOffset(EncodedImage encodedImage) {
            return encodedImage.getSize();
        }

        @Override
        protected QualityInfo getQualityInfo() {
            return ImmutableQualityInfo.of((int)0, (boolean)false, (boolean)false);
        }
    }

    private abstract class ProgressiveDecoder
    extends DelegatingConsumer<EncodedImage, CloseableReference<CloseableImage>> {
        private final String TAG = "ProgressiveDecoder";
        private static final int DECODE_EXCEPTION_MESSAGE_NUM_HEADER_BYTES = 10;
        private final ProducerContext mProducerContext;
        private final ProducerListener2 mProducerListener;
        private final ImageDecodeOptions mImageDecodeOptions;
        @GuardedBy(value="this")
        private boolean mIsFinished;
        private final JobScheduler mJobScheduler;

        public ProgressiveDecoder(Consumer<CloseableReference<CloseableImage>> consumer, final ProducerContext producerContext, final boolean decodeCancellationEnabled, final int maxBitmapSize) {
            super(consumer);
            this.TAG = "ProgressiveDecoder";
            this.mProducerContext = producerContext;
            this.mProducerListener = producerContext.getProducerListener();
            this.mImageDecodeOptions = producerContext.getImageRequest().getImageDecodeOptions();
            this.mIsFinished = false;
            JobScheduler.JobRunnable job = new JobScheduler.JobRunnable(){

                @Override
                public void run(EncodedImage encodedImage, int status) {
                    if (encodedImage != null) {
                        if (DecodeProducer.this.mDownsampleEnabled || !BaseConsumer.statusHasFlag(status, 16)) {
                            ImageRequest request = producerContext.getImageRequest();
                            if (DecodeProducer.this.mDownsampleEnabledForNetwork || !UriUtil.isNetworkUri((Uri)request.getSourceUri())) {
                                encodedImage.setSampleSize(DownsampleUtil.determineSampleSize((RotationOptions)request.getRotationOptions(), (ResizeOptions)request.getResizeOptions(), (EncodedImage)encodedImage, (int)maxBitmapSize));
                            }
                        }
                        if (producerContext.getImagePipelineConfig().getExperiments().shouldDownsampleIfLargeBitmap()) {
                            ProgressiveDecoder.this.maybeIncreaseSampleSize(encodedImage);
                        }
                        ProgressiveDecoder.this.doDecode(encodedImage, status);
                    }
                }
            };
            this.mJobScheduler = new JobScheduler(DecodeProducer.this.mExecutor, job, this.mImageDecodeOptions.minDecodeIntervalMs);
            this.mProducerContext.addCallbacks(new BaseProducerContextCallbacks(){

                @Override
                public void onIsIntermediateResultExpectedChanged() {
                    if (ProgressiveDecoder.this.mProducerContext.isIntermediateResultExpected()) {
                        ProgressiveDecoder.this.mJobScheduler.scheduleJob();
                    }
                }

                @Override
                public void onCancellationRequested() {
                    if (decodeCancellationEnabled) {
                        ProgressiveDecoder.this.handleCancellation();
                    }
                }
            });
        }

        private void maybeIncreaseSampleSize(EncodedImage encodedImage) {
            if (encodedImage.getImageFormat() != DefaultImageFormats.JPEG) {
                return;
            }
            int pixelSize = BitmapUtil.getPixelSizeForBitmapConfig((Bitmap.Config)this.mImageDecodeOptions.bitmapConfig);
            int sampleSize = DownsampleUtil.determineSampleSizeJPEG((EncodedImage)encodedImage, (int)pixelSize, (int)0x6400000);
            encodedImage.setSampleSize(sampleSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNewResultImpl(EncodedImage newResult, int status) {
            try {
                boolean isLast;
                if (FrescoSystrace.isTracing()) {
                    FrescoSystrace.beginSection((String)"DecodeProducer#onNewResultImpl");
                }
                if (isLast = ProgressiveDecoder.isLast(status)) {
                    if (newResult == null) {
                        this.handleError((Throwable)new ExceptionWithNoStacktrace("Encoded image is null."));
                        return;
                    }
                    if (!newResult.isValid()) {
                        this.handleError((Throwable)new ExceptionWithNoStacktrace("Encoded image is not valid."));
                        return;
                    }
                }
                if (!this.updateDecodeJob(newResult, status)) {
                    return;
                }
                boolean isPlaceholder = ProgressiveDecoder.statusHasFlag(status, 4);
                if (isLast || isPlaceholder || this.mProducerContext.isIntermediateResultExpected()) {
                    this.mJobScheduler.scheduleJob();
                }
            }
            finally {
                if (FrescoSystrace.isTracing()) {
                    FrescoSystrace.endSection();
                }
            }
        }

        @Override
        protected void onProgressUpdateImpl(float progress) {
            super.onProgressUpdateImpl(progress * 0.99f);
        }

        @Override
        public void onFailureImpl(Throwable t) {
            this.handleError(t);
        }

        @Override
        public void onCancellationImpl() {
            this.handleCancellation();
        }

        protected boolean updateDecodeJob(EncodedImage ref, int status) {
            return this.mJobScheduler.updateJob(ref, status);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doDecode(EncodedImage encodedImage, int status) {
            if (encodedImage.getImageFormat() != DefaultImageFormats.JPEG && ProgressiveDecoder.isNotLast(status)) {
                return;
            }
            if (this.isFinished() || !EncodedImage.isValid((EncodedImage)encodedImage)) {
                return;
            }
            ImageFormat imageFormat = encodedImage.getImageFormat();
            String imageFormatStr = imageFormat != null ? imageFormat.getName() : "unknown";
            String encodedImageSize = encodedImage.getWidth() + "x" + encodedImage.getHeight();
            String sampleSize = String.valueOf(encodedImage.getSampleSize());
            boolean isLast = ProgressiveDecoder.isLast(status);
            boolean isLastAndComplete = isLast && !ProgressiveDecoder.statusHasFlag(status, 8);
            boolean isPlaceholder = ProgressiveDecoder.statusHasFlag(status, 4);
            ResizeOptions resizeOptions = this.mProducerContext.getImageRequest().getResizeOptions();
            String requestedSizeStr = resizeOptions != null ? resizeOptions.width + "x" + resizeOptions.height : "unknown";
            try {
                long queueTime = this.mJobScheduler.getQueuedTime();
                String requestUri = String.valueOf(this.mProducerContext.getImageRequest().getSourceUri());
                int length = isLastAndComplete || isPlaceholder ? encodedImage.getSize() : this.getIntermediateImageEndOffset(encodedImage);
                QualityInfo quality = isLastAndComplete || isPlaceholder ? ImmutableQualityInfo.FULL_QUALITY : this.getQualityInfo();
                this.mProducerListener.onProducerStart(this.mProducerContext, DecodeProducer.PRODUCER_NAME);
                CloseableImage image = null;
                try {
                    try {
                        image = DecodeProducer.this.mImageDecoder.decode(encodedImage, length, quality, this.mImageDecodeOptions);
                    }
                    catch (DecodeException e) {
                        EncodedImage failedEncodedImage = e.getEncodedImage();
                        FLog.w((String)"ProgressiveDecoder", (String)"%s, {uri: %s, firstEncodedBytes: %s, length: %d}", (Object[])new Object[]{e.getMessage(), requestUri, failedEncodedImage.getFirstBytesAsHexString(10), failedEncodedImage.getSize()});
                        throw e;
                    }
                    if (encodedImage.getSampleSize() != 1) {
                        status |= 0x10;
                    }
                }
                catch (Exception e) {
                    Map<String, String> extraMap = this.getExtraMap(image, queueTime, quality, isLast, imageFormatStr, encodedImageSize, requestedSizeStr, sampleSize);
                    this.mProducerListener.onProducerFinishWithFailure(this.mProducerContext, DecodeProducer.PRODUCER_NAME, e, extraMap);
                    this.handleError(e);
                    EncodedImage.closeSafely((EncodedImage)encodedImage);
                    return;
                }
                Map<String, String> extraMap = this.getExtraMap(image, queueTime, quality, isLast, imageFormatStr, encodedImageSize, requestedSizeStr, sampleSize);
                this.mProducerListener.onProducerFinishWithSuccess(this.mProducerContext, DecodeProducer.PRODUCER_NAME, extraMap);
                if (image != null) {
                    image.setOriginalEncodedImageInfo(new OriginalEncodedImageInfo(this.mProducerContext.getImageRequest().getSourceUri(), this.mProducerContext.getEncodedImageOrigin(), this.mProducerContext.getCallerContext(), encodedImage.getWidth(), encodedImage.getHeight(), encodedImage.getSize()));
                }
                this.handleResult(image, status);
            }
            finally {
                EncodedImage.closeSafely((EncodedImage)encodedImage);
            }
        }

        @Nullable
        private Map<String, String> getExtraMap(@Nullable CloseableImage image, long queueTime, QualityInfo quality, boolean isFinal, String imageFormatName, String encodedImageSize, String requestImageSize, String sampleSize) {
            if (!this.mProducerListener.requiresExtraMap(this.mProducerContext, DecodeProducer.PRODUCER_NAME)) {
                return null;
            }
            String queueStr = String.valueOf(queueTime);
            String qualityStr = String.valueOf(quality.isOfGoodEnoughQuality());
            String finalStr = String.valueOf(isFinal);
            if (image instanceof CloseableStaticBitmap) {
                Bitmap bitmap = ((CloseableStaticBitmap)image).getUnderlyingBitmap();
                String sizeStr = bitmap.getWidth() + "x" + bitmap.getHeight();
                HashMap<String, String> tmpMap = new HashMap<String, String>(8);
                tmpMap.put(DecodeProducer.EXTRA_BITMAP_SIZE, sizeStr);
                tmpMap.put("queueTime", queueStr);
                tmpMap.put(DecodeProducer.EXTRA_HAS_GOOD_QUALITY, qualityStr);
                tmpMap.put(DecodeProducer.EXTRA_IS_FINAL, finalStr);
                tmpMap.put(DecodeProducer.ENCODED_IMAGE_SIZE, encodedImageSize);
                tmpMap.put(DecodeProducer.EXTRA_IMAGE_FORMAT_NAME, imageFormatName);
                tmpMap.put(DecodeProducer.REQUESTED_IMAGE_SIZE, requestImageSize);
                tmpMap.put(DecodeProducer.SAMPLE_SIZE, sampleSize);
                if (Build.VERSION.SDK_INT >= 12) {
                    tmpMap.put(DecodeProducer.EXTRA_BITMAP_BYTES, bitmap.getByteCount() + "");
                }
                return ImmutableMap.copyOf(tmpMap);
            }
            HashMap<String, String> tmpMap = new HashMap<String, String>(7);
            tmpMap.put("queueTime", queueStr);
            tmpMap.put(DecodeProducer.EXTRA_HAS_GOOD_QUALITY, qualityStr);
            tmpMap.put(DecodeProducer.EXTRA_IS_FINAL, finalStr);
            tmpMap.put(DecodeProducer.ENCODED_IMAGE_SIZE, encodedImageSize);
            tmpMap.put(DecodeProducer.EXTRA_IMAGE_FORMAT_NAME, imageFormatName);
            tmpMap.put(DecodeProducer.REQUESTED_IMAGE_SIZE, requestImageSize);
            tmpMap.put(DecodeProducer.SAMPLE_SIZE, sampleSize);
            return ImmutableMap.copyOf(tmpMap);
        }

        private synchronized boolean isFinished() {
            return this.mIsFinished;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeFinish(boolean shouldFinish) {
            ProgressiveDecoder progressiveDecoder = this;
            synchronized (progressiveDecoder) {
                if (!shouldFinish || this.mIsFinished) {
                    return;
                }
                this.getConsumer().onProgressUpdate(1.0f);
                this.mIsFinished = true;
            }
            this.mJobScheduler.clearJob();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleResult(CloseableImage decodedImage, int status) {
            CloseableReference<CloseableImage> decodedImageRef = DecodeProducer.this.mCloseableReferenceFactory.create(decodedImage);
            try {
                this.maybeFinish(ProgressiveDecoder.isLast(status));
                this.getConsumer().onNewResult(decodedImageRef, status);
            }
            finally {
                CloseableReference.closeSafely(decodedImageRef);
            }
        }

        private void handleError(Throwable t) {
            this.maybeFinish(true);
            this.getConsumer().onFailure(t);
        }

        private void handleCancellation() {
            this.maybeFinish(true);
            this.getConsumer().onCancellation();
        }

        protected abstract int getIntermediateImageEndOffset(EncodedImage var1);

        protected abstract QualityInfo getQualityInfo();
    }
}

