/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.multiuri;

import com.facebook.common.internal.Supplier;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSources;
import com.facebook.datasource.FirstAvailableDataSourceSupplier;
import com.facebook.datasource.IncreasingQualityDataSourceSupplier;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.listener.RequestListener;
import com.facebook.imagepipeline.request.ImageRequest;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.annotation.Nullable;

public class MultiUri {
    @Nullable
    private ImageRequest mLowResImageRequest;
    @Nullable
    private ImageRequest[] mMultiImageRequests;
    private static final NullPointerException NO_REQUEST_EXCEPTION = new NullPointerException("No image request was specified!");

    private MultiUri(Builder builder) {
        this.mLowResImageRequest = builder.mLowResImageRequest;
        this.mMultiImageRequests = builder.mMultiImageRequests;
    }

    @Nullable
    public ImageRequest getLowResImageRequest() {
        return this.mLowResImageRequest;
    }

    @Nullable
    public ImageRequest[] getMultiImageRequests() {
        return this.mMultiImageRequests;
    }

    public static Builder create() {
        return new Builder();
    }

    public static Supplier<DataSource<CloseableReference<CloseableImage>>> getMultiUriDatasource(ImagePipeline imagePipeline, ImageRequest lowResImageRequest, ImageRequest mainImageRequest, Object callerContext) {
        MultiUri multiUri = MultiUri.create().setLowResImageRequest(lowResImageRequest).setImageRequests(mainImageRequest).build();
        return MultiUri.getMultiUriDatasourceSupplier(imagePipeline, multiUri, null, callerContext, null, null);
    }

    public static Supplier<DataSource<CloseableReference<CloseableImage>>> getMultiUriDatasourceSupplier(ImagePipeline imagePipeline, MultiUri multiUri, @Nullable ImageRequest imageRequest, Object callerContext, @Nullable RequestListener requestListener, @Nullable String id) {
        IncreasingQualityDataSourceSupplier supplier = null;
        if (imageRequest != null) {
            supplier = MultiUri.getImageRequestDataSourceSupplier(imagePipeline, imageRequest, callerContext, requestListener, id);
        } else if (multiUri.getMultiImageRequests() != null) {
            supplier = MultiUri.getFirstAvailableDataSourceSupplier(imagePipeline, callerContext, requestListener, multiUri.getMultiImageRequests(), true, id);
        }
        if (supplier != null && multiUri.getLowResImageRequest() != null) {
            LinkedList<Object> suppliers = new LinkedList<Object>();
            suppliers.add(supplier);
            suppliers.add(MultiUri.getImageRequestDataSourceSupplier(imagePipeline, multiUri.getLowResImageRequest(), callerContext, requestListener, id));
            supplier = IncreasingQualityDataSourceSupplier.create(suppliers, (boolean)false);
        }
        if (supplier == null) {
            supplier = DataSources.getFailedDataSourceSupplier((Throwable)NO_REQUEST_EXCEPTION);
        }
        return supplier;
    }

    public static DataSource<CloseableReference<CloseableImage>> getImageRequestDataSource(ImagePipeline imagePipeline, ImageRequest imageRequest, Object callerContext, @Nullable RequestListener requestListener, @Nullable String uiComponentId) {
        return imagePipeline.fetchDecodedImage(imageRequest, callerContext, ImageRequest.RequestLevel.FULL_FETCH, requestListener, uiComponentId);
    }

    private static Supplier<DataSource<CloseableReference<CloseableImage>>> getFirstAvailableDataSourceSupplier(ImagePipeline imagePipeline, Object callerContext, @Nullable RequestListener requestListener, ImageRequest[] imageRequests, boolean tryBitmapCacheOnlyFirst, @Nullable String uiComponentId) {
        int i;
        ArrayList<Supplier<DataSource<CloseableReference<CloseableImage>>>> suppliers = new ArrayList<Supplier<DataSource<CloseableReference<CloseableImage>>>>(imageRequests.length * 2);
        if (tryBitmapCacheOnlyFirst) {
            for (i = 0; i < imageRequests.length; ++i) {
                suppliers.add(MultiUri.getImageRequestDataSourceSupplier(imagePipeline, imageRequests[i], callerContext, ImageRequest.RequestLevel.BITMAP_MEMORY_CACHE, requestListener, uiComponentId));
            }
        }
        for (i = 0; i < imageRequests.length; ++i) {
            suppliers.add(MultiUri.getImageRequestDataSourceSupplier(imagePipeline, imageRequests[i], callerContext, requestListener, uiComponentId));
        }
        return FirstAvailableDataSourceSupplier.create(suppliers);
    }

    private static Supplier<DataSource<CloseableReference<CloseableImage>>> getImageRequestDataSourceSupplier(final ImagePipeline imagePipeline, final ImageRequest imageRequest, final Object callerContext, ImageRequest.RequestLevel requestLevel, final RequestListener requestListener, final @Nullable String uiComponentId) {
        return new Supplier<DataSource<CloseableReference<CloseableImage>>>(){

            public DataSource<CloseableReference<CloseableImage>> get() {
                return MultiUri.getImageRequestDataSource(imagePipeline, imageRequest, callerContext, requestListener, uiComponentId);
            }
        };
    }

    private static Supplier<DataSource<CloseableReference<CloseableImage>>> getImageRequestDataSourceSupplier(ImagePipeline imagePipeline, ImageRequest imageRequest, Object callerContext, RequestListener requestListener, @Nullable String uiComponentId) {
        return MultiUri.getImageRequestDataSourceSupplier(imagePipeline, imageRequest, callerContext, ImageRequest.RequestLevel.FULL_FETCH, requestListener, uiComponentId);
    }

    public static class Builder {
        @Nullable
        private ImageRequest mLowResImageRequest;
        @Nullable
        private ImageRequest[] mMultiImageRequests;

        private Builder() {
        }

        public MultiUri build() {
            return new MultiUri(this);
        }

        public Builder setLowResImageRequest(@Nullable ImageRequest lowResImageRequest) {
            this.mLowResImageRequest = lowResImageRequest;
            return this;
        }

        public Builder setImageRequests(ImageRequest ... multiImageRequests) {
            this.mMultiImageRequests = multiImageRequests;
            return this;
        }
    }
}

