/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import android.os.Build;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;
import com.facebook.common.memory.ByteArrayPool;
import com.facebook.common.memory.MemoryTrimmableRegistry;
import com.facebook.common.memory.PooledByteBufferFactory;
import com.facebook.common.memory.PooledByteStreams;
import com.facebook.imagepipeline.memory.BitmapPool;
import com.facebook.imagepipeline.memory.BucketsBitmapPool;
import com.facebook.imagepipeline.memory.DefaultBitmapPoolParams;
import com.facebook.imagepipeline.memory.DummyBitmapPool;
import com.facebook.imagepipeline.memory.DummyTrackingInUseBitmapPool;
import com.facebook.imagepipeline.memory.FlexByteArrayPool;
import com.facebook.imagepipeline.memory.GenericByteArrayPool;
import com.facebook.imagepipeline.memory.LruBitmapPool;
import com.facebook.imagepipeline.memory.MemoryChunkPool;
import com.facebook.imagepipeline.memory.MemoryPooledByteBufferFactory;
import com.facebook.imagepipeline.memory.NoOpPoolStatsTracker;
import com.facebook.imagepipeline.memory.PoolConfig;
import com.facebook.imagepipeline.memory.PoolParams;
import com.facebook.imagepipeline.memory.PoolStatsTracker;
import com.facebook.imagepipeline.memory.SharedByteArray;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PoolFactory {
    private final PoolConfig mConfig;
    @Nullable
    private MemoryChunkPool mAshmemMemoryChunkPool;
    private BitmapPool mBitmapPool;
    @Nullable
    private MemoryChunkPool mBufferMemoryChunkPool;
    private FlexByteArrayPool mFlexByteArrayPool;
    @Nullable
    private MemoryChunkPool mNativeMemoryChunkPool;
    private PooledByteBufferFactory mPooledByteBufferFactory;
    private PooledByteStreams mPooledByteStreams;
    private SharedByteArray mSharedByteArray;
    private ByteArrayPool mSmallByteArrayPool;

    public PoolFactory(PoolConfig config) {
        this.mConfig = (PoolConfig)Preconditions.checkNotNull((Object)config);
    }

    public BitmapPool getBitmapPool() {
        if (this.mBitmapPool == null) {
            String bitmapPoolType;
            switch (bitmapPoolType = this.mConfig.getBitmapPoolType()) {
                case "dummy": {
                    this.mBitmapPool = new DummyBitmapPool();
                    break;
                }
                case "dummy_with_tracking": {
                    this.mBitmapPool = new DummyTrackingInUseBitmapPool();
                    break;
                }
                case "experimental": {
                    this.mBitmapPool = new LruBitmapPool(this.mConfig.getBitmapPoolMaxPoolSize(), this.mConfig.getBitmapPoolMaxBitmapSize(), NoOpPoolStatsTracker.getInstance(), this.mConfig.isRegisterLruBitmapPoolAsMemoryTrimmable() ? this.mConfig.getMemoryTrimmableRegistry() : null);
                    break;
                }
                case "legacy_default_params": {
                    this.mBitmapPool = new BucketsBitmapPool(this.mConfig.getMemoryTrimmableRegistry(), DefaultBitmapPoolParams.get(), this.mConfig.getBitmapPoolStatsTracker());
                    break;
                }
                default: {
                    this.mBitmapPool = Build.VERSION.SDK_INT >= 21 ? new BucketsBitmapPool(this.mConfig.getMemoryTrimmableRegistry(), this.mConfig.getBitmapPoolParams(), this.mConfig.getBitmapPoolStatsTracker()) : new DummyBitmapPool();
                }
            }
        }
        return this.mBitmapPool;
    }

    @Nullable
    public MemoryChunkPool getBufferMemoryChunkPool() {
        if (this.mBufferMemoryChunkPool == null) {
            try {
                Class<?> clazz = Class.forName("com.facebook.imagepipeline.memory.BufferMemoryChunkPool");
                Constructor<?> cons = clazz.getConstructor(MemoryTrimmableRegistry.class, PoolParams.class, PoolStatsTracker.class);
                this.mBufferMemoryChunkPool = (MemoryChunkPool)cons.newInstance(this.mConfig.getMemoryTrimmableRegistry(), this.mConfig.getMemoryChunkPoolParams(), this.mConfig.getMemoryChunkPoolStatsTracker());
            }
            catch (ClassNotFoundException e) {
                this.mBufferMemoryChunkPool = null;
            }
            catch (IllegalAccessException e) {
                this.mBufferMemoryChunkPool = null;
            }
            catch (InstantiationException e) {
                this.mBufferMemoryChunkPool = null;
            }
            catch (NoSuchMethodException e) {
                this.mBufferMemoryChunkPool = null;
            }
            catch (InvocationTargetException e) {
                this.mBufferMemoryChunkPool = null;
            }
        }
        return this.mBufferMemoryChunkPool;
    }

    public FlexByteArrayPool getFlexByteArrayPool() {
        if (this.mFlexByteArrayPool == null) {
            this.mFlexByteArrayPool = new FlexByteArrayPool(this.mConfig.getMemoryTrimmableRegistry(), this.mConfig.getFlexByteArrayPoolParams());
        }
        return this.mFlexByteArrayPool;
    }

    public int getFlexByteArrayPoolMaxNumThreads() {
        return this.mConfig.getFlexByteArrayPoolParams().maxNumThreads;
    }

    @Nullable
    public MemoryChunkPool getNativeMemoryChunkPool() {
        if (this.mNativeMemoryChunkPool == null) {
            try {
                Class<?> clazz = Class.forName("com.facebook.imagepipeline.memory.NativeMemoryChunkPool");
                Constructor<?> cons = clazz.getConstructor(MemoryTrimmableRegistry.class, PoolParams.class, PoolStatsTracker.class);
                this.mNativeMemoryChunkPool = (MemoryChunkPool)cons.newInstance(this.mConfig.getMemoryTrimmableRegistry(), this.mConfig.getMemoryChunkPoolParams(), this.mConfig.getMemoryChunkPoolStatsTracker());
            }
            catch (ClassNotFoundException e) {
                FLog.e((String)"PoolFactory", (String)"", (Throwable)e);
                this.mNativeMemoryChunkPool = null;
            }
            catch (IllegalAccessException e) {
                FLog.e((String)"PoolFactory", (String)"", (Throwable)e);
                this.mNativeMemoryChunkPool = null;
            }
            catch (InstantiationException e) {
                FLog.e((String)"PoolFactory", (String)"", (Throwable)e);
                this.mNativeMemoryChunkPool = null;
            }
            catch (NoSuchMethodException e) {
                FLog.e((String)"PoolFactory", (String)"", (Throwable)e);
                this.mNativeMemoryChunkPool = null;
            }
            catch (InvocationTargetException e) {
                FLog.e((String)"PoolFactory", (String)"", (Throwable)e);
                this.mNativeMemoryChunkPool = null;
            }
        }
        return this.mNativeMemoryChunkPool;
    }

    @Nullable
    private MemoryChunkPool getAshmemMemoryChunkPool() {
        if (this.mAshmemMemoryChunkPool == null) {
            try {
                Class<?> clazz = Class.forName("com.facebook.imagepipeline.memory.AshmemMemoryChunkPool");
                Constructor<?> cons = clazz.getConstructor(MemoryTrimmableRegistry.class, PoolParams.class, PoolStatsTracker.class);
                this.mAshmemMemoryChunkPool = (MemoryChunkPool)cons.newInstance(this.mConfig.getMemoryTrimmableRegistry(), this.mConfig.getMemoryChunkPoolParams(), this.mConfig.getMemoryChunkPoolStatsTracker());
            }
            catch (ClassNotFoundException e) {
                this.mAshmemMemoryChunkPool = null;
            }
            catch (IllegalAccessException e) {
                this.mAshmemMemoryChunkPool = null;
            }
            catch (InstantiationException e) {
                this.mAshmemMemoryChunkPool = null;
            }
            catch (NoSuchMethodException e) {
                this.mAshmemMemoryChunkPool = null;
            }
            catch (InvocationTargetException e) {
                this.mAshmemMemoryChunkPool = null;
            }
        }
        return this.mAshmemMemoryChunkPool;
    }

    public PooledByteBufferFactory getPooledByteBufferFactory() {
        return this.getPooledByteBufferFactory(0);
    }

    public PooledByteBufferFactory getPooledByteBufferFactory(int memoryChunkType) {
        if (this.mPooledByteBufferFactory == null) {
            MemoryChunkPool memoryChunkPool = this.getMemoryChunkPool(memoryChunkType);
            Preconditions.checkNotNull((Object)memoryChunkPool, (Object)("failed to get pool for chunk type: " + memoryChunkType));
            this.mPooledByteBufferFactory = new MemoryPooledByteBufferFactory(this.getMemoryChunkPool(memoryChunkType), this.getPooledByteStreams());
        }
        return this.mPooledByteBufferFactory;
    }

    public PooledByteStreams getPooledByteStreams() {
        if (this.mPooledByteStreams == null) {
            this.mPooledByteStreams = new PooledByteStreams(this.getSmallByteArrayPool());
        }
        return this.mPooledByteStreams;
    }

    public SharedByteArray getSharedByteArray() {
        if (this.mSharedByteArray == null) {
            this.mSharedByteArray = new SharedByteArray(this.mConfig.getMemoryTrimmableRegistry(), this.mConfig.getFlexByteArrayPoolParams());
        }
        return this.mSharedByteArray;
    }

    public ByteArrayPool getSmallByteArrayPool() {
        if (this.mSmallByteArrayPool == null) {
            this.mSmallByteArrayPool = new GenericByteArrayPool(this.mConfig.getMemoryTrimmableRegistry(), this.mConfig.getSmallByteArrayPoolParams(), this.mConfig.getSmallByteArrayPoolStatsTracker());
        }
        return this.mSmallByteArrayPool;
    }

    @Nullable
    private MemoryChunkPool getMemoryChunkPool(int memoryChunkType) {
        switch (memoryChunkType) {
            case 0: {
                return this.getNativeMemoryChunkPool();
            }
            case 1: {
                return this.getBufferMemoryChunkPool();
            }
            case 2: {
                return this.getAshmemMemoryChunkPool();
            }
        }
        throw new IllegalArgumentException("Invalid MemoryChunkType");
    }
}

