/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.memory.PooledByteBufferOutputStream;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imagepipeline.memory.MemoryChunk;
import com.facebook.imagepipeline.memory.MemoryChunkPool;
import com.facebook.imagepipeline.memory.MemoryPooledByteBuffer;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MemoryPooledByteBufferOutputStream
extends PooledByteBufferOutputStream {
    private final MemoryChunkPool mPool;
    private CloseableReference<MemoryChunk> mBufRef;
    private int mCount;

    public MemoryPooledByteBufferOutputStream(MemoryChunkPool pool) {
        this(pool, pool.getMinBufferSize());
    }

    public MemoryPooledByteBufferOutputStream(MemoryChunkPool pool, int initialCapacity) {
        Preconditions.checkArgument((initialCapacity > 0 ? 1 : 0) != 0);
        this.mPool = (MemoryChunkPool)Preconditions.checkNotNull((Object)pool);
        this.mCount = 0;
        this.mBufRef = CloseableReference.of(this.mPool.get(initialCapacity), (ResourceReleaser)this.mPool);
    }

    public MemoryPooledByteBuffer toByteBuffer() {
        this.ensureValid();
        return new MemoryPooledByteBuffer(this.mBufRef, this.mCount);
    }

    public int size() {
        return this.mCount;
    }

    public void write(int oneByte) throws IOException {
        byte[] buf = new byte[]{(byte)oneByte};
        this.write(buf);
    }

    public void write(byte[] buffer, int offset, int count) throws IOException {
        if (offset < 0 || count < 0 || offset + count > buffer.length) {
            throw new ArrayIndexOutOfBoundsException("length=" + buffer.length + "; regionStart=" + offset + "; regionLength=" + count);
        }
        this.ensureValid();
        this.realloc(this.mCount + count);
        ((MemoryChunk)this.mBufRef.get()).write(this.mCount, buffer, offset, count);
        this.mCount += count;
    }

    public void close() {
        CloseableReference.closeSafely(this.mBufRef);
        this.mBufRef = null;
        this.mCount = -1;
        super.close();
    }

    @VisibleForTesting
    void realloc(int newLength) {
        this.ensureValid();
        if (newLength <= ((MemoryChunk)this.mBufRef.get()).getSize()) {
            return;
        }
        MemoryChunk newbuf = (MemoryChunk)this.mPool.get(newLength);
        ((MemoryChunk)this.mBufRef.get()).copy(0, newbuf, 0, this.mCount);
        this.mBufRef.close();
        this.mBufRef = CloseableReference.of((Object)newbuf, (ResourceReleaser)this.mPool);
    }

    private void ensureValid() {
        if (!CloseableReference.isValid(this.mBufRef)) {
            throw new InvalidStreamException();
        }
    }

    public static class InvalidStreamException
    extends RuntimeException {
        public InvalidStreamException() {
            super("OutputStream no longer valid");
        }
    }
}

