/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.memory.PooledByteBufferFactory;
import com.facebook.common.memory.PooledByteStreams;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imagepipeline.memory.MemoryChunk;
import com.facebook.imagepipeline.memory.MemoryChunkPool;
import com.facebook.imagepipeline.memory.MemoryPooledByteBuffer;
import com.facebook.imagepipeline.memory.MemoryPooledByteBufferOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MemoryPooledByteBufferFactory
implements PooledByteBufferFactory {
    private final PooledByteStreams mPooledByteStreams;
    private final MemoryChunkPool mPool;

    public MemoryPooledByteBufferFactory(MemoryChunkPool pool, PooledByteStreams pooledByteStreams) {
        this.mPool = pool;
        this.mPooledByteStreams = pooledByteStreams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryPooledByteBuffer newByteBuffer(int size) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0);
        try (CloseableReference chunkRef = CloseableReference.of(this.mPool.get(size), (ResourceReleaser)this.mPool);){
            MemoryPooledByteBuffer memoryPooledByteBuffer = new MemoryPooledByteBuffer((CloseableReference<MemoryChunk>)chunkRef, size);
            return memoryPooledByteBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryPooledByteBuffer newByteBuffer(InputStream inputStream) throws IOException {
        try (MemoryPooledByteBufferOutputStream outputStream = new MemoryPooledByteBufferOutputStream(this.mPool);){
            MemoryPooledByteBuffer memoryPooledByteBuffer = this.newByteBuf(inputStream, outputStream);
            return memoryPooledByteBuffer;
        }
    }

    public MemoryPooledByteBuffer newByteBuffer(byte[] bytes) {
        try (MemoryPooledByteBufferOutputStream outputStream = new MemoryPooledByteBufferOutputStream(this.mPool, bytes.length);){
            outputStream.write(bytes, 0, bytes.length);
            MemoryPooledByteBuffer memoryPooledByteBuffer = outputStream.toByteBuffer();
            return memoryPooledByteBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryPooledByteBuffer newByteBuffer(InputStream inputStream, int initialCapacity) throws IOException {
        try (MemoryPooledByteBufferOutputStream outputStream = new MemoryPooledByteBufferOutputStream(this.mPool, initialCapacity);){
            MemoryPooledByteBuffer memoryPooledByteBuffer = this.newByteBuf(inputStream, outputStream);
            return memoryPooledByteBuffer;
        }
    }

    @VisibleForTesting
    MemoryPooledByteBuffer newByteBuf(InputStream inputStream, MemoryPooledByteBufferOutputStream outputStream) throws IOException {
        this.mPooledByteStreams.copy(inputStream, (OutputStream)((Object)outputStream));
        return outputStream.toByteBuffer();
    }

    public MemoryPooledByteBufferOutputStream newOutputStream() {
        return new MemoryPooledByteBufferOutputStream(this.mPool);
    }

    public MemoryPooledByteBufferOutputStream newOutputStream(int initialCapacity) {
        return new MemoryPooledByteBufferOutputStream(this.mPool, initialCapacity);
    }
}

