/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imageutils;

import com.facebook.common.internal.Preconditions;
import com.facebook.imageutils.StreamProcessor;
import com.facebook.imageutils.TiffUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class JfifUtil {
    public static final int MARKER_FIRST_BYTE = 255;
    public static final int MARKER_ESCAPE_BYTE = 0;
    public static final int MARKER_SOI = 216;
    public static final int MARKER_TEM = 1;
    public static final int MARKER_EOI = 217;
    public static final int MARKER_SOS = 218;
    public static final int MARKER_APP1 = 225;
    public static final int MARKER_SOFn = 192;
    public static final int MARKER_RST0 = 208;
    public static final int MARKER_RST7 = 215;
    public static final int APP1_EXIF_MAGIC = 1165519206;

    private JfifUtil() {
    }

    public static int getAutoRotateAngleFromOrientation(int orientation) {
        return TiffUtil.getAutoRotateAngleFromOrientation(orientation);
    }

    public static int getOrientation(byte[] jpeg) {
        return JfifUtil.getOrientation(new ByteArrayInputStream(jpeg));
    }

    public static int getOrientation(InputStream is) {
        try {
            int length = JfifUtil.moveToAPP1EXIF(is);
            if (length == 0) {
                return 0;
            }
            return TiffUtil.readOrientationFromTIFF(is, length);
        }
        catch (IOException ioe) {
            return 0;
        }
    }

    public static boolean moveToMarker(InputStream is, int markerToFind) throws IOException {
        Preconditions.checkNotNull((Object)is);
        while (StreamProcessor.readPackedInt(is, 1, false) == 255) {
            int marker = 255;
            while (marker == 255) {
                marker = StreamProcessor.readPackedInt(is, 1, false);
            }
            if (markerToFind == 192 && JfifUtil.isSOFn(marker)) {
                return true;
            }
            if (marker == markerToFind) {
                return true;
            }
            if (marker == 216 || marker == 1) continue;
            if (marker == 217 || marker == 218) {
                return false;
            }
            int length = StreamProcessor.readPackedInt(is, 2, false) - 2;
            is.skip(length);
        }
        return false;
    }

    private static boolean isSOFn(int marker) {
        switch (marker) {
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 197: 
            case 198: 
            case 199: 
            case 201: 
            case 202: 
            case 203: 
            case 205: 
            case 206: 
            case 207: {
                return true;
            }
        }
        return false;
    }

    private static int moveToAPP1EXIF(InputStream is) throws IOException {
        int length;
        if (JfifUtil.moveToMarker(is, 225) && (length = StreamProcessor.readPackedInt(is, 2, false) - 2) > 6) {
            int magic = StreamProcessor.readPackedInt(is, 4, false);
            length -= 4;
            int zero = StreamProcessor.readPackedInt(is, 2, false);
            length -= 2;
            if (magic == 1165519206 && zero == 0) {
                return length;
            }
        }
        return 0;
    }
}

