/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import android.net.Uri;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.SimpleCacheKey;
import com.facebook.imagepipeline.cache.BitmapMemoryCacheKey;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.Postprocessor;

public class DefaultCacheKeyFactory
implements CacheKeyFactory {
    private static DefaultCacheKeyFactory sInstance = null;

    protected DefaultCacheKeyFactory() {
    }

    public static synchronized DefaultCacheKeyFactory getInstance() {
        if (sInstance == null) {
            sInstance = new DefaultCacheKeyFactory();
        }
        return sInstance;
    }

    @Override
    public CacheKey getBitmapCacheKey(ImageRequest request) {
        return new BitmapMemoryCacheKey(this.getCacheKeySourceUri(request.getSourceUri()).toString(), request.getResizeOptions(), request.getAutoRotateEnabled(), request.getImageDecodeOptions(), null, null);
    }

    @Override
    public CacheKey getPostprocessedBitmapCacheKey(ImageRequest request) {
        String postprocessorName;
        CacheKey postprocessorCacheKey;
        Postprocessor postprocessor = request.getPostprocessor();
        if (postprocessor != null) {
            postprocessorCacheKey = postprocessor.getPostprocessorCacheKey();
            postprocessorName = postprocessor.getClass().getName();
        } else {
            postprocessorCacheKey = null;
            postprocessorName = null;
        }
        return new BitmapMemoryCacheKey(this.getCacheKeySourceUri(request.getSourceUri()).toString(), request.getResizeOptions(), request.getAutoRotateEnabled(), request.getImageDecodeOptions(), postprocessorCacheKey, postprocessorName);
    }

    @Override
    public CacheKey getEncodedCacheKey(ImageRequest request) {
        return new SimpleCacheKey(this.getCacheKeySourceUri(request.getSourceUri()).toString());
    }

    @Override
    public Uri getCacheKeySourceUri(Uri sourceUri) {
        return sourceUri;
    }
}

