/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.graphics.Rect;
import android.media.ExifInterface;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.memory.PooledByteBufferInputStream;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.producers.StatefulProducerRunnable;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imageutils.JfifUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;

public class LocalExifThumbnailProducer
implements Producer<EncodedImage> {
    @VisibleForTesting
    static final String PRODUCER_NAME = "LocalExifThumbnailProducer";
    @VisibleForTesting
    static final String CREATED_THUMBNAIL = "createdThumbnail";
    private final Executor mExecutor;
    private final PooledByteBufferFactory mPooledByteBufferFactory;

    public LocalExifThumbnailProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory) {
        this.mExecutor = executor;
        this.mPooledByteBufferFactory = pooledByteBufferFactory;
    }

    @Override
    public void produceResults(Consumer<EncodedImage> consumer, ProducerContext producerContext) {
        ProducerListener listener = producerContext.getListener();
        String requestId = producerContext.getId();
        final ImageRequest imageRequest = producerContext.getImageRequest();
        final StatefulProducerRunnable<EncodedImage> cancellableProducerRunnable = new StatefulProducerRunnable<EncodedImage>(consumer, listener, PRODUCER_NAME, requestId){

            protected EncodedImage getResult() throws Exception {
                ExifInterface exifInterface = LocalExifThumbnailProducer.this.getExifInterface(imageRequest.getSourceFile().getPath());
                if (!exifInterface.hasThumbnail()) {
                    return null;
                }
                byte[] bytes = exifInterface.getThumbnail();
                PooledByteBuffer pooledByteBuffer = LocalExifThumbnailProducer.this.mPooledByteBufferFactory.newByteBuffer(bytes);
                return LocalExifThumbnailProducer.this.buildEncodedImage(pooledByteBuffer, exifInterface);
            }

            @Override
            protected void disposeResult(EncodedImage result) {
                EncodedImage.closeSafely(result);
            }

            @Override
            protected Map<String, String> getExtraMapOnSuccess(EncodedImage result) {
                return ImmutableMap.of((Object)LocalExifThumbnailProducer.CREATED_THUMBNAIL, (Object)Boolean.toString(result != null));
            }
        };
        producerContext.addCallbacks(new BaseProducerContextCallbacks(){

            @Override
            public void onCancellationRequested() {
                cancellableProducerRunnable.cancel();
            }
        });
        this.mExecutor.execute((Runnable)((Object)cancellableProducerRunnable));
    }

    @VisibleForTesting
    ExifInterface getExifInterface(String path) throws IOException {
        return new ExifInterface(path);
    }

    private EncodedImage buildEncodedImage(PooledByteBuffer imageBytes, ExifInterface exifInterface) {
        Rect dimensions = JfifUtil.getDimensions(new PooledByteBufferInputStream(imageBytes));
        int rotationAngle = this.getRotationAngle(exifInterface);
        int width = dimensions != null ? dimensions.width() : -1;
        int height = dimensions != null ? dimensions.height() : -1;
        EncodedImage encodedImage = new EncodedImage((CloseableReference<PooledByteBuffer>)CloseableReference.of((Closeable)imageBytes));
        encodedImage.setImageFormat(ImageFormat.JPEG);
        encodedImage.setRotationAngle(rotationAngle);
        encodedImage.setWidth(width);
        encodedImage.setHeight(height);
        return encodedImage;
    }

    private int getRotationAngle(ExifInterface exifInterface) {
        return JfifUtil.getAutoRotateAngleFromOrientation(Integer.parseInt(exifInterface.getAttribute("Orientation")));
    }
}

