/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.content.ContentResolver;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract;
import android.provider.MediaStore;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.imagepipeline.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.producers.LocalFetchProducer;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public class LocalContentUriFetchProducer
extends LocalFetchProducer {
    @VisibleForTesting
    static final String PRODUCER_NAME = "LocalContentUriFetchProducer";
    private static final String DISPLAY_PHOTO_PATH = Uri.withAppendedPath((Uri)ContactsContract.AUTHORITY_URI, (String)"display_photo").getPath();
    private static final String[] PROJECTION = new String[]{"_data"};
    private final ContentResolver mContentResolver;

    public LocalContentUriFetchProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory, ContentResolver contentResolver) {
        super(executor, pooledByteBufferFactory);
        this.mContentResolver = contentResolver;
    }

    @Override
    protected InputStream getInputStream(ImageRequest imageRequest) throws IOException {
        String pathname;
        Uri uri = imageRequest.getSourceUri();
        if (LocalContentUriFetchProducer.isContactUri(uri)) {
            return ContactsContract.Contacts.openContactPhotoInputStream((ContentResolver)this.mContentResolver, (Uri)uri);
        }
        if (LocalContentUriFetchProducer.isCameraUri(uri) && (pathname = this.getCameraPath(uri)) != null) {
            return new FileInputStream(pathname);
        }
        return this.mContentResolver.openInputStream(uri);
    }

    private static boolean isContactUri(Uri uri) {
        return "com.android.contacts".equals(uri.getAuthority()) && !uri.getPath().startsWith(DISPLAY_PHOTO_PATH);
    }

    private static boolean isCameraUri(Uri uri) {
        String uriString = uri.toString();
        return uriString.startsWith(MediaStore.Images.Media.EXTERNAL_CONTENT_URI.toString()) || uriString.startsWith(MediaStore.Images.Media.INTERNAL_CONTENT_URI.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String getCameraPath(Uri uri) {
        Cursor cursor = this.mContentResolver.query(uri, PROJECTION, null, null, null);
        if (cursor == null) {
            return null;
        }
        try {
            cursor.moveToFirst();
            String string = cursor.getString(0);
            return string;
        }
        finally {
            cursor.close();
        }
    }

    @Override
    protected int getLength(ImageRequest imageRequest) {
        Uri uri = imageRequest.getSourceUri();
        if (LocalContentUriFetchProducer.isCameraUri(uri)) {
            String pathname = this.getCameraPath(uri);
            return pathname == null ? -1 : (int)new File(pathname).length();
        }
        return -1;
    }

    @Override
    protected String getProducerName() {
        return PRODUCER_NAME;
    }
}

