/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.memory.MemoryTrimmableRegistry;
import com.facebook.common.memory.NoOpMemoryTrimmableRegistry;
import com.facebook.imagepipeline.memory.DefaultBitmapPoolParams;
import com.facebook.imagepipeline.memory.DefaultByteArrayPoolParams;
import com.facebook.imagepipeline.memory.DefaultNativeMemoryChunkPoolParams;
import com.facebook.imagepipeline.memory.DefaultSharedByteArrayParams;
import com.facebook.imagepipeline.memory.NoOpPoolStatsTracker;
import com.facebook.imagepipeline.memory.PoolParams;
import com.facebook.imagepipeline.memory.PoolStatsTracker;

public class PoolConfig {
    private final PoolParams mBitmapPoolParams;
    private final PoolStatsTracker mBitmapPoolStatsTracker;
    private final MemoryTrimmableRegistry mMemoryTrimmableRegistry;
    private final PoolParams mNativeMemoryChunkPoolParams;
    private final PoolStatsTracker mNativeMemoryChunkPoolStatsTracker;
    private final PoolParams mSharedByteArrayParams;
    private final PoolParams mSmallByteArrayPoolParams;
    private final PoolStatsTracker mSmallByteArrayPoolStatsTracker;

    private PoolConfig(Builder builder) {
        this.mBitmapPoolParams = builder.mBitmapPoolParams == null ? DefaultBitmapPoolParams.get() : builder.mBitmapPoolParams;
        this.mBitmapPoolStatsTracker = builder.mBitmapPoolStatsTracker == null ? NoOpPoolStatsTracker.getInstance() : builder.mBitmapPoolStatsTracker;
        this.mMemoryTrimmableRegistry = builder.mMemoryTrimmableRegistry == null ? NoOpMemoryTrimmableRegistry.getInstance() : builder.mMemoryTrimmableRegistry;
        this.mNativeMemoryChunkPoolParams = builder.mNativeMemoryChunkPoolParams == null ? DefaultNativeMemoryChunkPoolParams.get() : builder.mNativeMemoryChunkPoolParams;
        this.mNativeMemoryChunkPoolStatsTracker = builder.mNativeMemoryChunkPoolStatsTracker == null ? NoOpPoolStatsTracker.getInstance() : builder.mNativeMemoryChunkPoolStatsTracker;
        this.mSharedByteArrayParams = builder.mSharedByteArrayParams == null ? DefaultSharedByteArrayParams.get() : builder.mSharedByteArrayParams;
        this.mSmallByteArrayPoolParams = builder.mSmallByteArrayPoolParams == null ? DefaultByteArrayPoolParams.get() : builder.mSmallByteArrayPoolParams;
        this.mSmallByteArrayPoolStatsTracker = builder.mSmallByteArrayPoolStatsTracker == null ? NoOpPoolStatsTracker.getInstance() : builder.mSmallByteArrayPoolStatsTracker;
    }

    public PoolParams getBitmapPoolParams() {
        return this.mBitmapPoolParams;
    }

    public PoolStatsTracker getBitmapPoolStatsTracker() {
        return this.mBitmapPoolStatsTracker;
    }

    public MemoryTrimmableRegistry getMemoryTrimmableRegistry() {
        return this.mMemoryTrimmableRegistry;
    }

    public PoolParams getNativeMemoryChunkPoolParams() {
        return this.mNativeMemoryChunkPoolParams;
    }

    public PoolStatsTracker getNativeMemoryChunkPoolStatsTracker() {
        return this.mNativeMemoryChunkPoolStatsTracker;
    }

    public PoolParams getSharedByteArrayParams() {
        return this.mSharedByteArrayParams;
    }

    public PoolParams getSmallByteArrayPoolParams() {
        return this.mSmallByteArrayPoolParams;
    }

    public PoolStatsTracker getSmallByteArrayPoolStatsTracker() {
        return this.mSmallByteArrayPoolStatsTracker;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private PoolParams mBitmapPoolParams;
        private PoolStatsTracker mBitmapPoolStatsTracker;
        private PoolParams mSmallByteArrayPoolParams;
        private PoolStatsTracker mSmallByteArrayPoolStatsTracker;
        private MemoryTrimmableRegistry mMemoryTrimmableRegistry;
        private PoolParams mNativeMemoryChunkPoolParams;
        private PoolStatsTracker mNativeMemoryChunkPoolStatsTracker;
        private PoolParams mSharedByteArrayParams;

        private Builder() {
        }

        public Builder setBitmapPoolParams(PoolParams bitmapPoolParams) {
            this.mBitmapPoolParams = (PoolParams)Preconditions.checkNotNull((Object)bitmapPoolParams);
            return this;
        }

        public Builder setBitmapPoolStatsTracker(PoolStatsTracker bitmapPoolStatsTracker) {
            this.mBitmapPoolStatsTracker = (PoolStatsTracker)Preconditions.checkNotNull((Object)bitmapPoolStatsTracker);
            return this;
        }

        public Builder setSmallByteArrayPoolParams(PoolParams commonByteArrayPoolParams) {
            this.mSmallByteArrayPoolParams = (PoolParams)Preconditions.checkNotNull((Object)commonByteArrayPoolParams);
            return this;
        }

        public Builder setSmallByteArrayPoolStatsTracker(PoolStatsTracker smallByteArrayPoolStatsTracker) {
            this.mSmallByteArrayPoolStatsTracker = (PoolStatsTracker)Preconditions.checkNotNull((Object)smallByteArrayPoolStatsTracker);
            return this;
        }

        public Builder setMemoryTrimmableRegistry(MemoryTrimmableRegistry memoryTrimmableRegistry) {
            this.mMemoryTrimmableRegistry = memoryTrimmableRegistry;
            return this;
        }

        public Builder setNativeMemoryChunkPoolParams(PoolParams nativeMemoryChunkPoolParams) {
            this.mNativeMemoryChunkPoolParams = (PoolParams)Preconditions.checkNotNull((Object)nativeMemoryChunkPoolParams);
            return this;
        }

        public Builder setNativeMemoryChunkPoolStatsTracker(PoolStatsTracker nativeMemoryChunkPoolStatsTracker) {
            this.mNativeMemoryChunkPoolStatsTracker = (PoolStatsTracker)Preconditions.checkNotNull((Object)nativeMemoryChunkPoolStatsTracker);
            return this;
        }

        public Builder setSharedByteArrayParams(PoolParams sharedByteArrayParams) {
            this.mSharedByteArrayParams = sharedByteArrayParams;
            return this;
        }

        public PoolConfig build() {
            return new PoolConfig(this);
        }
    }
}

