/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.bitmaps;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.v4.util.Pools;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.common.streams.LimitedInputStream;
import com.facebook.common.streams.TailAppendingInputStream;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.BitmapPool;
import com.facebook.imagepipeline.nativecode.Bitmaps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.ThreadSafe;

@TargetApi(value=21)
@ThreadSafe
public class ArtBitmapFactory {
    private static final int DECODE_BUFFER_SIZE = 16384;
    private final BitmapPool mBitmapPool;
    private final boolean mDownsampleEnabled;
    @VisibleForTesting
    final Pools.SynchronizedPool<ByteBuffer> mDecodeBuffers;
    private static final byte[] EOI_TAIL = new byte[]{-1, -39};

    public ArtBitmapFactory(BitmapPool bitmapPool, int maxNumThreads, boolean downsampleEnabled) {
        this.mBitmapPool = bitmapPool;
        this.mDecodeBuffers = new Pools.SynchronizedPool(maxNumThreads);
        for (int i = 0; i < maxNumThreads; ++i) {
            this.mDecodeBuffers.release((Object)ByteBuffer.allocate(16384));
        }
        this.mDownsampleEnabled = downsampleEnabled;
    }

    CloseableReference<Bitmap> createBitmap(int width, int height) {
        Bitmap bitmap = (Bitmap)this.mBitmapPool.get(width * height);
        Bitmaps.reconfigureBitmap(bitmap, width, height);
        return CloseableReference.of((Object)bitmap, (ResourceReleaser)this.mBitmapPool);
    }

    CloseableReference<Bitmap> decodeFromEncodedImage(EncodedImage encodedImage) {
        return this.doDecodeStaticImage(encodedImage.getInputStream(), encodedImage.getSampleSize());
    }

    CloseableReference<Bitmap> decodeJPEGFromEncodedImage(EncodedImage encodedImage, int length) {
        boolean isJpegComplete;
        InputStream jpegBufferInputStream = encodedImage.getInputStream();
        Preconditions.checkNotNull((Object)jpegBufferInputStream);
        jpegBufferInputStream.mark(Integer.MAX_VALUE);
        try {
            jpegBufferInputStream.skip(length - 2);
            isJpegComplete = jpegBufferInputStream.read() == 255 && jpegBufferInputStream.read() == 217;
            jpegBufferInputStream.reset();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        InputStream jpegDataStream = jpegBufferInputStream;
        if (encodedImage.getSize() > length) {
            jpegDataStream = new LimitedInputStream(jpegDataStream, length);
        }
        if (!isJpegComplete) {
            jpegDataStream = new TailAppendingInputStream(jpegDataStream, EOI_TAIL);
        }
        return this.doDecodeStaticImage(jpegDataStream, encodedImage.getSampleSize());
    }

    private CloseableReference<Bitmap> doDecodeStaticImage(InputStream inputStream, int sampleSize) {
        Bitmap decodedBitmap;
        Preconditions.checkNotNull((Object)inputStream);
        inputStream.mark(Integer.MAX_VALUE);
        BitmapFactory.Options options = this.getDecodeOptionsForStream(inputStream, sampleSize);
        try {
            inputStream.reset();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        Bitmap bitmapToReuse = (Bitmap)this.mBitmapPool.get(options.outHeight * options.outWidth);
        if (bitmapToReuse == null) {
            throw new NullPointerException("BitmapPool.get returned null");
        }
        options.inBitmap = bitmapToReuse;
        ByteBuffer byteBuffer = (ByteBuffer)this.mDecodeBuffers.acquire();
        if (byteBuffer == null) {
            byteBuffer = ByteBuffer.allocate(16384);
        }
        try {
            options.inTempStorage = byteBuffer.array();
            decodedBitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        }
        catch (RuntimeException re) {
            this.mBitmapPool.release(bitmapToReuse);
            throw re;
        }
        finally {
            this.mDecodeBuffers.release((Object)byteBuffer);
        }
        if (bitmapToReuse != decodedBitmap) {
            this.mBitmapPool.release(bitmapToReuse);
            decodedBitmap.recycle();
            throw new IllegalStateException();
        }
        return CloseableReference.of((Object)decodedBitmap, (ResourceReleaser)this.mBitmapPool);
    }

    private BitmapFactory.Options getDecodeOptionsForStream(InputStream inputStream, int sampleSize) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        if (this.mDownsampleEnabled) {
            options.inSampleSize = sampleSize;
        }
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        if (options.outWidth == -1 || options.outHeight == -1) {
            throw new IllegalArgumentException();
        }
        options.inJustDecodeBounds = false;
        options.inDither = true;
        options.inPreferredConfig = Bitmaps.BITMAP_CONFIG;
        options.inMutable = true;
        return options;
    }
}

