/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.graphics.Rect;
import com.facebook.common.references.CloseableReference;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imageformat.ImageFormatChecker;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferInputStream;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imageutils.JfifUtil;

public class AddImageTransformMetaDataProducer
implements Producer<EncodedImage> {
    private final Producer<CloseableReference<PooledByteBuffer>> mNextProducer;

    public AddImageTransformMetaDataProducer(Producer<CloseableReference<PooledByteBuffer>> nextProducer) {
        this.mNextProducer = nextProducer;
    }

    @Override
    public void produceResults(Consumer<EncodedImage> consumer, ProducerContext context) {
        this.mNextProducer.produceResults(new AddImageTransformMetaDataConsumer(consumer), context);
    }

    private static EncodedImage getEncodedImage(CloseableReference<PooledByteBuffer> bytesRef) {
        Rect dimensions;
        ImageFormat imageFormat = ImageFormatChecker.getImageFormat_WrapIOException(new PooledByteBufferInputStream((PooledByteBuffer)bytesRef.get()));
        if (imageFormat == ImageFormat.JPEG && (dimensions = JfifUtil.getDimensions(new PooledByteBufferInputStream((PooledByteBuffer)bytesRef.get()))) != null) {
            return new EncodedImage(bytesRef, imageFormat, AddImageTransformMetaDataProducer.getRotationAngle(bytesRef), dimensions.width(), dimensions.height());
        }
        return new EncodedImage(bytesRef, imageFormat);
    }

    private static int getRotationAngle(CloseableReference<PooledByteBuffer> inputRef) {
        return JfifUtil.getAutoRotateAngleFromOrientation(JfifUtil.getOrientation(new PooledByteBufferInputStream((PooledByteBuffer)inputRef.get())));
    }

    private static class AddImageTransformMetaDataConsumer
    extends DelegatingConsumer<CloseableReference<PooledByteBuffer>, EncodedImage> {
        private AddImageTransformMetaDataConsumer(Consumer<EncodedImage> consumer) {
            super(consumer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onNewResultImpl(CloseableReference<PooledByteBuffer> newResult, boolean isLast) {
            if (newResult == null) {
                this.getConsumer().onNewResult(null, isLast);
                return;
            }
            EncodedImage encodedImage = AddImageTransformMetaDataProducer.getEncodedImage((CloseableReference<PooledByteBuffer>)newResult);
            try {
                this.getConsumer().onNewResult(encodedImage, isLast);
            }
            finally {
                EncodedImage.closeSafely(encodedImage);
            }
        }
    }
}

