/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.image;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferInputStream;
import java.io.Closeable;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class EncodedImage
implements Closeable {
    public static final int UNKNOWN_ROTATION_ANGLE = -1;
    public static final int UNKNOWN_WIDTH = -1;
    public static final int UNKNOWN_HEIGHT = -1;
    private final CloseableReference<PooledByteBuffer> mPooledByteBufferRef;
    private final ImageFormat mImageFormat;
    private final int mRotationAngle;
    private final int mWidth;
    private final int mHeight;

    public EncodedImage(CloseableReference<PooledByteBuffer> pooledByteBufferRef) {
        this(pooledByteBufferRef, ImageFormat.UNKNOWN);
    }

    public EncodedImage(CloseableReference<PooledByteBuffer> pooledByteBufferRef, ImageFormat imageFormat) {
        this(pooledByteBufferRef, imageFormat, -1, -1, -1);
    }

    public EncodedImage(CloseableReference<PooledByteBuffer> pooledByteBufferRef, ImageFormat imageFormat, int rotationAngle, int width, int height) {
        Preconditions.checkArgument((boolean)CloseableReference.isValid(pooledByteBufferRef));
        this.mPooledByteBufferRef = pooledByteBufferRef.clone();
        this.mImageFormat = imageFormat;
        this.mRotationAngle = rotationAngle;
        this.mWidth = width;
        this.mHeight = height;
    }

    public static EncodedImage cloneOrNull(EncodedImage encodedImage) {
        return encodedImage != null ? encodedImage.cloneOrNull() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EncodedImage cloneOrNull() {
        CloseableReference pooledByteBufferRef = this.mPooledByteBufferRef.cloneOrNull();
        try {
            EncodedImage encodedImage = pooledByteBufferRef == null ? null : new EncodedImage((CloseableReference<PooledByteBuffer>)pooledByteBufferRef, this.mImageFormat, this.mRotationAngle, this.mWidth, this.mHeight);
            return encodedImage;
        }
        finally {
            CloseableReference.closeSafely((CloseableReference)pooledByteBufferRef);
        }
    }

    @Override
    public void close() {
        CloseableReference.closeSafely(this.mPooledByteBufferRef);
    }

    public synchronized boolean isValid() {
        return CloseableReference.isValid(this.mPooledByteBufferRef);
    }

    public CloseableReference<PooledByteBuffer> getByteBufferRef() {
        return CloseableReference.cloneOrNull(this.mPooledByteBufferRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() {
        CloseableReference pooledByteBufferRef = this.mPooledByteBufferRef.cloneOrNull();
        if (pooledByteBufferRef != null) {
            try {
                PooledByteBufferInputStream pooledByteBufferInputStream = new PooledByteBufferInputStream((PooledByteBuffer)pooledByteBufferRef.get());
                return pooledByteBufferInputStream;
            }
            finally {
                CloseableReference.closeSafely((CloseableReference)pooledByteBufferRef);
            }
        }
        return null;
    }

    public ImageFormat getImageFormat() {
        return this.mImageFormat;
    }

    public int getRotationAngle() {
        return this.mRotationAngle;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public static boolean isJpegMetaDataAvailable(EncodedImage encodedImage) {
        Preconditions.checkArgument((encodedImage.getImageFormat() == ImageFormat.JPEG ? 1 : 0) != 0);
        return encodedImage.mRotationAngle >= 0 && encodedImage.mWidth >= 0 && encodedImage.mHeight >= 0;
    }

    public static void closeSafely(@Nullable EncodedImage encodedImage) {
        if (encodedImage != null) {
            encodedImage.close();
        }
    }

    public static boolean isValid(@Nullable EncodedImage encodedImage) {
        return encodedImage != null && encodedImage.isValid();
    }
}

