/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.decoder;

import android.graphics.Bitmap;
import com.facebook.common.references.CloseableReference;
import com.facebook.imageformat.GifFormatChecker;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imageformat.ImageFormatChecker;
import com.facebook.imagepipeline.animated.factory.AnimatedImageFactory;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.image.ImmutableQualityInfo;
import com.facebook.imagepipeline.image.QualityInfo;
import com.facebook.imagepipeline.memory.PooledByteBufferInputStream;

public class ImageDecoder {
    private final AnimatedImageFactory mAnimatedImageFactory;
    private final PlatformBitmapFactory mBitmapFactoryWithPool;

    public ImageDecoder(AnimatedImageFactory animatedImageFactory, PlatformBitmapFactory bitmapFactoryWithPool) {
        this.mAnimatedImageFactory = animatedImageFactory;
        this.mBitmapFactoryWithPool = bitmapFactoryWithPool;
    }

    public CloseableImage decodeImage(EncodedImage encodedImage, int length, QualityInfo qualityInfo, ImageDecodeOptions options) {
        ImageFormat imageFormat = encodedImage.getImageFormat();
        if (imageFormat == null || imageFormat == ImageFormat.UNKNOWN) {
            imageFormat = ImageFormatChecker.getImageFormat_WrapIOException(encodedImage.getInputStream());
        }
        switch (imageFormat) {
            case UNKNOWN: {
                throw new IllegalArgumentException("unknown image format");
            }
            case JPEG: {
                return this.decodeJpeg(encodedImage, length, qualityInfo);
            }
            case GIF: {
                return this.decodeGif(encodedImage, options);
            }
            case WEBP_ANIMATED: {
                return this.decodeAnimatedWebp(encodedImage, options);
            }
        }
        return this.decodeStaticImage(encodedImage);
    }

    public CloseableImage decodeGif(EncodedImage encodedImage, ImageDecodeOptions options) {
        PooledByteBufferInputStream is = (PooledByteBufferInputStream)encodedImage.getInputStream();
        if (is == null) {
            return null;
        }
        if (GifFormatChecker.isAnimated(is)) {
            return this.mAnimatedImageFactory.decodeGif(encodedImage, options);
        }
        return this.decodeStaticImage(encodedImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CloseableStaticBitmap decodeStaticImage(EncodedImage encodedImage) {
        try (CloseableReference<Bitmap> bitmapReference = this.mBitmapFactoryWithPool.decodeFromEncodedImage(encodedImage);){
            CloseableStaticBitmap closeableStaticBitmap = new CloseableStaticBitmap(bitmapReference, ImmutableQualityInfo.FULL_QUALITY);
            return closeableStaticBitmap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CloseableStaticBitmap decodeJpeg(EncodedImage encodedImage, int length, QualityInfo qualityInfo) {
        try (CloseableReference<Bitmap> bitmapReference = this.mBitmapFactoryWithPool.decodeJPEGFromEncodedImage(encodedImage, length);){
            CloseableStaticBitmap closeableStaticBitmap = new CloseableStaticBitmap(bitmapReference, qualityInfo);
            return closeableStaticBitmap;
        }
    }

    public CloseableImage decodeAnimatedWebp(EncodedImage encodedImage, ImageDecodeOptions options) {
        return this.mAnimatedImageFactory.decodeWebP(encodedImage, options);
    }
}

