/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.core;

import android.net.Uri;
import android.os.Build;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.media.MediaUtils;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.UriUtil;
import com.facebook.imagepipeline.core.ProducerFactory;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.producers.AddImageTransformMetaDataProducer;
import com.facebook.imagepipeline.producers.BitmapMemoryCacheKeyMultiplexProducer;
import com.facebook.imagepipeline.producers.BitmapMemoryCacheProducer;
import com.facebook.imagepipeline.producers.DecodeProducer;
import com.facebook.imagepipeline.producers.EncodedMemoryCacheProducer;
import com.facebook.imagepipeline.producers.LocalAssetFetchProducer;
import com.facebook.imagepipeline.producers.LocalContentUriFetchProducer;
import com.facebook.imagepipeline.producers.LocalExifThumbnailProducer;
import com.facebook.imagepipeline.producers.LocalFileFetchProducer;
import com.facebook.imagepipeline.producers.LocalResourceFetchProducer;
import com.facebook.imagepipeline.producers.LocalVideoThumbnailProducer;
import com.facebook.imagepipeline.producers.NetworkFetcher;
import com.facebook.imagepipeline.producers.PostprocessorProducer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.RemoveImageTransformMetaDataProducer;
import com.facebook.imagepipeline.producers.ResizeAndRotateProducer;
import com.facebook.imagepipeline.producers.SwallowResultProducer;
import com.facebook.imagepipeline.producers.ThreadHandoffProducer;
import com.facebook.imagepipeline.producers.ThrottlingProducer;
import com.facebook.imagepipeline.request.ImageRequest;
import java.util.HashMap;
import java.util.Map;

public class ProducerSequenceFactory {
    private static final int MAX_SIMULTANEOUS_FILE_FETCH_AND_RESIZE = 5;
    private final ProducerFactory mProducerFactory;
    private final NetworkFetcher mNetworkFetcher;
    private final boolean mResizeAndRotateEnabledForNetwork;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mNetworkFetchSequence;
    @VisibleForTesting
    Producer<EncodedImage> mBackgroundNetworkFetchToEncodedMemorySequence;
    @VisibleForTesting
    Producer<CloseableReference<PooledByteBuffer>> mEncodedImageProducerSequence;
    @VisibleForTesting
    Producer<Void> mNetworkFetchToEncodedMemoryPrefetchSequence;
    private Producer<EncodedImage> mCommonNetworkFetchToEncodedMemorySequence;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mLocalImageFileFetchSequence;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mLocalVideoFileFetchSequence;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mLocalContentUriFetchSequence;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mLocalResourceFetchSequence;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mLocalAssetFetchSequence;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mDataFetchSequence;
    @VisibleForTesting
    Map<Producer<CloseableReference<CloseableImage>>, Producer<CloseableReference<CloseableImage>>> mPostprocessorSequences;
    @VisibleForTesting
    Map<Producer<CloseableReference<CloseableImage>>, Producer<Void>> mCloseableImagePrefetchSequences;

    public ProducerSequenceFactory(ProducerFactory producerFactory, NetworkFetcher networkFetcher, boolean resizeAndRotateEnabledForNetwork) {
        this.mProducerFactory = producerFactory;
        this.mNetworkFetcher = networkFetcher;
        this.mResizeAndRotateEnabledForNetwork = resizeAndRotateEnabledForNetwork;
        this.mPostprocessorSequences = new HashMap<Producer<CloseableReference<CloseableImage>>, Producer<CloseableReference<CloseableImage>>>();
        this.mCloseableImagePrefetchSequences = new HashMap<Producer<CloseableReference<CloseableImage>>, Producer<Void>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Producer<CloseableReference<PooledByteBuffer>> getEncodedImageProducerSequence(ImageRequest imageRequest) {
        ProducerSequenceFactory.validateEncodedImageRequest(imageRequest);
        ProducerSequenceFactory producerSequenceFactory = this;
        synchronized (producerSequenceFactory) {
            if (this.mEncodedImageProducerSequence == null) {
                this.mEncodedImageProducerSequence = new RemoveImageTransformMetaDataProducer(this.getBackgroundNetworkFetchToEncodedMemorySequence());
            }
        }
        return this.mEncodedImageProducerSequence;
    }

    public Producer<Void> getEncodedImagePrefetchProducerSequence(ImageRequest imageRequest) {
        ProducerSequenceFactory.validateEncodedImageRequest(imageRequest);
        return this.getNetworkFetchToEncodedMemoryPrefetchSequence();
    }

    private static void validateEncodedImageRequest(ImageRequest imageRequest) {
        Preconditions.checkNotNull((Object)imageRequest);
        Preconditions.checkArgument((boolean)UriUtil.isNetworkUri((Uri)imageRequest.getSourceUri()));
        Preconditions.checkArgument((imageRequest.getLowestPermittedRequestLevel().getValue() <= ImageRequest.RequestLevel.ENCODED_MEMORY_CACHE.getValue() ? 1 : 0) != 0);
    }

    public Producer<CloseableReference<CloseableImage>> getDecodedImageProducerSequence(ImageRequest imageRequest) {
        Producer<CloseableReference<CloseableImage>> pipelineSequence = this.getBasicDecodedImageSequence(imageRequest);
        if (imageRequest.getPostprocessor() != null) {
            return this.getPostprocessorSequence(pipelineSequence);
        }
        return pipelineSequence;
    }

    public Producer<Void> getDecodedImagePrefetchProducerSequence(ImageRequest imageRequest) {
        return this.getDecodedImagePrefetchSequence(this.getBasicDecodedImageSequence(imageRequest));
    }

    private Producer<CloseableReference<CloseableImage>> getBasicDecodedImageSequence(ImageRequest imageRequest) {
        Preconditions.checkNotNull((Object)imageRequest);
        Uri uri = imageRequest.getSourceUri();
        Preconditions.checkNotNull((Object)uri, (Object)"Uri is null.");
        if (UriUtil.isNetworkUri((Uri)uri)) {
            return this.getNetworkFetchSequence();
        }
        if (UriUtil.isLocalFileUri((Uri)uri)) {
            if (MediaUtils.isVideo((String)MediaUtils.extractMime((String)uri.getPath()))) {
                return this.getLocalVideoFileFetchSequence();
            }
            return this.getLocalImageFileFetchSequence();
        }
        if (UriUtil.isLocalContentUri((Uri)uri)) {
            return this.getLocalContentUriFetchSequence();
        }
        if (UriUtil.isLocalAssetUri((Uri)uri)) {
            return this.getLocalAssetFetchSequence();
        }
        if (UriUtil.isLocalResourceUri((Uri)uri)) {
            return this.getLocalResourceFetchSequence();
        }
        if (UriUtil.isDataUri((Uri)uri)) {
            return this.getDataFetchSequence();
        }
        String uriString = uri.toString();
        if (uriString.length() > 30) {
            uriString = uriString.substring(0, 30) + "...";
        }
        throw new RuntimeException("Unsupported uri scheme! Uri is: " + uriString);
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getNetworkFetchSequence() {
        if (this.mNetworkFetchSequence == null) {
            this.mNetworkFetchSequence = this.newBitmapCacheGetToDecodeSequence(this.getCommonNetworkFetchToEncodedMemorySequence());
        }
        return this.mNetworkFetchSequence;
    }

    private synchronized Producer<EncodedImage> getBackgroundNetworkFetchToEncodedMemorySequence() {
        if (this.mBackgroundNetworkFetchToEncodedMemorySequence == null) {
            this.mBackgroundNetworkFetchToEncodedMemorySequence = this.mProducerFactory.newBackgroundThreadHandoffProducer(this.getCommonNetworkFetchToEncodedMemorySequence());
        }
        return this.mBackgroundNetworkFetchToEncodedMemorySequence;
    }

    private synchronized Producer<Void> getNetworkFetchToEncodedMemoryPrefetchSequence() {
        if (this.mNetworkFetchToEncodedMemoryPrefetchSequence == null) {
            this.mNetworkFetchToEncodedMemoryPrefetchSequence = ProducerFactory.newSwallowResultProducer(this.getBackgroundNetworkFetchToEncodedMemorySequence());
        }
        return this.mNetworkFetchToEncodedMemoryPrefetchSequence;
    }

    private synchronized Producer<EncodedImage> getCommonNetworkFetchToEncodedMemorySequence() {
        if (this.mCommonNetworkFetchToEncodedMemorySequence == null) {
            Producer<CloseableReference<PooledByteBuffer>> nextProducer = this.newEncodedCacheMultiplexToTranscodeSequence(this.mProducerFactory.newNetworkFetchProducer(this.mNetworkFetcher));
            this.mCommonNetworkFetchToEncodedMemorySequence = ProducerFactory.newAddImageTransformMetaDataProducer(nextProducer);
            if (this.mResizeAndRotateEnabledForNetwork) {
                this.mCommonNetworkFetchToEncodedMemorySequence = this.mProducerFactory.newResizeAndRotateProducer(this.mCommonNetworkFetchToEncodedMemorySequence);
            }
        }
        return this.mCommonNetworkFetchToEncodedMemorySequence;
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getLocalImageFileFetchSequence() {
        if (this.mLocalImageFileFetchSequence == null) {
            LocalFileFetchProducer localFileFetchProducer = this.mProducerFactory.newLocalFileFetchProducer();
            this.mLocalImageFileFetchSequence = this.newBitmapCacheGetToLocalTransformSequence(localFileFetchProducer);
        }
        return this.mLocalImageFileFetchSequence;
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getLocalVideoFileFetchSequence() {
        if (this.mLocalVideoFileFetchSequence == null) {
            LocalVideoThumbnailProducer localVideoThumbnailProducer = this.mProducerFactory.newLocalVideoThumbnailProducer();
            this.mLocalVideoFileFetchSequence = this.newBitmapCacheGetToBitmapCacheSequence(localVideoThumbnailProducer);
        }
        return this.mLocalVideoFileFetchSequence;
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getLocalContentUriFetchSequence() {
        if (this.mLocalContentUriFetchSequence == null) {
            LocalContentUriFetchProducer localContentUriFetchProducer = this.mProducerFactory.newContentUriFetchProducer();
            this.mLocalContentUriFetchSequence = this.newBitmapCacheGetToLocalTransformSequence(localContentUriFetchProducer);
        }
        return this.mLocalContentUriFetchSequence;
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getLocalResourceFetchSequence() {
        if (this.mLocalResourceFetchSequence == null) {
            LocalResourceFetchProducer localResourceFetchProducer = this.mProducerFactory.newLocalResourceFetchProducer();
            this.mLocalResourceFetchSequence = this.newBitmapCacheGetToLocalTransformSequence(localResourceFetchProducer);
        }
        return this.mLocalResourceFetchSequence;
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getLocalAssetFetchSequence() {
        if (this.mLocalAssetFetchSequence == null) {
            LocalAssetFetchProducer localAssetFetchProducer = this.mProducerFactory.newLocalAssetFetchProducer();
            this.mLocalAssetFetchSequence = this.newBitmapCacheGetToLocalTransformSequence(localAssetFetchProducer);
        }
        return this.mLocalAssetFetchSequence;
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getDataFetchSequence() {
        if (this.mDataFetchSequence == null) {
            Producer<CloseableReference<PooledByteBuffer>> nextProducer = this.mProducerFactory.newDataFetchProducer();
            if (Build.VERSION.SDK_INT < 18) {
                nextProducer = this.mProducerFactory.newWebpTranscodeProducer(nextProducer);
            }
            AddImageTransformMetaDataProducer addImageTransformMetaDataProducer = ProducerFactory.newAddImageTransformMetaDataProducer(nextProducer);
            ResizeAndRotateProducer resizeAndRotateProducer = this.mProducerFactory.newResizeAndRotateProducer(addImageTransformMetaDataProducer);
            this.mDataFetchSequence = this.newBitmapCacheGetToDecodeSequence(resizeAndRotateProducer);
        }
        return this.mDataFetchSequence;
    }

    private Producer<CloseableReference<CloseableImage>> newBitmapCacheGetToLocalTransformSequence(Producer<CloseableReference<PooledByteBuffer>> nextProducer) {
        nextProducer = this.newEncodedCacheMultiplexToTranscodeSequence(nextProducer);
        Producer<EncodedImage> nextProducerAfterDecode = this.newLocalTransformationsSequence(nextProducer);
        return this.newBitmapCacheGetToDecodeSequence(nextProducerAfterDecode);
    }

    private Producer<CloseableReference<CloseableImage>> newBitmapCacheGetToDecodeSequence(Producer<EncodedImage> nextProducer) {
        DecodeProducer decodeProducer = this.mProducerFactory.newDecodeProducer(nextProducer);
        return this.newBitmapCacheGetToBitmapCacheSequence(decodeProducer);
    }

    private Producer<CloseableReference<PooledByteBuffer>> newEncodedCacheMultiplexToTranscodeSequence(Producer<CloseableReference<PooledByteBuffer>> nextProducer) {
        if (Build.VERSION.SDK_INT < 18) {
            nextProducer = this.mProducerFactory.newWebpTranscodeProducer(nextProducer);
        }
        nextProducer = this.mProducerFactory.newDiskCacheProducer(nextProducer);
        EncodedMemoryCacheProducer encodedMemoryCacheProducer = this.mProducerFactory.newEncodedMemoryCacheProducer(nextProducer);
        return this.mProducerFactory.newEncodedCacheKeyMultiplexProducer(encodedMemoryCacheProducer);
    }

    private Producer<CloseableReference<CloseableImage>> newBitmapCacheGetToBitmapCacheSequence(Producer<CloseableReference<CloseableImage>> nextProducer) {
        BitmapMemoryCacheProducer bitmapMemoryCacheProducer = this.mProducerFactory.newBitmapMemoryCacheProducer(nextProducer);
        BitmapMemoryCacheKeyMultiplexProducer bitmapKeyMultiplexProducer = this.mProducerFactory.newBitmapMemoryCacheKeyMultiplexProducer(bitmapMemoryCacheProducer);
        ThreadHandoffProducer<CloseableReference<CloseableImage>> threadHandoffProducer = this.mProducerFactory.newBackgroundThreadHandoffProducer(bitmapKeyMultiplexProducer);
        return this.mProducerFactory.newBitmapMemoryCacheGetProducer(threadHandoffProducer);
    }

    private Producer<EncodedImage> newLocalTransformationsSequence(Producer<CloseableReference<PooledByteBuffer>> nextProducer) {
        AddImageTransformMetaDataProducer addImageTransformMetaDataProducer = ProducerFactory.newAddImageTransformMetaDataProducer(nextProducer);
        ResizeAndRotateProducer localImageResizeAndRotateProducer = this.mProducerFactory.newResizeAndRotateProducer(addImageTransformMetaDataProducer);
        ThrottlingProducer<EncodedImage> localImageThrottlingProducer = this.mProducerFactory.newThrottlingProducer(5, localImageResizeAndRotateProducer);
        LocalExifThumbnailProducer localExifThumbnailProducer = this.mProducerFactory.newLocalExifThumbnailProducer();
        ResizeAndRotateProducer exifThumbnailResizeAndRotateProducer = this.mProducerFactory.newResizeAndRotateProducer(localExifThumbnailProducer);
        return ProducerFactory.newBranchOnSeparateImagesProducer(exifThumbnailResizeAndRotateProducer, localImageThrottlingProducer);
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getPostprocessorSequence(Producer<CloseableReference<CloseableImage>> nextProducer) {
        if (!this.mPostprocessorSequences.containsKey(nextProducer)) {
            PostprocessorProducer postprocessorProducer = this.mProducerFactory.newPostprocessorProducer(nextProducer);
            this.mPostprocessorSequences.put(nextProducer, postprocessorProducer);
        }
        return this.mPostprocessorSequences.get(nextProducer);
    }

    private synchronized Producer<Void> getDecodedImagePrefetchSequence(Producer<CloseableReference<CloseableImage>> nextProducer) {
        if (!this.mCloseableImagePrefetchSequences.containsKey(nextProducer)) {
            SwallowResultProducer<CloseableReference<CloseableImage>> swallowResultProducer = ProducerFactory.newSwallowResultProducer(nextProducer);
            this.mCloseableImagePrefetchSequences.put(nextProducer, swallowResultProducer);
        }
        return this.mCloseableImagePrefetchSequences.get(nextProducer);
    }
}

