/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.Objects;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.util.HashCodeUtil;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.common.ResizeOptions;
import java.util.Locale;
import javax.annotation.Nullable;

public class BitmapMemoryCacheKey
implements CacheKey {
    private final String mSourceString;
    @Nullable
    private final ResizeOptions mResizeOptions;
    private final boolean mAutoRotated;
    private final ImageDecodeOptions mImageDecodeOptions;
    private final int mHash;

    public BitmapMemoryCacheKey(String sourceString, @Nullable ResizeOptions resizeOptions, boolean autoRotated, ImageDecodeOptions imageDecodeOptions) {
        this.mSourceString = (String)Preconditions.checkNotNull((Object)sourceString);
        this.mResizeOptions = resizeOptions;
        this.mAutoRotated = autoRotated;
        this.mImageDecodeOptions = imageDecodeOptions;
        this.mHash = HashCodeUtil.hashCode((Object)sourceString.hashCode(), (Object)(resizeOptions != null ? resizeOptions.hashCode() : 0), (Object)(autoRotated ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode()), (Object)this.mImageDecodeOptions);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof BitmapMemoryCacheKey)) {
            return false;
        }
        BitmapMemoryCacheKey otherKey = (BitmapMemoryCacheKey)o;
        return this.mHash == otherKey.mHash && this.mSourceString.equals(otherKey.mSourceString) && Objects.equal((Object)this.mResizeOptions, (Object)otherKey.mResizeOptions) && this.mAutoRotated == otherKey.mAutoRotated && Objects.equal((Object)this.mImageDecodeOptions, (Object)otherKey.mImageDecodeOptions);
    }

    @Override
    public int hashCode() {
        return this.mHash;
    }

    public String getSourceUriString() {
        return this.mSourceString;
    }

    @Override
    public String toString() {
        return String.format((Locale)null, "%s_%s_%s_%s_%d", this.mSourceString, this.mResizeOptions, Boolean.toString(this.mAutoRotated), this.mImageDecodeOptions, this.mHash);
    }
}

