/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.bitmaps;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.common.streams.LimitedInputStream;
import com.facebook.common.streams.TailAppendingInputStream;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.BitmapPool;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.nativecode.Bitmaps;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.GuardedBy;

@TargetApi(value=21)
public class ArtBitmapFactory {
    private static final int DECODE_BUFFER_SIZE = 16384;
    private final BitmapPool mBitmapPool;
    @GuardedBy(value="this")
    private final byte[] mDecodeBuffer = new byte[16384];
    private static final byte[] EOI_TAIL = new byte[]{-1, -39};

    public ArtBitmapFactory(BitmapPool bitmapPool) {
        this.mBitmapPool = bitmapPool;
    }

    CloseableReference<Bitmap> createBitmap(int width, int height) {
        Bitmap bitmap = (Bitmap)this.mBitmapPool.get(width * height);
        Bitmaps.reconfigureBitmap(bitmap, width, height);
        return CloseableReference.of((Object)bitmap, (ResourceReleaser)this.mBitmapPool);
    }

    CloseableReference<Bitmap> decodeFromEncodedImage(EncodedImage encodedImage) {
        return this.doDecodeStaticImage(encodedImage.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CloseableReference<Bitmap> decodeJPEGFromEncodedImage(EncodedImage encodedImage, int length) {
        boolean isJpegComplete;
        InputStream jpegBufferInputStream = encodedImage.getInputStream();
        Preconditions.checkNotNull((Object)jpegBufferInputStream);
        jpegBufferInputStream.mark(Integer.MAX_VALUE);
        try {
            jpegBufferInputStream.skip(length - 2);
            isJpegComplete = jpegBufferInputStream.read() == 255 && jpegBufferInputStream.read() == 217;
            jpegBufferInputStream.reset();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        CloseableReference<PooledByteBuffer> bytesRef = encodedImage.getByteBufferRef();
        try {
            InputStream jpegDataStream = jpegBufferInputStream;
            if (((PooledByteBuffer)bytesRef.get()).size() > length) {
                jpegDataStream = new LimitedInputStream(jpegDataStream, length);
            }
            if (!isJpegComplete) {
                jpegDataStream = new TailAppendingInputStream(jpegDataStream, EOI_TAIL);
            }
            CloseableReference<Bitmap> closeableReference = this.doDecodeStaticImage(jpegDataStream);
            return closeableReference;
        }
        finally {
            CloseableReference.closeSafely(bytesRef);
        }
    }

    private CloseableReference<Bitmap> doDecodeStaticImage(InputStream inputStream) {
        Bitmap decodedBitmap;
        Preconditions.checkNotNull((Object)inputStream);
        inputStream.mark(Integer.MAX_VALUE);
        BitmapFactory.Options options = this.getDecodeOptionsForStream(inputStream);
        try {
            inputStream.reset();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        Bitmap bitmapToReuse = (Bitmap)this.mBitmapPool.get(options.outHeight * options.outWidth);
        if (bitmapToReuse == null) {
            throw new NullPointerException("BitmapPool.get returned null");
        }
        options.inBitmap = bitmapToReuse;
        try {
            decodedBitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        }
        catch (RuntimeException re) {
            this.mBitmapPool.release(bitmapToReuse);
            throw re;
        }
        if (bitmapToReuse != decodedBitmap) {
            this.mBitmapPool.release(bitmapToReuse);
            decodedBitmap.recycle();
            throw new IllegalStateException();
        }
        return CloseableReference.of((Object)decodedBitmap, (ResourceReleaser)this.mBitmapPool);
    }

    private BitmapFactory.Options getDecodeOptionsForStream(InputStream inputStream) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inTempStorage = this.mDecodeBuffer;
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
        if (options.outWidth == -1 || options.outHeight == -1) {
            throw new IllegalArgumentException();
        }
        options.inJustDecodeBounds = false;
        options.inDither = true;
        options.inPreferredConfig = Bitmaps.BITMAP_CONFIG;
        options.inMutable = true;
        return options;
    }
}

