/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.animated.factory;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.os.Build;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableBackend;
import com.facebook.imagepipeline.animated.base.AnimatedImage;
import com.facebook.imagepipeline.animated.base.AnimatedImageResult;
import com.facebook.imagepipeline.animated.impl.AnimatedDrawableBackendProvider;
import com.facebook.imagepipeline.animated.impl.AnimatedImageCompositor;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.gif.GifImage;
import com.facebook.imagepipeline.image.CloseableAnimatedImage;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.webp.WebPImage;
import java.util.ArrayList;
import java.util.List;

public class AnimatedImageFactory {
    private final AnimatedDrawableBackendProvider mAnimatedDrawableBackendProvider;
    private final PlatformBitmapFactory mBitmapFactory;

    public AnimatedImageFactory(AnimatedDrawableBackendProvider animatedDrawableBackendProvider, PlatformBitmapFactory bitmapFactory) {
        this.mAnimatedDrawableBackendProvider = animatedDrawableBackendProvider;
        this.mBitmapFactory = bitmapFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableImage decodeGif(EncodedImage encodedImage, ImageDecodeOptions options) {
        CloseableReference<PooledByteBuffer> bytesRef = encodedImage.getByteBufferRef();
        Preconditions.checkNotNull(bytesRef);
        try {
            Preconditions.checkState((!options.forceOldAnimationCode ? 1 : 0) != 0);
            PooledByteBuffer input = (PooledByteBuffer)bytesRef.get();
            GifImage gifImage = GifImage.create(input.getNativePtr(), input.size());
            CloseableAnimatedImage closeableAnimatedImage = this.getCloseableImage(options, gifImage);
            return closeableAnimatedImage;
        }
        finally {
            CloseableReference.closeSafely(bytesRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloseableImage decodeWebP(EncodedImage encodedImage, ImageDecodeOptions options) {
        CloseableReference<PooledByteBuffer> bytesRef = encodedImage.getByteBufferRef();
        Preconditions.checkNotNull(bytesRef);
        try {
            Preconditions.checkArgument((!options.forceOldAnimationCode ? 1 : 0) != 0);
            PooledByteBuffer input = (PooledByteBuffer)bytesRef.get();
            WebPImage webPImage = WebPImage.create(input.getNativePtr(), input.size());
            CloseableAnimatedImage closeableAnimatedImage = this.getCloseableImage(options, webPImage);
            return closeableAnimatedImage;
        }
        finally {
            CloseableReference.closeSafely(bytesRef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CloseableAnimatedImage getCloseableImage(ImageDecodeOptions options, AnimatedImage image) {
        List<CloseableReference<Bitmap>> decodedFrames = null;
        CloseableReference<Bitmap> previewBitmap = null;
        try {
            int frameForPreview;
            int n = frameForPreview = options.useLastFrameForPreview ? image.getFrameCount() - 1 : 0;
            if (options.decodeAllFrames) {
                decodedFrames = this.decodeAllFrames(image);
                previewBitmap = CloseableReference.cloneOrNull(decodedFrames.get(frameForPreview));
            }
            if (options.decodePreviewFrame && previewBitmap == null) {
                previewBitmap = this.createPreviewBitmap(image, frameForPreview);
            }
            AnimatedImageResult animatedImageResult = AnimatedImageResult.newBuilder(image).setPreviewBitmap(previewBitmap).setFrameForPreview(frameForPreview).setDecodedFrames(decodedFrames).build();
            CloseableAnimatedImage closeableAnimatedImage = new CloseableAnimatedImage(animatedImageResult);
            return closeableAnimatedImage;
        }
        finally {
            CloseableReference.closeSafely(previewBitmap);
            CloseableReference.closeSafely(decodedFrames);
        }
    }

    private CloseableReference<Bitmap> createPreviewBitmap(AnimatedImage image, int frameForPreview) {
        CloseableReference<Bitmap> bitmap = this.createBitmap(image.getWidth(), image.getHeight());
        AnimatedImageResult tempResult = AnimatedImageResult.forAnimatedImage(image);
        AnimatedDrawableBackend drawableBackend = this.mAnimatedDrawableBackendProvider.get(tempResult, null);
        AnimatedImageCompositor animatedImageCompositor = new AnimatedImageCompositor(drawableBackend, new AnimatedImageCompositor.Callback(){

            @Override
            public void onIntermediateResult(int frameNumber, Bitmap bitmap) {
            }

            @Override
            public CloseableReference<Bitmap> getCachedBitmap(int frameNumber) {
                return null;
            }
        });
        animatedImageCompositor.renderFrame(frameForPreview, (Bitmap)bitmap.get());
        return bitmap;
    }

    private List<CloseableReference<Bitmap>> decodeAllFrames(AnimatedImage image) {
        final ArrayList<CloseableReference<Bitmap>> bitmaps = new ArrayList<CloseableReference<Bitmap>>();
        AnimatedImageResult tempResult = AnimatedImageResult.forAnimatedImage(image);
        AnimatedDrawableBackend drawableBackend = this.mAnimatedDrawableBackendProvider.get(tempResult, null);
        AnimatedImageCompositor animatedImageCompositor = new AnimatedImageCompositor(drawableBackend, new AnimatedImageCompositor.Callback(){

            @Override
            public void onIntermediateResult(int frameNumber, Bitmap bitmap) {
            }

            @Override
            public CloseableReference<Bitmap> getCachedBitmap(int frameNumber) {
                return CloseableReference.cloneOrNull((CloseableReference)((CloseableReference)bitmaps.get(frameNumber)));
            }
        });
        for (int i = 0; i < drawableBackend.getFrameCount(); ++i) {
            CloseableReference<Bitmap> bitmap = this.createBitmap(drawableBackend.getWidth(), drawableBackend.getHeight());
            animatedImageCompositor.renderFrame(i, (Bitmap)bitmap.get());
            bitmaps.add(bitmap);
        }
        return bitmaps;
    }

    @SuppressLint(value={"NewApi"})
    private CloseableReference<Bitmap> createBitmap(int width, int height) {
        CloseableReference<Bitmap> bitmap = this.mBitmapFactory.createBitmap(width, height);
        ((Bitmap)bitmap.get()).eraseColor(0);
        if (Build.VERSION.SDK_INT >= 12) {
            ((Bitmap)bitmap.get()).setHasAlpha(true);
        }
        return bitmap;
    }
}

