/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.TriState;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.memory.PooledByteBufferOutputStream;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.producers.StatefulProducerRunnable;
import com.facebook.imagepipeline.request.ImageRequest;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public abstract class ImageTransformProducer<T, E>
implements Producer<T> {
    private final Executor mExecutor;
    private final PooledByteBufferFactory mPooledByteBufferFactory;
    private final Producer<T> mNextProducer;

    protected ImageTransformProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory, Producer<T> nextProducer) {
        this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.mPooledByteBufferFactory = (PooledByteBufferFactory)Preconditions.checkNotNull((Object)pooledByteBufferFactory);
        this.mNextProducer = (Producer)Preconditions.checkNotNull(nextProducer);
    }

    @Override
    public void produceResults(Consumer<T> consumer, ProducerContext context) {
        this.mNextProducer.produceResults(new TransformingConsumer(consumer, context), context);
    }

    private void transformLastResult(T originalResult, Consumer<T> consumer, final ProducerContext producerContext) {
        ProducerListener listener = producerContext.getListener();
        String requestId = producerContext.getId();
        final CloseableReference<PooledByteBuffer> imageRefCopy = this.getImageCopy(originalResult);
        final E extraInformation = this.getExtraInformation(originalResult);
        final StatefulProducerRunnable cancellableProducerRunnable = new StatefulProducerRunnable<T>(consumer, listener, this.getProducerName(), requestId){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected T getResult() throws Exception {
                ImageRequest imageRequest = producerContext.getImageRequest();
                try (PooledByteBufferOutputStream outputStream = ImageTransformProducer.this.mPooledByteBufferFactory.newOutputStream();){
                    ImageTransformProducer.this.transform((CloseableReference<PooledByteBuffer>)imageRefCopy, outputStream, imageRequest, extraInformation);
                    Object t = ImageTransformProducer.this.createReturnValue(outputStream.toByteBuffer(), extraInformation);
                    return t;
                }
            }

            @Override
            protected void disposeResult(T result) {
                ImageTransformProducer.this.closeReturnValue(result);
            }

            @Override
            protected void onSuccess(T result) {
                imageRefCopy.close();
                super.onSuccess(result);
            }

            @Override
            protected void onFailure(Exception e) {
                imageRefCopy.close();
                super.onFailure(e);
            }

            @Override
            protected void onCancellation() {
                imageRefCopy.close();
                super.onCancellation();
            }
        };
        if (this.shouldAllowCancellation()) {
            producerContext.addCallbacks(new BaseProducerContextCallbacks(){

                @Override
                public void onCancellationRequested() {
                    cancellableProducerRunnable.cancel();
                }
            });
        }
        this.mExecutor.execute((Runnable)((Object)cancellableProducerRunnable));
    }

    protected abstract TriState shouldTransform(T var1, ImageRequest var2, boolean var3);

    protected abstract void transform(CloseableReference<PooledByteBuffer> var1, PooledByteBufferOutputStream var2, ImageRequest var3, E var4) throws Exception;

    protected abstract CloseableReference<PooledByteBuffer> getImageCopy(T var1);

    @Nullable
    protected abstract E getExtraInformation(T var1);

    protected abstract T createReturnValue(PooledByteBuffer var1, E var2);

    protected abstract void closeReturnValue(T var1);

    protected abstract String getProducerName();

    protected abstract boolean shouldAllowCancellation();

    private class TransformingConsumer
    extends DelegatingConsumer<T, T> {
        private final ProducerContext mContext;
        private TriState mShouldTransformWhenFinished;

        public TransformingConsumer(Consumer<T> consumer, ProducerContext context) {
            super(consumer);
            this.mContext = context;
            this.mShouldTransformWhenFinished = TriState.UNSET;
        }

        @Override
        protected void onNewResultImpl(@Nullable T newResult, boolean isLast) {
            if (this.mShouldTransformWhenFinished == TriState.UNSET && newResult != null) {
                this.mShouldTransformWhenFinished = ImageTransformProducer.this.shouldTransform(newResult, this.mContext.getImageRequest(), isLast);
            }
            if (this.mShouldTransformWhenFinished == TriState.NO) {
                this.getConsumer().onNewResult(newResult, isLast);
                return;
            }
            if (isLast) {
                if (this.mShouldTransformWhenFinished == TriState.YES) {
                    ImageTransformProducer.this.transformLastResult(newResult, this.getConsumer(), this.mContext);
                } else {
                    this.getConsumer().onNewResult(newResult, isLast);
                }
            }
        }
    }
}

