/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.imageformat.ImageFormat;

public class ImageTransformMetaData {
    private final ImageFormat mImageFormat;
    private final int mRotationAngle;
    private final int mWidth;
    private final int mHeight;

    private ImageTransformMetaData(ImageFormat imageFormat, int rotationAngle, int width, int height) {
        this.mImageFormat = imageFormat;
        this.mRotationAngle = rotationAngle;
        this.mWidth = width;
        this.mHeight = height;
    }

    public ImageFormat getImageFormat() {
        return this.mImageFormat;
    }

    public int getRotationAngle() {
        return this.mRotationAngle;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private ImageFormat mImageFormat;
        private int mRotationAngle;
        private int mWidth;
        private int mHeight;

        public Builder() {
            this.reset();
        }

        public Builder reset() {
            this.mImageFormat = ImageFormat.UNKNOWN;
            this.mRotationAngle = -1;
            this.mWidth = -1;
            this.mHeight = -1;
            return this;
        }

        public Builder setImageFormat(ImageFormat imageFormat) {
            this.mImageFormat = imageFormat;
            return this;
        }

        public Builder setRotationAngle(int rotationAngle) {
            this.mRotationAngle = rotationAngle;
            return this;
        }

        public Builder setWidth(int width) {
            this.mWidth = width;
            return this;
        }

        public Builder setHeight(int height) {
            this.mHeight = height;
            return this;
        }

        public ImageTransformMetaData build() {
            return new ImageTransformMetaData(this.mImageFormat, this.mRotationAngle, this.mWidth, this.mHeight);
        }
    }
}

