/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.gif;

import com.facebook.common.internal.DoNotStrip;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.soloader.SoLoaderShim;
import com.facebook.imagepipeline.animated.base.AnimatedDrawableFrameInfo;
import com.facebook.imagepipeline.animated.base.AnimatedImage;
import com.facebook.imagepipeline.gif.GifFrame;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class GifImage
implements AnimatedImage {
    private static volatile boolean sInitialized;
    @DoNotStrip
    private int mNativeContext;

    private static synchronized void ensure() {
        if (!sInitialized) {
            sInitialized = true;
            SoLoaderShim.loadLibrary((String)"gnustl_shared");
            SoLoaderShim.loadLibrary((String)"gifimage");
        }
    }

    public static GifImage create(byte[] source) {
        GifImage.ensure();
        Preconditions.checkNotNull((Object)source);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(source.length);
        byteBuffer.put(source);
        byteBuffer.rewind();
        return GifImage.nativeCreateFromDirectByteBuffer(byteBuffer);
    }

    public static GifImage create(long nativePtr, int sizeInBytes) {
        GifImage.ensure();
        Preconditions.checkArgument((nativePtr != 0L ? 1 : 0) != 0);
        return GifImage.nativeCreateFromNativeMemory(nativePtr, sizeInBytes);
    }

    @DoNotStrip
    GifImage(int nativeContext) {
        this.mNativeContext = nativeContext;
    }

    protected void finalize() {
        this.nativeFinalize();
    }

    @Override
    public void dispose() {
        this.nativeDispose();
    }

    @Override
    public int getWidth() {
        return this.nativeGetWidth();
    }

    @Override
    public int getHeight() {
        return this.nativeGetHeight();
    }

    @Override
    public int getFrameCount() {
        return this.nativeGetFrameCount();
    }

    @Override
    public int getDuration() {
        return this.nativeGetDuration();
    }

    @Override
    public int[] getFrameDurations() {
        return this.nativeGetFrameDurations();
    }

    @Override
    public int getLoopCount() {
        return this.nativeGetLoopCount();
    }

    @Override
    public GifFrame getFrame(int frameNumber) {
        return this.nativeGetFrame(frameNumber);
    }

    @Override
    public boolean doesRenderSupportScaling() {
        return false;
    }

    @Override
    public int getSizeInBytes() {
        return this.nativeGetSizeInBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnimatedDrawableFrameInfo getFrameInfo(int frameNumber) {
        GifFrame frame = this.getFrame(frameNumber);
        try {
            AnimatedDrawableFrameInfo animatedDrawableFrameInfo = new AnimatedDrawableFrameInfo(frameNumber, frame.getXOffset(), frame.getYOffset(), frame.getWidth(), frame.getHeight(), true, GifImage.fromGifDisposalMethod(frame.getDisposalMode()));
            return animatedDrawableFrameInfo;
        }
        finally {
            frame.dispose();
        }
    }

    private static AnimatedDrawableFrameInfo.DisposalMethod fromGifDisposalMethod(int disposalMode) {
        if (disposalMode == 0) {
            return AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_DO_NOT;
        }
        if (disposalMode == 1) {
            return AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_DO_NOT;
        }
        if (disposalMode == 2) {
            return AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_TO_BACKGROUND;
        }
        if (disposalMode == 3) {
            return AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_TO_PREVIOUS;
        }
        return AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_DO_NOT;
    }

    private static native GifImage nativeCreateFromDirectByteBuffer(ByteBuffer var0);

    private static native GifImage nativeCreateFromNativeMemory(long var0, int var2);

    private native int nativeGetWidth();

    private native int nativeGetHeight();

    private native int nativeGetDuration();

    private native int nativeGetFrameCount();

    private native int[] nativeGetFrameDurations();

    private native int nativeGetLoopCount();

    private native GifFrame nativeGetFrame(int var1);

    private native int nativeGetSizeInBytes();

    private native void nativeDispose();

    private native void nativeFinalize();
}

