/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import com.android.internal.util.Predicate;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imagepipeline.cache.CountingMemoryCache;
import com.facebook.imagepipeline.cache.MemoryCache;
import javax.annotation.Nullable;

public class ReferenceWrappingMemoryCache<K, V, S>
implements MemoryCache<K, V, S> {
    private final CountingMemoryCache<K, V, S> mCountingMemoryCache;

    public ReferenceWrappingMemoryCache(CountingMemoryCache<K, V, S> countingMemoryCache) {
        this.mCountingMemoryCache = (CountingMemoryCache)Preconditions.checkNotNull(countingMemoryCache);
    }

    @Override
    public CloseableReference<V> get(K key, @Nullable S lookupStrategy) {
        return this.wrapCacheReferenceIfNotNull(key, this.mCountingMemoryCache.get(key, lookupStrategy));
    }

    @Override
    public CloseableReference<V> cache(K key, CloseableReference<V> value) {
        return this.wrapCacheReferenceIfNotNull(key, this.mCountingMemoryCache.cache(key, value));
    }

    @Override
    public long removeAll(Predicate<K> match) {
        return this.mCountingMemoryCache.removeAll(match);
    }

    private CloseableReference<V> wrapCacheReferenceIfNotNull(final K key, final @Nullable CloseableReference<V> value) {
        if (value == null) {
            return null;
        }
        return CloseableReference.of((Object)value.get(), (ResourceReleaser)new ResourceReleaser<V>(){

            public void release(V unused) {
                ReferenceWrappingMemoryCache.this.mCountingMemoryCache.release(key, value);
            }
        });
    }
}

