/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import android.os.Build;
import com.facebook.common.logging.FLog;
import com.facebook.common.memory.MemoryTrimType;
import com.facebook.imagepipeline.cache.CountingMemoryCache;

public class BitmapMemoryCacheTrimStrategy
implements CountingMemoryCache.CacheTrimStrategy {
    private static final String TAG = "BitmapMemoryCacheTrimStrategy";

    @Override
    public void trimCache(CountingMemoryCache<?, ?, ?> cache, MemoryTrimType trimType) {
        switch (trimType) {
            case OnCloseToDalvikHeapLimit: {
                if (Build.VERSION.SDK_INT < 21) break;
                double cacheTrimTarget = 1.0 - MemoryTrimType.OnCloseToDalvikHeapLimit.getSuggestedTrimRatio();
                int cacheSizeTarget = (int)(cacheTrimTarget * (double)cache.getSizeInBytes());
                cache.trimCacheTo(Integer.MAX_VALUE, cacheSizeTarget);
                break;
            }
            case OnAppBackgrounded: 
            case OnSystemLowMemoryWhileAppInForeground: 
            case OnSystemLowMemoryWhileAppInBackground: {
                cache.clearEvictionQueue();
                break;
            }
            default: {
                FLog.wtf((String)TAG, (String)"unknown trim type: %s", (Object[])new Object[]{trimType});
            }
        }
    }
}

